/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.locking.LockCountVisitor;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;

public class GraphDatabaseShutdownTest {
    @Test
    public void transactionShouldReleaseLocksWhenGraphDbIsBeingShutdown() throws Exception {
        GraphDatabaseAPI db = this.newDb();
        Locks locks = (Locks)db.getDependencyResolver().resolveDependency(Locks.class);
        Assert.assertEquals((long)0L, (long)GraphDatabaseShutdownTest.lockCount(locks));
        Exception exceptionThrownByTxClose = null;
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            tx.acquireWriteLock((PropertyContainer)node);
            Assert.assertEquals((long)1L, (long)GraphDatabaseShutdownTest.lockCount(locks));
            db.shutdown();
            db.createNode();
            tx.success();
        }
        catch (Exception e) {
            exceptionThrownByTxClose = e;
        }
        Assert.assertThat((Object)exceptionThrownByTxClose, (Matcher)Matchers.instanceOf(DatabaseShutdownException.class));
        Assert.assertFalse((boolean)db.isAvailable(1L));
        Assert.assertEquals((long)0L, (long)GraphDatabaseShutdownTest.lockCount(locks));
    }

    @Test
    public void shouldBeAbleToShutdownWhenThereAreTransactionsWaitingForLocks() throws Exception {
        Node node;
        GraphDatabaseAPI db = this.newDb();
        try (Transaction tx = db.beginTx();){
            node = db.createNode();
            tx.success();
        }
        CountDownLatch nodeLockedLatch = new CountDownLatch(1);
        Executors.newSingleThreadExecutor().submit(new Callable<Void>((GraphDatabaseService)db, node, nodeLockedLatch){
            final /* synthetic */ GraphDatabaseService val$db;
            final /* synthetic */ Node val$node;
            final /* synthetic */ CountDownLatch val$nodeLockedLatch;
            {
                this.val$db = graphDatabaseService;
                this.val$node = node;
                this.val$nodeLockedLatch = countDownLatch;
            }

            @Override
            public Void call() throws Exception {
                try (Transaction tx = this.val$db.beginTx();){
                    this.val$node.addLabel(DynamicLabel.label((String)"ABC"));
                    this.val$nodeLockedLatch.countDown();
                    Thread.sleep(1000L);
                    this.val$db.shutdown();
                    tx.success();
                }
                return null;
            }
        });
        Future<Void> secondTxResult = Executors.newSingleThreadExecutor().submit(new Callable<Void>((GraphDatabaseService)db, nodeLockedLatch, node){
            final /* synthetic */ GraphDatabaseService val$db;
            final /* synthetic */ CountDownLatch val$nodeLockedLatch;
            final /* synthetic */ Node val$node;
            {
                this.val$db = graphDatabaseService;
                this.val$nodeLockedLatch = countDownLatch;
                this.val$node = node;
            }

            @Override
            public Void call() throws Exception {
                try (Transaction tx = this.val$db.beginTx();){
                    this.val$nodeLockedLatch.await();
                    this.val$node.addLabel(DynamicLabel.label((String)"DEF"));
                    tx.success();
                }
                return null;
            }
        });
        try {
            secondTxResult.get(60L, TimeUnit.SECONDS);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)Exceptions.rootCause((Throwable)e), (Matcher)Matchers.instanceOf(TransactionTerminatedException.class));
        }
    }

    private static int lockCount(Locks locks) {
        LockCountVisitor lockCountVisitor = new LockCountVisitor();
        locks.accept((Locks.Visitor)lockCountVisitor);
        return lockCountVisitor.getLockCount();
    }

    private GraphDatabaseAPI newDb() {
        return (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.shutdown_transaction_end_timeout, "1s").newGraphDatabase();
    }
}

