/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.graphdb.QueryExecutionType;

@RunWith(value=Parameterized.class)
public class QueryExecutionTypeTest {
    private final Assumptions expected;

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> cases() {
        return Arrays.asList(QueryExecutionTypeTest.verify(QueryExecutionTypeTest.that(QueryExecutionType.query((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_ONLY)).canContainResults()), QueryExecutionTypeTest.verify(QueryExecutionTypeTest.that(QueryExecutionType.query((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_WRITE)).canContainResults().canUpdateData()), QueryExecutionTypeTest.verify(QueryExecutionTypeTest.that(QueryExecutionType.query((QueryExecutionType.QueryType)QueryExecutionType.QueryType.WRITE)).canUpdateData()), QueryExecutionTypeTest.verify(QueryExecutionTypeTest.that(QueryExecutionType.query((QueryExecutionType.QueryType)QueryExecutionType.QueryType.SCHEMA_WRITE)).canUpdateSchema()), QueryExecutionTypeTest.verify(QueryExecutionTypeTest.that(QueryExecutionType.profiled((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_ONLY)).isExplained().isProfiled().canContainResults()), QueryExecutionTypeTest.verify(QueryExecutionTypeTest.that(QueryExecutionType.profiled((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_WRITE)).isExplained().isProfiled().canContainResults().canUpdateData()), QueryExecutionTypeTest.verify(QueryExecutionTypeTest.that(QueryExecutionType.profiled((QueryExecutionType.QueryType)QueryExecutionType.QueryType.WRITE)).isExplained().isProfiled().canUpdateData()), QueryExecutionTypeTest.verify(QueryExecutionTypeTest.that(QueryExecutionType.profiled((QueryExecutionType.QueryType)QueryExecutionType.QueryType.SCHEMA_WRITE)).isExplained().isProfiled().canUpdateSchema()), QueryExecutionTypeTest.verify(QueryExecutionTypeTest.that(QueryExecutionType.explained((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_ONLY)).isExplained().isOnlyExplained()), QueryExecutionTypeTest.verify(QueryExecutionTypeTest.that(QueryExecutionType.explained((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_WRITE)).isExplained().isOnlyExplained()), QueryExecutionTypeTest.verify(QueryExecutionTypeTest.that(QueryExecutionType.explained((QueryExecutionType.QueryType)QueryExecutionType.QueryType.WRITE)).isExplained().isOnlyExplained()), QueryExecutionTypeTest.verify(QueryExecutionTypeTest.that(QueryExecutionType.explained((QueryExecutionType.QueryType)QueryExecutionType.QueryType.SCHEMA_WRITE)).isExplained().isOnlyExplained()), QueryExecutionTypeTest.verify(QueryExecutionTypeTest.thatQueryOf(QueryExecutionType.explained((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_ONLY)).canContainResults()), QueryExecutionTypeTest.verify(QueryExecutionTypeTest.thatQueryOf(QueryExecutionType.explained((QueryExecutionType.QueryType)QueryExecutionType.QueryType.READ_WRITE)).canContainResults().canUpdateData()), QueryExecutionTypeTest.verify(QueryExecutionTypeTest.thatQueryOf(QueryExecutionType.explained((QueryExecutionType.QueryType)QueryExecutionType.QueryType.WRITE)).canUpdateData()), QueryExecutionTypeTest.verify(QueryExecutionTypeTest.thatQueryOf(QueryExecutionType.explained((QueryExecutionType.QueryType)QueryExecutionType.QueryType.SCHEMA_WRITE)).canUpdateSchema()));
    }

    @Test
    public void verify() throws Exception {
        QueryExecutionType executionType = this.expected.type();
        Assert.assertEquals((Object)this.expected.isProfiled, (Object)executionType.isProfiled());
        Assert.assertEquals((Object)this.expected.requestedExecutionPlanDescription, (Object)executionType.requestedExecutionPlanDescription());
        Assert.assertEquals((Object)this.expected.isExplained, (Object)executionType.isExplained());
        Assert.assertEquals((Object)this.expected.canContainResults, (Object)executionType.canContainResults());
        Assert.assertEquals((Object)this.expected.canUpdateData, (Object)executionType.canUpdateData());
        Assert.assertEquals((Object)this.expected.canUpdateSchema, (Object)executionType.canUpdateSchema());
    }

    @Test
    public void noneOtherLikeIt() throws Exception {
        for (QueryExecutionType.QueryType queryType : QueryExecutionType.QueryType.values()) {
            for (QueryExecutionType type : new QueryExecutionType[]{QueryExecutionType.query((QueryExecutionType.QueryType)queryType), QueryExecutionType.profiled((QueryExecutionType.QueryType)queryType), QueryExecutionType.explained((QueryExecutionType.QueryType)queryType)}) {
                if (type == this.expected.type() || this.expected.type().isExplained() && type.isExplained()) continue;
                Assert.assertFalse((String)this.expected.type().toString(), (this.expected.isProfiled == type.isProfiled() && this.expected.requestedExecutionPlanDescription == type.requestedExecutionPlanDescription() && this.expected.isExplained == type.isExplained() && this.expected.canContainResults == type.canContainResults() && this.expected.canUpdateData == type.canUpdateData() && this.expected.canUpdateSchema == type.canUpdateSchema() ? 1 : 0) != 0);
            }
        }
    }

    public QueryExecutionTypeTest(Assumptions expected) {
        this.expected = expected;
    }

    private static Object[] verify(Assumptions assumptions) {
        return new Object[]{assumptions};
    }

    private static Assumptions that(QueryExecutionType type) {
        return new Assumptions(type, false);
    }

    private static Assumptions thatQueryOf(QueryExecutionType type) {
        return new Assumptions(type, true);
    }

    static class Assumptions {
        final QueryExecutionType type;
        final boolean convertToQuery;
        boolean isProfiled;
        boolean requestedExecutionPlanDescription;
        boolean isExplained;
        boolean canContainResults;
        boolean canUpdateData;
        boolean canUpdateSchema;

        public Assumptions(QueryExecutionType type, boolean convertToQuery) {
            this.type = type;
            this.convertToQuery = convertToQuery;
        }

        public String toString() {
            StringBuilder result = new StringBuilder(this.type.toString());
            if (this.convertToQuery) {
                result.append(" (as query)");
            }
            String sep = ": ";
            for (Field field : this.getClass().getDeclaredFields()) {
                boolean value;
                if (field.getType() != Boolean.TYPE) continue;
                field.setAccessible(true);
                try {
                    value = field.getBoolean(this);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                result.append(sep).append('.').append(field.getName()).append("() == ").append(value);
                sep = ", ";
            }
            return result.toString();
        }

        public Assumptions isProfiled() {
            this.isProfiled = true;
            return this;
        }

        public Assumptions isExplained() {
            this.requestedExecutionPlanDescription = true;
            return this;
        }

        public Assumptions isOnlyExplained() {
            this.isExplained = true;
            return this;
        }

        public Assumptions canContainResults() {
            this.canContainResults = true;
            return this;
        }

        public Assumptions canUpdateData() {
            this.canUpdateData = true;
            return this;
        }

        public Assumptions canUpdateSchema() {
            this.canUpdateSchema = true;
            return this;
        }

        public QueryExecutionType type() {
            return this.convertToQuery ? QueryExecutionType.query((QueryExecutionType.QueryType)this.type.queryType()) : this.type;
        }
    }
}

