/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory;

import java.lang.reflect.Field;
import java.util.HashMap;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.configuration.Config;

public class GraphDatabaseSettingsTest {
    @Test
    public void mustHaveNullDefaultPageCacheMemorySizeInBytes() throws Exception {
        Long bytes = (Long)Config.defaults().get(GraphDatabaseSettings.pagecache_memory);
        Assert.assertThat((Object)bytes, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void pageCacheSettingMustAcceptArbitraryUserSpecifiedValue() throws Exception {
        Setting setting = GraphDatabaseSettings.pagecache_memory;
        String name = setting.name();
        Assert.assertThat((Object)new Config(MapUtil.stringMap((String[])new String[]{name, "245760"})).get(setting), (Matcher)Matchers.is((Object)ByteUnit.kibiBytes((long)240L)));
        Assert.assertThat((Object)new Config(MapUtil.stringMap((String[])new String[]{name, "2244g"})).get(setting), (Matcher)Matchers.is((Object)ByteUnit.gibiBytes((long)2244L)));
    }

    @Test(expected=InvalidSettingException.class)
    public void pageCacheSettingMustRejectOverlyConstrainedMemorySetting() throws Exception {
        long pageSize = (Long)Config.defaults().get(GraphDatabaseSettings.mapped_memory_page_size);
        Setting setting = GraphDatabaseSettings.pagecache_memory;
        String name = setting.name();
        new Config(MapUtil.stringMap((String[])new String[]{name, "" + (pageSize * 2L - 1L)})).get(setting);
    }

    @Test
    public void noDuplicateSettingsAreAllowed() throws Exception {
        HashMap<String, String> fields = new HashMap<String, String>();
        for (Field field : GraphDatabaseSettings.class.getDeclaredFields()) {
            if (field.getType() != Setting.class) continue;
            Setting setting = (Setting)field.get(null);
            Assert.assertFalse((String)String.format("'%s' in %s has already been defined in %s", setting.name(), field.getName(), fields.get(setting.name())), (boolean)fields.containsKey(setting.name()));
            fields.put(setting.name(), field.getName());
        }
    }

    @Test
    public void groupToScopeSetting() throws Exception {
        String hostname = "my_other_host";
        int port = 9999;
        Config config = Config.defaults();
        config.augment(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.default_advertised_address.name(), hostname}));
        String scoping = "bla";
        config.augment(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.boltConnector((String)scoping).advertised_address.name(), ":" + port}));
        GraphDatabaseSettings.BoltConnector boltConnector = GraphDatabaseSettings.boltConnector((String)scoping);
        Setting advertised_address = boltConnector.advertised_address;
        AdvertisedSocketAddress advertisedSocketAddress = (AdvertisedSocketAddress)config.get(advertised_address);
        Assert.assertEquals((Object)hostname, (Object)advertisedSocketAddress.getHostname());
        Assert.assertEquals((long)port, (long)advertisedSocketAddress.getPort());
    }

    @Test
    public void shouldBeAbleToDisableBoltConnectorWithJustOneParameter() throws Exception {
        Config config = Config.defaults();
        config.augment(MapUtil.stringMap((String[])new String[]{"dbms.connector.bolt.enabled", "false"}));
        Assert.assertThat((Object)GraphDatabaseSettings.boltConnectors((Config)config), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldBeAbleToOverrideBoltListenAddressesWithJustOneParameter() throws Exception {
        Config config = Config.defaults();
        config.augment(MapUtil.stringMap((String[])new String[]{"dbms.connector.bolt.enabled", "true"}));
        config.augment(MapUtil.stringMap((String[])new String[]{"dbms.connector.bolt.listen_address", ":8000"}));
        GraphDatabaseSettings.BoltConnector boltConnector = (GraphDatabaseSettings.BoltConnector)GraphDatabaseSettings.boltConnectors((Config)config).get(0);
        Assert.assertEquals((Object)new ListenSocketAddress("localhost", 8000), (Object)config.get(boltConnector.listen_address));
    }

    @Test
    public void shouldDeriveBoltListenAddressFromDefaultListenAddress() throws Exception {
        Config config = Config.defaults();
        config.augment(MapUtil.stringMap((String[])new String[]{"dbms.connector.bolt.enabled", "true"}));
        config.augment(MapUtil.stringMap((String[])new String[]{"dbms.connectors.default_listen_address", "0.0.0.0"}));
        GraphDatabaseSettings.BoltConnector boltConnector = (GraphDatabaseSettings.BoltConnector)GraphDatabaseSettings.boltConnectors((Config)config).get(0);
        Assert.assertEquals((Object)new ListenSocketAddress("0.0.0.0", 7687), (Object)config.get(boltConnector.listen_address));
    }

    @Test
    public void shouldDeriveBoltListenAddressFromDefaultListenAddressAndSpecifiedPort() throws Exception {
        Config config = Config.defaults();
        config.augment(MapUtil.stringMap((String[])new String[]{"dbms.connectors.default_listen_address", "0.0.0.0"}));
        config.augment(MapUtil.stringMap((String[])new String[]{"dbms.connector.bolt.enabled", "true"}));
        config.augment(MapUtil.stringMap((String[])new String[]{"dbms.connector.bolt.listen_address", ":8000"}));
        GraphDatabaseSettings.BoltConnector boltConnector = (GraphDatabaseSettings.BoltConnector)GraphDatabaseSettings.boltConnectors((Config)config).get(0);
        Assert.assertEquals((Object)new ListenSocketAddress("0.0.0.0", 8000), (Object)config.get(boltConnector.listen_address));
    }

    @Test
    public void shouldStillSupportCustomNameForBoltConnector() throws Exception {
        Config config = Config.defaults();
        config.augment(MapUtil.stringMap((String[])new String[]{"dbms.connector.random_name_that_will_be_unsupported.type", "BOLT"}));
        config.augment(MapUtil.stringMap((String[])new String[]{"dbms.connector.random_name_that_will_be_unsupported.enabled", "true"}));
        config.augment(MapUtil.stringMap((String[])new String[]{"dbms.connector.random_name_that_will_be_unsupported.listen_address", ":8000"}));
        GraphDatabaseSettings.BoltConnector boltConnector = (GraphDatabaseSettings.BoltConnector)GraphDatabaseSettings.boltConnectors((Config)config).get(0);
        Assert.assertEquals((Object)new ListenSocketAddress("localhost", 8000), (Object)config.get(boltConnector.listen_address));
    }

    @Test
    public void shouldSupportMultipleBoltConnectorsWithCustomNames() throws Exception {
        Config config = Config.defaults();
        config.augment(MapUtil.stringMap((String[])new String[]{"dbms.connector.bolt1.type", "BOLT"}));
        config.augment(MapUtil.stringMap((String[])new String[]{"dbms.connector.bolt1.enabled", "true"}));
        config.augment(MapUtil.stringMap((String[])new String[]{"dbms.connector.bolt1.listen_address", ":8000"}));
        config.augment(MapUtil.stringMap((String[])new String[]{"dbms.connector.bolt2.type", "BOLT"}));
        config.augment(MapUtil.stringMap((String[])new String[]{"dbms.connector.bolt2.enabled", "true"}));
        config.augment(MapUtil.stringMap((String[])new String[]{"dbms.connector.bolt2.listen_address", ":9000"}));
        GraphDatabaseSettings.BoltConnector boltConnector1 = (GraphDatabaseSettings.BoltConnector)GraphDatabaseSettings.boltConnectors((Config)config).get(0);
        GraphDatabaseSettings.BoltConnector boltConnector2 = (GraphDatabaseSettings.BoltConnector)GraphDatabaseSettings.boltConnectors((Config)config).get(1);
        Assert.assertEquals((Object)new ListenSocketAddress("localhost", 8000), (Object)config.get(boltConnector1.listen_address));
        Assert.assertEquals((Object)new ListenSocketAddress("localhost", 9000), (Object)config.get(boltConnector2.listen_address));
    }

    @Test
    public void shouldSupportMultipleBoltConnectorsWithDefaultAndCustomName() throws Exception {
        Config config = Config.defaults();
        config.augment(MapUtil.stringMap((String[])new String[]{"dbms.connector.bolt.type", "BOLT"}));
        config.augment(MapUtil.stringMap((String[])new String[]{"dbms.connector.bolt.enabled", "true"}));
        config.augment(MapUtil.stringMap((String[])new String[]{"dbms.connector.bolt.listen_address", ":8000"}));
        config.augment(MapUtil.stringMap((String[])new String[]{"dbms.connector.bolt2.type", "BOLT"}));
        config.augment(MapUtil.stringMap((String[])new String[]{"dbms.connector.bolt2.enabled", "true"}));
        config.augment(MapUtil.stringMap((String[])new String[]{"dbms.connector.bolt2.listen_address", ":9000"}));
        GraphDatabaseSettings.BoltConnector boltConnector1 = (GraphDatabaseSettings.BoltConnector)GraphDatabaseSettings.boltConnectors((Config)config).get(0);
        GraphDatabaseSettings.BoltConnector boltConnector2 = (GraphDatabaseSettings.BoltConnector)GraphDatabaseSettings.boltConnectors((Config)config).get(1);
        Assert.assertEquals((Object)new ListenSocketAddress("localhost", 8000), (Object)config.get(boltConnector1.listen_address));
        Assert.assertEquals((Object)new ListenSocketAddress("localhost", 9000), (Object)config.get(boltConnector2.listen_address));
    }
}

