/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.KernelTransactionFactory;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.api.security.SecurityContext;

public class TransactionStatementSequenceTest {
    @Test
    public void shouldAllowReadStatementAfterReadStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction((SecurityContext)AnonymousContext.read());
        tx.acquireStatement().readOperations();
        tx.acquireStatement().readOperations();
    }

    @Test
    public void shouldAllowDataStatementAfterReadStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction((SecurityContext)AnonymousContext.write());
        tx.acquireStatement().readOperations();
        tx.acquireStatement().dataWriteOperations();
    }

    @Test
    public void shouldAllowSchemaStatementAfterReadStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction(SecurityContext.AUTH_DISABLED);
        tx.acquireStatement().readOperations();
        tx.acquireStatement().schemaWriteOperations();
    }

    @Test
    public void shouldRejectSchemaStatementAfterDataStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction(SecurityContext.AUTH_DISABLED);
        tx.acquireStatement().dataWriteOperations();
        try {
            tx.acquireStatement().schemaWriteOperations();
            Assert.fail((String)"expected exception");
        }
        catch (InvalidTransactionTypeKernelException e) {
            Assert.assertEquals((Object)"Cannot perform schema updates in a transaction that has performed data updates.", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldRejectDataStatementAfterSchemaStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction(SecurityContext.AUTH_DISABLED);
        tx.acquireStatement().schemaWriteOperations();
        try {
            tx.acquireStatement().dataWriteOperations();
            Assert.fail((String)"expected exception");
        }
        catch (InvalidTransactionTypeKernelException e) {
            Assert.assertEquals((Object)"Cannot perform data updates in a transaction that has performed schema updates.", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldAllowDataStatementAfterDataStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction((SecurityContext)AnonymousContext.write());
        tx.acquireStatement().dataWriteOperations();
        tx.acquireStatement().dataWriteOperations();
    }

    @Test
    public void shouldAllowSchemaStatementAfterSchemaStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction(SecurityContext.AUTH_DISABLED);
        tx.acquireStatement().schemaWriteOperations();
        tx.acquireStatement().schemaWriteOperations();
    }

    @Test
    public void shouldAllowReadStatementAfterDataStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction((SecurityContext)AnonymousContext.write());
        tx.acquireStatement().dataWriteOperations();
        tx.acquireStatement().readOperations();
    }

    @Test
    public void shouldAllowReadStatementAfterSchemaStatement() throws Exception {
        KernelTransaction tx = KernelTransactionFactory.kernelTransaction(SecurityContext.AUTH_DISABLED);
        tx.acquireStatement().schemaWriteOperations();
        tx.acquireStatement().readOperations();
    }
}

