/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.File;
import org.junit.Before;
import org.junit.Rule;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.NonUniqueIndexAccessorCompatibility;
import org.neo4j.kernel.api.index.NonUniqueIndexPopulatorCompatibility;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.index.UniqueConstraintCompatibility;
import org.neo4j.kernel.api.index.UniqueIndexAccessorCompatibility;
import org.neo4j.kernel.api.index.UniqueIndexPopulatorCompatibility;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.test.runner.ParameterizedSuiteRunner;

@RunWith(value=ParameterizedSuiteRunner.class)
@Suite.SuiteClasses(value={NonUniqueIndexPopulatorCompatibility.class, UniqueIndexPopulatorCompatibility.class, NonUniqueIndexAccessorCompatibility.class, UniqueIndexAccessorCompatibility.class, UniqueConstraintCompatibility.class})
public abstract class IndexProviderCompatibilityTestSuite {
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public final TestDirectory testDir = TestDirectory.testDirectory(this.getClass());
    protected File graphDbDir;
    protected FileSystemAbstraction fs = this.fileSystemRule.get();

    @Before
    public void setup() {
        this.fs = this.fileSystemRule.get();
        this.graphDbDir = this.testDir.graphDbDir();
    }

    protected abstract SchemaIndexProvider createIndexProvider();

    public static abstract class Compatibility {
        protected final SchemaIndexProvider indexProvider;
        protected IndexDescriptor descriptor = new IndexDescriptor(1, 2);

        public Compatibility(IndexProviderCompatibilityTestSuite testSuite) {
            this.indexProvider = testSuite.createIndexProvider();
        }
    }
}

