/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.Strings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.mockito.matcher.Neo4jMatchers;

@RunWith(value=Parameterized.class)
public abstract class SchemaIndexProviderApprovalTest {
    private static Map<TestValue, Set<Object>> noIndexRun;
    private static Map<TestValue, Set<Object>> indexRun;
    private final TestValue currentValue;
    public static final String LABEL = "Person";
    public static final String PROPERTY_KEY = "name";
    public static final Function<Node, Object> PROPERTY_EXTRACTOR;

    public SchemaIndexProviderApprovalTest(TestValue value) {
        this.currentValue = value;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<TestValue> data() {
        return Arrays.asList(TestValue.values());
    }

    @BeforeClass
    public static void init() {
        GraphDatabaseService db = new TestGraphDatabaseFactory().newImpermanentDatabase();
        for (TestValue value : TestValue.values()) {
            SchemaIndexProviderApprovalTest.createNode(db, PROPERTY_KEY, value.value);
        }
        noIndexRun = SchemaIndexProviderApprovalTest.runFindByLabelAndProperty(db);
        Neo4jMatchers.createIndex(db, Label.label((String)LABEL), PROPERTY_KEY);
        indexRun = SchemaIndexProviderApprovalTest.runFindByLabelAndProperty(db);
        db.shutdown();
    }

    @Test
    public void test() {
        Set noIndexResult = Iterables.asSet((Iterable)noIndexRun.get((Object)this.currentValue));
        Set indexResult = Iterables.asSet((Iterable)indexRun.get((Object)this.currentValue));
        String errorMessage = this.currentValue.toString();
        Assert.assertEquals((String)errorMessage, (Object)noIndexResult, (Object)indexResult);
    }

    private static Map<TestValue, Set<Object>> runFindByLabelAndProperty(GraphDatabaseService db) {
        HashMap<TestValue, Set<Object>> results = new HashMap<TestValue, Set<Object>>();
        try (Transaction tx = db.beginTx();){
            for (TestValue value : TestValue.values()) {
                SchemaIndexProviderApprovalTest.addToResults(db, results, value);
            }
            tx.success();
        }
        return results;
    }

    private static Node createNode(GraphDatabaseService db, String propertyKey, Object value) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode(new Label[]{Label.label((String)LABEL)});
            node.setProperty(propertyKey, value);
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    private static void addToResults(GraphDatabaseService db, HashMap<TestValue, Set<Object>> results, TestValue value) {
        ResourceIterator foundNodes = db.findNodes(Label.label((String)LABEL), PROPERTY_KEY, value.value);
        Set propertyValues = Iterators.asSet((Iterator)Iterators.map(PROPERTY_EXTRACTOR, (Iterator)foundNodes));
        results.put(value, propertyValues);
    }

    static {
        PROPERTY_EXTRACTOR = node -> {
            Object value = node.getProperty(PROPERTY_KEY);
            if (value.getClass().isArray()) {
                return new ArrayEqualityObject(value);
            }
            return value;
        };
    }

    private static class ArrayEqualityObject {
        private final Object array;

        ArrayEqualityObject(Object array) {
            this.array = array;
        }

        public int hashCode() {
            return ArrayUtil.hashCode((Object)this.array);
        }

        public boolean equals(Object obj) {
            return obj instanceof ArrayEqualityObject && ArrayUtil.equals((Object)this.array, (Object)((ArrayEqualityObject)obj).array);
        }

        public String toString() {
            return Strings.prettyPrint((Object)this.array);
        }
    }

    public static enum TestValue {
        BOOLEAN_TRUE(true),
        BOOLEAN_FALSE(false),
        STRING_TRUE("true"),
        STRING_FALSE("false"),
        STRING_UPPER_A("A"),
        STRING_LOWER_A("a"),
        CHAR_UPPER_A(Character.valueOf('A')),
        CHAR_LOWER_A(Character.valueOf('a')),
        INT_42(42),
        LONG_42(42L),
        LARGE_LONG_1(0x4000000000000001L),
        LARGE_LONG_2(0x4000000000000003L),
        BYTE_42((byte)42),
        DOUBLE_42(42.0),
        DOUBLE_42andAHalf(42.5),
        SHORT_42((short)42),
        FLOAT_42(Float.valueOf(42.0f)),
        FLOAT_42andAHalf(Float.valueOf(42.5f)),
        ARRAY_OF_INTS(new int[]{1, 2, 3}),
        ARRAY_OF_LONGS(new long[]{1L, 2L, 3L}),
        ARRAY_OF_LARGE_LONGS_1(new long[]{0x4000000000000001L}),
        ARRAY_OF_LARGE_LONGS_2(new long[]{0x4000000000000002L}),
        ARRAY_OF_LARGE_LONGS_3(new Long[]{4611686018425387907L}),
        ARRAY_OF_LARGE_LONGS_4(new Long[]{4611686018425387908L}),
        ARRAY_OF_BOOL_LIKE_STRING(new String[]{"true", "false", "true"}),
        ARRAY_OF_BOOLS(new boolean[]{true, false, true}),
        ARRAY_OF_DOUBLES(new double[]{1.0, 2.0, 3.0}),
        ARRAY_OF_STRING(new String[]{"1", "2", "3"}),
        EMPTY_ARRAY_OF_INTS(new int[0]),
        EMPTY_ARRAY_OF_LONGS(new long[0]),
        EMPTY_ARRAY_OF_BOOLS(new boolean[0]),
        EMPTY_ARRAY_OF_DOUBLES(new double[0]),
        EMPTY_ARRAY_OF_STRING(new String[0]),
        ONE(new String[]{"", "||"}),
        OTHER(new String[]{"||", ""}),
        ANOTHER_ARRAY_OF_STRING(new String[]{"1|2|3"}),
        ARRAY_OF_CHAR(new char[]{'1', '2', '3'});

        private final Object value;

        private TestValue(Object value) {
            this.value = value;
        }
    }
}

