/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.collection.RawIterator;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.SchemaWriteOperations;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;

public class SchemaProcedureIT
extends KernelIntegrationTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testEmptyGraph() throws Throwable {
        RawIterator stream = this.procedureCallOpsInNewTx().procedureCallRead(ProcedureSignature.procedureName((String[])new String[]{"db", "schema"}), new Object[0]);
        MatcherAssert.assertThat((Object)Iterators.asList((RawIterator)stream), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)new Object[]{new ArrayList(), new ArrayList()})));
    }

    @Test
    public void testLabelIndex() throws Throwable {
        DataWriteOperations ops = this.dataWriteOperationsInNewTransaction();
        long nodeId = ops.nodeCreate();
        int labelId = ops.labelGetOrCreateForName("Person");
        ops.nodeAddLabel(nodeId, labelId);
        int propertyIdName = ops.propertyKeyGetOrCreateForName("name");
        int propertyIdAge = ops.propertyKeyGetOrCreateForName("age");
        ops.nodeSetProperty(nodeId, DefinedProperty.stringProperty((int)propertyIdName, (String)"Emil"));
        this.commit();
        SchemaWriteOperations schemaOps = this.schemaWriteOperationsInNewTransaction();
        schemaOps.indexCreate(labelId, propertyIdName);
        schemaOps.uniquePropertyConstraintCreate(labelId, propertyIdAge);
        this.commit();
        RawIterator stream = this.procedureCallOpsInNewTx().procedureCallRead(ProcedureSignature.procedureName((String[])new String[]{"db", "schema"}), new Object[0]);
        while (stream.hasNext()) {
            Object[] next = (Object[])stream.next();
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            ArrayList nodes = (ArrayList)next[0];
            Assert.assertTrue((nodes.size() == 1 ? 1 : 0) != 0);
            MatcherAssert.assertThat((Object)((Node)nodes.get(0)).getLabels(), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)Label.label((String)"Person"))));
            Assert.assertEquals(((Node)nodes.get(0)).getAllProperties().get("name"), (Object)new String("Person"));
            Assert.assertEquals(((Node)nodes.get(0)).getAllProperties().get("indexes"), Arrays.asList("name"));
            Assert.assertEquals(((Node)nodes.get(0)).getAllProperties().get("constraints"), Arrays.asList("CONSTRAINT ON ( person:Person ) ASSERT person.age IS UNIQUE"));
        }
    }

    @Test
    public void testRelationShip() throws Throwable {
        DataWriteOperations ops = this.dataWriteOperationsInNewTransaction();
        long nodeIdPerson = ops.nodeCreate();
        int labelIdPerson = ops.labelGetOrCreateForName("Person");
        ops.nodeAddLabel(nodeIdPerson, labelIdPerson);
        long nodeIdLocation = ops.nodeCreate();
        int labelIdLocation = ops.labelGetOrCreateForName("Location");
        ops.nodeAddLabel(nodeIdLocation, labelIdLocation);
        ops.relationshipCreate(ops.relationshipTypeGetOrCreateForName("LIVES_IN"), nodeIdPerson, nodeIdLocation);
        this.commit();
        RawIterator stream = this.procedureCallOpsInNewTx().procedureCallRead(ProcedureSignature.procedureName((String[])new String[]{"db", "schema"}), new Object[0]);
        while (stream.hasNext()) {
            Object[] next = (Object[])stream.next();
            Assert.assertTrue((next.length == 2 ? 1 : 0) != 0);
            LinkedList relationships = (LinkedList)next[1];
            Assert.assertTrue((relationships.size() == 1 ? 1 : 0) != 0);
            Assert.assertEquals((Object)"LIVES_IN", (Object)((Relationship)relationships.get(0)).getType().name());
            MatcherAssert.assertThat((Object)((Relationship)relationships.get(0)).getStartNode().getLabels(), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)Label.label((String)"Person"))));
            MatcherAssert.assertThat((Object)((Relationship)relationships.get(0)).getEndNode().getLabels(), (Matcher)Matchers.contains((Matcher)IsEqual.equalTo((Object)Label.label((String)"Location"))));
        }
    }
}

