/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.counts;

import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.Barrier;
import org.neo4j.test.NamedFunction;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;
import org.neo4j.test.rule.concurrent.ThreadingRule;

public class RelationshipCountsTest {
    @Rule
    public final DatabaseRule db = new ImpermanentDatabaseRule();
    @Rule
    public final ThreadingRule threading = new ThreadingRule();
    private Supplier<Statement> statementSupplier;

    @Test
    public void shouldReportNumberOfRelationshipsInAnEmptyGraph() throws Exception {
        long relationshipCount = this.numberOfRelationships();
        Assert.assertEquals((long)0L, (long)relationshipCount);
    }

    @Test
    public void shouldReportTotalNumberOfRelationships() throws Exception {
        long during;
        GraphDatabaseAPI graphDb = this.db.getGraphDatabaseAPI();
        long before = this.numberOfRelationships();
        try (Transaction tx = graphDb.beginTx();){
            Node node = graphDb.createNode();
            node.createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"KNOWS"));
            node.createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"KNOWS"));
            node.createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"KNOWS"));
            during = this.countsForRelationship(null, null, null);
            tx.success();
        }
        long after = this.numberOfRelationships();
        Assert.assertEquals((long)0L, (long)before);
        Assert.assertEquals((long)3L, (long)during);
        Assert.assertEquals((long)3L, (long)after);
    }

    @Test
    public void shouldAccountForDeletedRelationships() throws Exception {
        long during;
        Relationship rel;
        GraphDatabaseAPI graphDb = this.db.getGraphDatabaseAPI();
        try (Transaction tx = graphDb.beginTx();){
            Node node = graphDb.createNode();
            node.createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"KNOWS"));
            rel = node.createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"KNOWS"));
            node.createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"KNOWS"));
            tx.success();
        }
        long before = this.numberOfRelationships();
        try (Transaction tx = graphDb.beginTx();){
            rel.delete();
            during = this.countsForRelationship(null, null, null);
            tx.success();
        }
        long after = this.numberOfRelationships();
        Assert.assertEquals((long)3L, (long)before);
        Assert.assertEquals((long)2L, (long)during);
        Assert.assertEquals((long)2L, (long)after);
    }

    @Test
    public void shouldNotCountRelationshipsCreatedInOtherTransaction() throws Exception {
        GraphDatabaseAPI graphDb = this.db.getGraphDatabaseAPI();
        final Barrier.Control barrier = new Barrier.Control();
        long before = this.numberOfRelationships();
        Future<Long> tx = this.threading.execute(new NamedFunction<GraphDatabaseService, Long>("create-relationships"){

            public Long apply(GraphDatabaseService graphDb) {
                try (Transaction tx = graphDb.beginTx();){
                    Node node = graphDb.createNode();
                    node.createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"KNOWS"));
                    node.createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"KNOWS"));
                    long whatThisThreadSees = RelationshipCountsTest.this.countsForRelationship(null, null, null);
                    barrier.reached();
                    tx.success();
                    Long l = whatThisThreadSees;
                    return l;
                }
            }
        }, graphDb);
        barrier.await();
        long during = this.numberOfRelationships();
        barrier.release();
        long whatOtherThreadSees = tx.get();
        long after = this.numberOfRelationships();
        Assert.assertEquals((long)0L, (long)before);
        Assert.assertEquals((long)0L, (long)during);
        Assert.assertEquals((long)2L, (long)after);
        Assert.assertEquals((long)after, (long)whatOtherThreadSees);
    }

    @Test
    public void shouldNotCountRelationshipsDeletedInOtherTransaction() throws Exception {
        Relationship rel;
        GraphDatabaseAPI graphDb = this.db.getGraphDatabaseAPI();
        try (Transaction tx = graphDb.beginTx();){
            Node node = graphDb.createNode();
            node.createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"KNOWS"));
            rel = node.createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"KNOWS"));
            node.createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"KNOWS"));
            tx.success();
        }
        final Barrier.Control barrier = new Barrier.Control();
        long before = this.numberOfRelationships();
        Future<Long> tx = this.threading.execute(new NamedFunction<GraphDatabaseService, Long>("create-relationships"){

            public Long apply(GraphDatabaseService graphDb) {
                try (Transaction tx = graphDb.beginTx();){
                    rel.delete();
                    long whatThisThreadSees = RelationshipCountsTest.this.countsForRelationship(null, null, null);
                    barrier.reached();
                    tx.success();
                    Long l = whatThisThreadSees;
                    return l;
                }
            }
        }, graphDb);
        barrier.await();
        long during = this.numberOfRelationships();
        barrier.release();
        long whatOtherThreadSees = tx.get();
        long after = this.numberOfRelationships();
        Assert.assertEquals((long)3L, (long)before);
        Assert.assertEquals((long)3L, (long)during);
        Assert.assertEquals((long)2L, (long)after);
        Assert.assertEquals((long)after, (long)whatOtherThreadSees);
    }

    @Test
    public void shouldCountRelationshipsByType() throws Exception {
        GraphDatabaseAPI graphDb = this.db.getGraphDatabaseAPI();
        try (Transaction tx = graphDb.beginTx();){
            graphDb.createNode().createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"FOO"));
            graphDb.createNode().createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"FOO"));
            graphDb.createNode().createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"BAR"));
            graphDb.createNode().createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"BAR"));
            graphDb.createNode().createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"BAR"));
            graphDb.createNode().createRelationshipTo(graphDb.createNode(), RelationshipType.withName((String)"BAZ"));
            tx.success();
        }
        long total = this.numberOfRelationships();
        long foo = this.numberOfRelationships(RelationshipType.withName((String)"FOO"));
        long bar = this.numberOfRelationships(RelationshipType.withName((String)"BAR"));
        long baz = this.numberOfRelationships(RelationshipType.withName((String)"BAZ"));
        long qux = this.numberOfRelationships(RelationshipType.withName((String)"QUX"));
        Assert.assertEquals((long)2L, (long)foo);
        Assert.assertEquals((long)3L, (long)bar);
        Assert.assertEquals((long)1L, (long)baz);
        Assert.assertEquals((long)0L, (long)qux);
        Assert.assertEquals((long)6L, (long)total);
    }

    @Test
    public void shouldUpdateRelationshipWithLabelCountsWhenDeletingNodeWithRelationship() throws Exception {
        Node foo;
        try (Transaction tx = this.db.beginTx();){
            foo = this.db.createNode(Label.label((String)"Foo"));
            Node bar = this.db.createNode(Label.label((String)"Bar"));
            foo.createRelationshipTo(bar, RelationshipType.withName((String)"BAZ"));
            tx.success();
        }
        long before = this.numberOfRelationshipsMatching(Label.label((String)"Foo"), RelationshipType.withName((String)"BAZ"), null);
        try (Transaction tx = this.db.beginTx();){
            for (Relationship relationship : foo.getRelationships()) {
                relationship.delete();
            }
            foo.delete();
            tx.success();
        }
        long after = this.numberOfRelationshipsMatching(Label.label((String)"Foo"), RelationshipType.withName((String)"BAZ"), null);
        Assert.assertEquals((long)(before - 1L), (long)after);
    }

    @Test
    public void shouldUpdateRelationshipWithLabelCountsWhenRemovingLabelAndDeletingRelationship() throws Exception {
        Node foo;
        try (Transaction tx = this.db.beginTx();){
            foo = this.db.createNode(Label.label((String)"Foo"));
            Node bar = this.db.createNode(Label.label((String)"Bar"));
            foo.createRelationshipTo(bar, RelationshipType.withName((String)"BAZ"));
            tx.success();
        }
        long before = this.numberOfRelationshipsMatching(Label.label((String)"Foo"), RelationshipType.withName((String)"BAZ"), null);
        try (Transaction tx = this.db.beginTx();){
            for (Relationship relationship : foo.getRelationships()) {
                relationship.delete();
            }
            foo.removeLabel(Label.label((String)"Foo"));
            tx.success();
        }
        long after = this.numberOfRelationshipsMatching(Label.label((String)"Foo"), RelationshipType.withName((String)"BAZ"), null);
        Assert.assertEquals((long)(before - 1L), (long)after);
    }

    private long numberOfRelationships(RelationshipType type) {
        return this.numberOfRelationshipsMatching(null, type, null);
    }

    private long numberOfRelationships() {
        return this.numberOfRelationshipsMatching(null, null, null);
    }

    private long numberOfRelationshipsMatching(Label lhs, RelationshipType type, Label rhs) {
        try (Transaction tx = this.db.getGraphDatabaseAPI().beginTx();){
            long nodeCount = this.countsForRelationship(lhs, type, rhs);
            tx.success();
            long l = nodeCount;
            return l;
        }
    }

    private long countsForRelationship(Label start, RelationshipType type, Label end) {
        int endId;
        int typeId;
        int startId;
        ReadOperations read = this.statementSupplier.get().readOperations();
        if (start == null) {
            startId = -1;
        } else {
            startId = read.labelGetForName(start.name());
            if (-1 == startId) {
                return 0L;
            }
        }
        if (type == null) {
            typeId = -1;
        } else {
            typeId = read.relationshipTypeGetForName(type.name());
            if (-1 == typeId) {
                return 0L;
            }
        }
        if (end == null) {
            endId = -1;
        } else {
            endId = read.labelGetForName(end.name());
            if (-1 == endId) {
                return 0L;
            }
        }
        return read.countsForRelationship(startId, typeId, endId);
    }

    @Before
    public void exposeGuts() {
        this.statementSupplier = (Supplier)this.db.getGraphDatabaseAPI().getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
    }
}

