/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.apache.commons.lang3.RandomUtils;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.kernel.impl.api.IndexValueLengthValidator;

public class IndexValueLengthValidatorTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void tooLongByteArrayIsNotAllowed() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Property value bytes length: 35000 is longer then 32766, which is maximum supported length of indexed property value.");
        IndexValueLengthValidator.INSTANCE.validate(RandomUtils.nextBytes((int)35000));
    }

    @Test
    public void stringOverExceedLimitNotAllowed() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Property value bytes length: 32767 is longer then 32766, which is maximum supported length of indexed property value.");
        IndexValueLengthValidator.INSTANCE.validate(RandomUtils.nextBytes((int)Short.MAX_VALUE));
    }

    @Test
    public void shortByteArrayIsValid() {
        IndexValueLengthValidator.INSTANCE.validate(RandomUtils.nextBytes((int)3));
        IndexValueLengthValidator.INSTANCE.validate(RandomUtils.nextBytes((int)30));
        IndexValueLengthValidator.INSTANCE.validate(RandomUtils.nextBytes((int)300));
        IndexValueLengthValidator.INSTANCE.validate(RandomUtils.nextBytes((int)4303));
        IndexValueLengthValidator.INSTANCE.validate(RandomUtils.nextBytes((int)13234));
        IndexValueLengthValidator.INSTANCE.validate(RandomUtils.nextBytes((int)32766));
    }
}

