/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.File;
import java.util.Map;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.factory.CommunityEditionModule;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.EditionModule;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.test.ImpermanentGraphDatabase;

public class KernelTest {
    @Test
    public void shouldNotAllowCreationOfConstraintsWhenInHA() throws Exception {
        FakeHaDatabase db = new FakeHaDatabase();
        ThreadToStatementContextBridge stmtBridge = (ThreadToStatementContextBridge)db.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
        try (Transaction ignored = db.beginTx();){
            Statement statement = stmtBridge.get();
            try {
                statement.schemaWriteOperations().uniquePropertyConstraintCreate(1, 1);
                Assert.fail((String)"expected exception here");
            }
            catch (InvalidTransactionTypeKernelException e) {
                Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"HA"));
            }
        }
        db.shutdown();
    }

    class FakeHaDatabase
    extends ImpermanentGraphDatabase {
        FakeHaDatabase() {
        }

        @Override
        protected void create(File storeDir, Map<String, String> params, GraphDatabaseFacadeFactory.Dependencies dependencies) {
            Function<PlatformModule, EditionModule> factory = platformModule -> new CommunityEditionModule((PlatformModule)platformModule){

                protected SchemaWriteGuard createSchemaWriteGuard() {
                    return () -> {
                        throw new InvalidTransactionTypeKernelException("Creation or deletion of constraints is not possible while running in a HA cluster. In order to do that, please restart in non-HA mode and propagate the database copyto all slaves");
                    };
                }
            };
            new GraphDatabaseFacadeFactory(DatabaseInfo.COMMUNITY, factory){

                protected PlatformModule createPlatform(File storeDir, Map<String, String> params, GraphDatabaseFacadeFactory.Dependencies dependencies, GraphDatabaseFacade graphDatabaseFacade) {
                    return new ImpermanentGraphDatabase.ImpermanentPlatformModule(storeDir, params, this.databaseInfo, dependencies, graphDatabaseFacade);
                }
            }.initFacade(storeDir, params, dependencies, (GraphDatabaseFacade)this);
        }
    }
}

