/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.api.CommandVisitor;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.api.TransactionApplierFacade;
import org.neo4j.kernel.impl.index.IndexCommand;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.storageengine.api.StorageCommand;

public class TransactionApplierFacadeTest {
    private TransactionApplierFacade facade;
    private TransactionApplier txApplier1;
    private TransactionApplier txApplier2;
    private TransactionApplier txApplier3;

    @Before
    public void setUp() throws Exception {
        this.txApplier1 = (TransactionApplier)Mockito.mock(TransactionApplier.class);
        this.txApplier2 = (TransactionApplier)Mockito.mock(TransactionApplier.class);
        this.txApplier3 = (TransactionApplier)Mockito.mock(TransactionApplier.class);
        this.facade = new TransactionApplierFacade(new TransactionApplier[]{this.txApplier1, this.txApplier2, this.txApplier3});
    }

    @Test
    public void testClose() throws Exception {
        this.facade.close();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.txApplier1, this.txApplier2, this.txApplier3});
        ((TransactionApplier)inOrder.verify((Object)this.txApplier3)).close();
        ((TransactionApplier)inOrder.verify((Object)this.txApplier2)).close();
        ((TransactionApplier)inOrder.verify((Object)this.txApplier1)).close();
    }

    @Test
    public void testVisit() throws Exception {
        Command cmd = (Command)Mockito.mock(Command.class);
        boolean result = this.facade.visit((StorageCommand)cmd);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{cmd});
        ((Command)inOrder.verify((Object)cmd)).handle((CommandVisitor)this.txApplier1);
        ((Command)inOrder.verify((Object)cmd)).handle((CommandVisitor)this.txApplier2);
        ((Command)inOrder.verify((Object)cmd)).handle((CommandVisitor)this.txApplier3);
        inOrder.verifyNoMoreInteractions();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testVisitNodeCommand() throws Exception {
        Command.NodeCommand cmd = (Command.NodeCommand)Mockito.mock(Command.NodeCommand.class);
        Mockito.when((Object)cmd.handle((CommandVisitor)Matchers.any(CommandVisitor.class))).thenCallRealMethod();
        boolean result = this.facade.visitNodeCommand(cmd);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.txApplier1, this.txApplier2, this.txApplier3});
        ((TransactionApplier)inOrder.verify((Object)this.txApplier1)).visitNodeCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier2)).visitNodeCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier3)).visitNodeCommand(cmd);
        inOrder.verifyNoMoreInteractions();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testVisitRelationshipCommand() throws Exception {
        Command.RelationshipCommand cmd = (Command.RelationshipCommand)Mockito.mock(Command.RelationshipCommand.class);
        Mockito.when((Object)cmd.handle((CommandVisitor)Matchers.any(CommandVisitor.class))).thenCallRealMethod();
        boolean result = this.facade.visitRelationshipCommand(cmd);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.txApplier1, this.txApplier2, this.txApplier3});
        ((TransactionApplier)inOrder.verify((Object)this.txApplier1)).visitRelationshipCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier2)).visitRelationshipCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier3)).visitRelationshipCommand(cmd);
        inOrder.verifyNoMoreInteractions();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testVisitPropertyCommand() throws Exception {
        Command.PropertyCommand cmd = (Command.PropertyCommand)Mockito.mock(Command.PropertyCommand.class);
        Mockito.when((Object)cmd.handle((CommandVisitor)Matchers.any(CommandVisitor.class))).thenCallRealMethod();
        boolean result = this.facade.visitPropertyCommand(cmd);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.txApplier1, this.txApplier2, this.txApplier3});
        ((TransactionApplier)inOrder.verify((Object)this.txApplier1)).visitPropertyCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier2)).visitPropertyCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier3)).visitPropertyCommand(cmd);
        inOrder.verifyNoMoreInteractions();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testVisitRelationshipGroupCommand() throws Exception {
        Command.RelationshipGroupCommand cmd = (Command.RelationshipGroupCommand)Mockito.mock(Command.RelationshipGroupCommand.class);
        Mockito.when((Object)cmd.handle((CommandVisitor)Matchers.any(CommandVisitor.class))).thenCallRealMethod();
        boolean result = this.facade.visitRelationshipGroupCommand(cmd);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.txApplier1, this.txApplier2, this.txApplier3});
        ((TransactionApplier)inOrder.verify((Object)this.txApplier1)).visitRelationshipGroupCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier2)).visitRelationshipGroupCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier3)).visitRelationshipGroupCommand(cmd);
        inOrder.verifyNoMoreInteractions();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testVisitRelationshipTypeTokenCommand() throws Exception {
        Command.RelationshipTypeTokenCommand cmd = (Command.RelationshipTypeTokenCommand)Mockito.mock(Command.RelationshipTypeTokenCommand.class);
        Mockito.when((Object)cmd.handle((CommandVisitor)Matchers.any(CommandVisitor.class))).thenCallRealMethod();
        boolean result = this.facade.visitRelationshipTypeTokenCommand(cmd);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.txApplier1, this.txApplier2, this.txApplier3});
        ((TransactionApplier)inOrder.verify((Object)this.txApplier1)).visitRelationshipTypeTokenCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier2)).visitRelationshipTypeTokenCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier3)).visitRelationshipTypeTokenCommand(cmd);
        inOrder.verifyNoMoreInteractions();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testVisitLabelTokenCommand() throws Exception {
        Command.LabelTokenCommand cmd = (Command.LabelTokenCommand)Mockito.mock(Command.LabelTokenCommand.class);
        Mockito.when((Object)cmd.handle((CommandVisitor)Matchers.any(CommandVisitor.class))).thenCallRealMethod();
        boolean result = this.facade.visitLabelTokenCommand(cmd);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.txApplier1, this.txApplier2, this.txApplier3});
        ((TransactionApplier)inOrder.verify((Object)this.txApplier1)).visitLabelTokenCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier2)).visitLabelTokenCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier3)).visitLabelTokenCommand(cmd);
        inOrder.verifyNoMoreInteractions();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testVisitPropertyKeyTokenCommand() throws Exception {
        Command.PropertyKeyTokenCommand cmd = (Command.PropertyKeyTokenCommand)Mockito.mock(Command.PropertyKeyTokenCommand.class);
        Mockito.when((Object)cmd.handle((CommandVisitor)Matchers.any(CommandVisitor.class))).thenCallRealMethod();
        boolean result = this.facade.visitPropertyKeyTokenCommand(cmd);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.txApplier1, this.txApplier2, this.txApplier3});
        ((TransactionApplier)inOrder.verify((Object)this.txApplier1)).visitPropertyKeyTokenCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier2)).visitPropertyKeyTokenCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier3)).visitPropertyKeyTokenCommand(cmd);
        inOrder.verifyNoMoreInteractions();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testVisitSchemaRuleCommand() throws Exception {
        Command.SchemaRuleCommand cmd = (Command.SchemaRuleCommand)Mockito.mock(Command.SchemaRuleCommand.class);
        Mockito.when((Object)cmd.handle((CommandVisitor)Matchers.any(CommandVisitor.class))).thenCallRealMethod();
        boolean result = this.facade.visitSchemaRuleCommand(cmd);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.txApplier1, this.txApplier2, this.txApplier3});
        ((TransactionApplier)inOrder.verify((Object)this.txApplier1)).visitSchemaRuleCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier2)).visitSchemaRuleCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier3)).visitSchemaRuleCommand(cmd);
        inOrder.verifyNoMoreInteractions();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testVisitNeoStoreCommand() throws Exception {
        Command.NeoStoreCommand cmd = (Command.NeoStoreCommand)Mockito.mock(Command.NeoStoreCommand.class);
        Mockito.when((Object)cmd.handle((CommandVisitor)Matchers.any(CommandVisitor.class))).thenCallRealMethod();
        boolean result = this.facade.visitNeoStoreCommand(cmd);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.txApplier1, this.txApplier2, this.txApplier3});
        ((TransactionApplier)inOrder.verify((Object)this.txApplier1)).visitNeoStoreCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier2)).visitNeoStoreCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier3)).visitNeoStoreCommand(cmd);
        inOrder.verifyNoMoreInteractions();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testVisitIndexAddNodeCommand() throws Exception {
        IndexCommand.AddNodeCommand cmd = (IndexCommand.AddNodeCommand)Mockito.mock(IndexCommand.AddNodeCommand.class);
        Mockito.when((Object)cmd.handle((CommandVisitor)Matchers.any(CommandVisitor.class))).thenCallRealMethod();
        boolean result = this.facade.visitIndexAddNodeCommand(cmd);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.txApplier1, this.txApplier2, this.txApplier3});
        ((TransactionApplier)inOrder.verify((Object)this.txApplier1)).visitIndexAddNodeCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier2)).visitIndexAddNodeCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier3)).visitIndexAddNodeCommand(cmd);
        inOrder.verifyNoMoreInteractions();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testVisitIndexAddRelationshipCommand() throws Exception {
        IndexCommand.AddRelationshipCommand cmd = (IndexCommand.AddRelationshipCommand)Mockito.mock(IndexCommand.AddRelationshipCommand.class);
        Mockito.when((Object)cmd.handle((CommandVisitor)Matchers.any(CommandVisitor.class))).thenCallRealMethod();
        boolean result = this.facade.visitIndexAddRelationshipCommand(cmd);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.txApplier1, this.txApplier2, this.txApplier3});
        ((TransactionApplier)inOrder.verify((Object)this.txApplier1)).visitIndexAddRelationshipCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier2)).visitIndexAddRelationshipCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier3)).visitIndexAddRelationshipCommand(cmd);
        inOrder.verifyNoMoreInteractions();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testVisitIndexRemoveCommand() throws Exception {
        IndexCommand.RemoveCommand cmd = (IndexCommand.RemoveCommand)Mockito.mock(IndexCommand.RemoveCommand.class);
        Mockito.when((Object)cmd.handle((CommandVisitor)Matchers.any(CommandVisitor.class))).thenCallRealMethod();
        boolean result = this.facade.visitIndexRemoveCommand(cmd);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.txApplier1, this.txApplier2, this.txApplier3});
        ((TransactionApplier)inOrder.verify((Object)this.txApplier1)).visitIndexRemoveCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier2)).visitIndexRemoveCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier3)).visitIndexRemoveCommand(cmd);
        inOrder.verifyNoMoreInteractions();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testVisitIndexDeleteCommand() throws Exception {
        IndexCommand.DeleteCommand cmd = (IndexCommand.DeleteCommand)Mockito.mock(IndexCommand.DeleteCommand.class);
        Mockito.when((Object)cmd.handle((CommandVisitor)Matchers.any(CommandVisitor.class))).thenCallRealMethod();
        boolean result = this.facade.visitIndexDeleteCommand(cmd);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.txApplier1, this.txApplier2, this.txApplier3});
        ((TransactionApplier)inOrder.verify((Object)this.txApplier1)).visitIndexDeleteCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier2)).visitIndexDeleteCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier3)).visitIndexDeleteCommand(cmd);
        inOrder.verifyNoMoreInteractions();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testVisitIndexCreateCommand() throws Exception {
        IndexCommand.CreateCommand cmd = (IndexCommand.CreateCommand)Mockito.mock(IndexCommand.CreateCommand.class);
        Mockito.when((Object)cmd.handle((CommandVisitor)Matchers.any(CommandVisitor.class))).thenCallRealMethod();
        boolean result = this.facade.visitIndexCreateCommand(cmd);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.txApplier1, this.txApplier2, this.txApplier3});
        ((TransactionApplier)inOrder.verify((Object)this.txApplier1)).visitIndexCreateCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier2)).visitIndexCreateCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier3)).visitIndexCreateCommand(cmd);
        inOrder.verifyNoMoreInteractions();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testVisitIndexDefineCommand() throws Exception {
        IndexDefineCommand cmd = (IndexDefineCommand)Mockito.mock(IndexDefineCommand.class);
        Mockito.when((Object)cmd.handle((CommandVisitor)Matchers.any(CommandVisitor.class))).thenCallRealMethod();
        boolean result = this.facade.visitIndexDefineCommand(cmd);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.txApplier1, this.txApplier2, this.txApplier3});
        ((TransactionApplier)inOrder.verify((Object)this.txApplier1)).visitIndexDefineCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier2)).visitIndexDefineCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier3)).visitIndexDefineCommand(cmd);
        inOrder.verifyNoMoreInteractions();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testVisitNodeCountsCommand() throws Exception {
        Command.NodeCountsCommand cmd = (Command.NodeCountsCommand)Mockito.mock(Command.NodeCountsCommand.class);
        Mockito.when((Object)cmd.handle((CommandVisitor)Matchers.any(CommandVisitor.class))).thenCallRealMethod();
        boolean result = this.facade.visitNodeCountsCommand(cmd);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.txApplier1, this.txApplier2, this.txApplier3});
        ((TransactionApplier)inOrder.verify((Object)this.txApplier1)).visitNodeCountsCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier2)).visitNodeCountsCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier3)).visitNodeCountsCommand(cmd);
        inOrder.verifyNoMoreInteractions();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testVisitRelationshipCountsCommand() throws Exception {
        Command.RelationshipCountsCommand cmd = (Command.RelationshipCountsCommand)Mockito.mock(Command.RelationshipCountsCommand.class);
        Mockito.when((Object)cmd.handle((CommandVisitor)Matchers.any(CommandVisitor.class))).thenCallRealMethod();
        boolean result = this.facade.visitRelationshipCountsCommand(cmd);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.txApplier1, this.txApplier2, this.txApplier3});
        ((TransactionApplier)inOrder.verify((Object)this.txApplier1)).visitRelationshipCountsCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier2)).visitRelationshipCountsCommand(cmd);
        ((TransactionApplier)inOrder.verify((Object)this.txApplier3)).visitRelationshipCountsCommand(cmd);
        inOrder.verifyNoMoreInteractions();
        Assert.assertFalse((boolean)result);
    }
}

