/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.Arrays;
import java.util.Iterator;
import junit.framework.TestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.storageengine.api.Token;

public class PropertyIT
extends KernelIntegrationTest {
    @Test
    public void shouldBeAbleToSetAndReadLargeByteArray() throws Exception {
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        long nodeId = statement.nodeCreate();
        int propertyKeyId = statement.propertyKeyGetOrCreateForName("clown");
        statement.nodeSetProperty(nodeId, Property.byteArrayProperty((int)propertyKeyId, (byte[])new byte[100000]));
        this.commit();
        statement = this.dataWriteOperationsInNewTransaction();
        Object object = statement.nodeGetProperty(nodeId, propertyKeyId);
    }

    @Test
    public void shouldSetNodePropertyValue() throws Exception {
        String value = "bozo";
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        long nodeId = statement.nodeCreate();
        int propertyKeyId = statement.propertyKeyGetOrCreateForName("clown");
        statement.nodeSetProperty(nodeId, Property.stringProperty((int)propertyKeyId, (String)value));
        Assert.assertEquals((Object)value, (Object)statement.nodeGetProperty(nodeId, propertyKeyId));
        this.commit();
        statement = this.dataWriteOperationsInNewTransaction();
        Assert.assertEquals((Object)value, (Object)statement.nodeGetProperty(nodeId, propertyKeyId));
    }

    @Test
    public void shouldRemoveSetNodeProperty() throws Exception {
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        long nodeId = statement.nodeCreate();
        int propertyKeyId = statement.propertyKeyGetOrCreateForName("clown");
        statement.nodeSetProperty(nodeId, Property.stringProperty((int)propertyKeyId, (String)"bozo"));
        statement.nodeRemoveProperty(nodeId, propertyKeyId);
        Assert.assertThat((Object)statement.nodeGetProperty(nodeId, propertyKeyId), (Matcher)Matchers.nullValue());
        this.commit();
        statement = this.dataWriteOperationsInNewTransaction();
        Assert.assertThat((Object)statement.nodeGetProperty(nodeId, propertyKeyId), (Matcher)Matchers.nullValue());
    }

    @Test
    public void shouldRemoveSetNodePropertyAcrossTransactions() throws Exception {
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        long nodeId = statement.nodeCreate();
        int propertyKeyId = statement.propertyKeyGetOrCreateForName("clown");
        statement.nodeSetProperty(nodeId, Property.stringProperty((int)propertyKeyId, (String)"bozo"));
        this.commit();
        statement = this.dataWriteOperationsInNewTransaction();
        Object previous = statement.nodeRemoveProperty(nodeId, propertyKeyId).value();
        Assert.assertEquals((Object)"bozo", (Object)previous);
        Assert.assertThat((Object)statement.nodeGetProperty(nodeId, propertyKeyId), (Matcher)Matchers.nullValue());
        this.commit();
        statement = this.dataWriteOperationsInNewTransaction();
        Assert.assertThat((Object)statement.nodeGetProperty(nodeId, propertyKeyId), (Matcher)Matchers.nullValue());
    }

    @Test
    public void shouldRemoveSetExistingProperty() throws Exception {
        this.dbWithNoCache();
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        long nodeId = statement.nodeCreate();
        int propertyKeyId = statement.propertyKeyGetOrCreateForName("clown");
        statement.nodeSetProperty(nodeId, Property.stringProperty((int)propertyKeyId, (String)"bozo"));
        this.commit();
        DefinedProperty newProperty = Property.stringProperty((int)propertyKeyId, (String)"ozob");
        DataWriteOperations statement2 = this.dataWriteOperationsInNewTransaction();
        statement2.nodeRemoveProperty(nodeId, propertyKeyId);
        statement2.nodeSetProperty(nodeId, newProperty);
        Assert.assertThat((Object)statement2.nodeGetProperty(nodeId, propertyKeyId), (Matcher)CoreMatchers.equalTo((Object)newProperty.value()));
        this.commit();
        statement2 = this.dataWriteOperationsInNewTransaction();
        Assert.assertThat((Object)statement2.nodeGetProperty(nodeId, propertyKeyId), (Matcher)CoreMatchers.equalTo((Object)newProperty.value()));
        Assert.assertThat((Object)PrimitiveIntCollections.toList((PrimitiveIntIterator)statement2.nodeGetPropertyKeys(nodeId)), (Matcher)CoreMatchers.equalTo(Arrays.asList(newProperty.propertyKeyId())));
    }

    @Test
    public void shouldSilentlyNotRemoveMissingNodeProperty() throws Exception {
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        long nodeId = statement.nodeCreate();
        int propertyId = statement.propertyKeyGetOrCreateForName("clown");
        this.commit();
        statement = this.dataWriteOperationsInNewTransaction();
        Property result = statement.nodeRemoveProperty(nodeId, propertyId);
        Assert.assertFalse((String)"Return no property if removing missing", (boolean)result.isDefined());
    }

    @Test
    public void nodeHasPropertyIfSet() throws Exception {
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        long nodeId = statement.nodeCreate();
        int propertyKeyId = statement.propertyKeyGetOrCreateForName("clown");
        statement.nodeSetProperty(nodeId, Property.stringProperty((int)propertyKeyId, (String)"bozo"));
        Assert.assertThat((Object)statement.nodeHasProperty(nodeId, propertyKeyId), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)statement.nodeGetProperty(nodeId, propertyKeyId), (Matcher)Matchers.notNullValue());
        this.commit();
        statement = this.dataWriteOperationsInNewTransaction();
        Assert.assertThat((Object)statement.nodeHasProperty(nodeId, propertyKeyId), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)statement.nodeGetProperty(nodeId, propertyKeyId), (Matcher)Matchers.notNullValue());
    }

    @Test
    public void nodeHasNotPropertyIfUnset() throws Exception {
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        long nodeId = statement.nodeCreate();
        int propertyKeyId = statement.propertyKeyGetOrCreateForName("clown");
        Assert.assertThat((Object)statement.nodeHasProperty(nodeId, propertyKeyId), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)statement.nodeGetProperty(nodeId, propertyKeyId), (Matcher)Matchers.nullValue());
        this.commit();
        statement = this.dataWriteOperationsInNewTransaction();
        Assert.assertThat((Object)statement.nodeHasProperty(nodeId, propertyKeyId), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)statement.nodeGetProperty(nodeId, propertyKeyId), (Matcher)Matchers.nullValue());
    }

    @Test
    public void shouldRollbackSetNodePropertyValue() throws Exception {
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        long nodeId = statement.nodeCreate();
        int propertyKeyId = statement.propertyKeyGetOrCreateForName("clown");
        this.commit();
        statement = this.dataWriteOperationsInNewTransaction();
        statement.nodeSetProperty(nodeId, Property.stringProperty((int)propertyKeyId, (String)"bozo"));
        this.rollback();
        statement = this.dataWriteOperationsInNewTransaction();
        Assert.assertThat((Object)statement.nodeHasProperty(nodeId, propertyKeyId), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)statement.nodeGetProperty(nodeId, propertyKeyId), (Matcher)Matchers.nullValue());
    }

    @Test
    public void shouldUpdateNodePropertyValue() throws Exception {
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        long nodeId = statement.nodeCreate();
        int propertyId = statement.propertyKeyGetOrCreateForName("clown");
        statement.nodeSetProperty(nodeId, Property.stringProperty((int)propertyId, (String)"bozo"));
        this.commit();
        statement = this.dataWriteOperationsInNewTransaction();
        statement.nodeSetProperty(nodeId, Property.intProperty((int)propertyId, (int)42));
        this.commit();
        statement = this.dataWriteOperationsInNewTransaction();
        Assert.assertEquals((Object)42, (Object)statement.nodeGetProperty(nodeId, propertyId));
    }

    @Test
    public void shouldListAllPropertyKeys() throws Exception {
        this.dbWithNoCache();
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        long prop1 = statement.propertyKeyGetOrCreateForName("prop1");
        long prop2 = statement.propertyKeyGetOrCreateForName("prop2");
        Iterator propIdsBeforeCommit = statement.propertyKeyGetAllTokens();
        Assert.assertThat((Object)Iterators.asCollection((Iterator)propIdsBeforeCommit), (Matcher)IsCollectionContaining.hasItems((Object[])new Token[]{new Token("prop1", (int)prop1), new Token("prop2", (int)prop2)}));
        this.commit();
        statement = this.dataWriteOperationsInNewTransaction();
        Iterator propIdsAfterCommit = statement.propertyKeyGetAllTokens();
        Assert.assertThat((Object)Iterators.asCollection((Iterator)propIdsAfterCommit), (Matcher)IsCollectionContaining.hasItems((Object[])new Token[]{new Token("prop1", (int)prop1), new Token("prop2", (int)prop2)}));
    }

    @Test
    public void shouldNotAllowModifyingPropertiesOnDeletedNode() throws Exception {
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        int prop1 = statement.propertyKeyGetOrCreateForName("prop1");
        long node = statement.nodeCreate();
        statement.nodeSetProperty(node, Property.stringProperty((int)prop1, (String)"As"));
        statement.nodeDelete(node);
        try {
            statement.nodeRemoveProperty(node, prop1);
            TestCase.fail((String)"Should have failed.");
        }
        catch (EntityNotFoundException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)("Unable to load NODE with id " + node + ".")));
        }
    }

    @Test
    public void shouldNotAllowModifyingPropertiesOnDeletedRelationship() throws Exception {
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        int prop1 = statement.propertyKeyGetOrCreateForName("prop1");
        int type = statement.relationshipTypeGetOrCreateForName("RELATED");
        long rel = statement.relationshipCreate(type, statement.nodeCreate(), statement.nodeCreate());
        statement.relationshipSetProperty(rel, Property.stringProperty((int)prop1, (String)"As"));
        statement.relationshipDelete(rel);
        try {
            statement.relationshipRemoveProperty(rel, prop1);
            TestCase.fail((String)"Should have failed.");
        }
        catch (EntityNotFoundException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)("Unable to load RELATIONSHIP with id " + rel + ".")));
        }
    }

    @Test
    public void shouldBeAbleToRemoveResetAndTwiceRemovePropertyOnNode() throws Exception {
        DataWriteOperations ops = this.dataWriteOperationsInNewTransaction();
        int prop = ops.propertyKeyGetOrCreateForName("foo");
        long node = ops.nodeCreate();
        ops.nodeSetProperty(node, Property.property((int)prop, (Object)"bar"));
        this.commit();
        ops = this.dataWriteOperationsInNewTransaction();
        ops.nodeRemoveProperty(node, prop);
        ops.nodeSetProperty(node, Property.property((int)prop, (Object)"bar"));
        ops.nodeRemoveProperty(node, prop);
        ops.nodeRemoveProperty(node, prop);
        this.commit();
        ops = this.readOperationsInNewTransaction();
        Assert.assertThat((Object)ops.nodeGetProperty(node, prop), (Matcher)Matchers.nullValue());
    }

    @Test
    public void shouldBeAbleToRemoveResetAndTwiceRemovePropertyOnRelationship() throws Exception {
        DataWriteOperations ops = this.dataWriteOperationsInNewTransaction();
        int prop = ops.propertyKeyGetOrCreateForName("foo");
        int type = ops.relationshipTypeGetOrCreateForName("RELATED");
        long rel = ops.relationshipCreate(type, ops.nodeCreate(), ops.nodeCreate());
        ops.relationshipSetProperty(rel, Property.property((int)prop, (Object)"bar"));
        this.commit();
        ops = this.dataWriteOperationsInNewTransaction();
        ops.relationshipRemoveProperty(rel, prop);
        ops.relationshipSetProperty(rel, Property.property((int)prop, (Object)"bar"));
        ops.relationshipRemoveProperty(rel, prop);
        ops.relationshipRemoveProperty(rel, prop);
        this.commit();
        ops = this.readOperationsInNewTransaction();
        Assert.assertThat((Object)ops.relationshipGetProperty(rel, prop), (Matcher)Matchers.nullValue());
    }
}

