/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.AllOf;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.rule.concurrent.OtherThreadRule;

public class RelationshipIT
extends KernelIntegrationTest {
    @Rule
    public OtherThreadRule<Object> otherThread = new OtherThreadRule(10L, TimeUnit.SECONDS);

    @Test
    public void shouldListRelationshipsInCurrentAndSubsequentTx() throws Exception {
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        int relType1 = statement.relationshipTypeGetOrCreateForName("Type1");
        int relType2 = statement.relationshipTypeGetOrCreateForName("Type2");
        long refNode = statement.nodeCreate();
        long otherNode = statement.nodeCreate();
        long fromRefToOther1 = statement.relationshipCreate(relType1, refNode, otherNode);
        long fromRefToOther2 = statement.relationshipCreate(relType2, refNode, otherNode);
        long fromOtherToRef = statement.relationshipCreate(relType1, otherNode, refNode);
        long fromRefToRef = statement.relationshipCreate(relType2, refNode, refNode);
        long fromRefToThird = statement.relationshipCreate(relType2, refNode, statement.nodeCreate());
        this.assertRels((PrimitiveLongIterator)statement.nodeGetRelationships(refNode, Direction.BOTH), fromRefToOther1, fromRefToOther2, fromRefToRef, fromRefToThird, fromOtherToRef);
        this.assertRels((PrimitiveLongIterator)statement.nodeGetRelationships(refNode, Direction.BOTH, new int[]{relType1}), fromRefToOther1, fromOtherToRef);
        this.assertRels((PrimitiveLongIterator)statement.nodeGetRelationships(refNode, Direction.BOTH, new int[]{relType1, relType2}), fromRefToOther1, fromRefToOther2, fromRefToRef, fromRefToThird, fromOtherToRef);
        this.assertRels((PrimitiveLongIterator)statement.nodeGetRelationships(refNode, Direction.INCOMING), fromOtherToRef);
        this.assertRels((PrimitiveLongIterator)statement.nodeGetRelationships(refNode, Direction.INCOMING, new int[]{relType1}), new long[0]);
        this.assertRels((PrimitiveLongIterator)statement.nodeGetRelationships(refNode, Direction.OUTGOING, new int[]{relType1, relType2}), fromRefToOther1, fromRefToOther2, fromRefToThird, fromRefToRef);
        this.commit();
        statement = this.dataWriteOperationsInNewTransaction();
        this.assertRels((PrimitiveLongIterator)statement.nodeGetRelationships(refNode, Direction.BOTH), fromRefToOther1, fromRefToOther2, fromRefToRef, fromRefToThird, fromOtherToRef);
        this.assertRels((PrimitiveLongIterator)statement.nodeGetRelationships(refNode, Direction.BOTH, new int[]{relType1}), fromRefToOther1, fromOtherToRef);
        this.assertRels((PrimitiveLongIterator)statement.nodeGetRelationships(refNode, Direction.BOTH, new int[]{relType1, relType2}), fromRefToOther1, fromRefToOther2, fromRefToRef, fromRefToThird, fromOtherToRef);
        this.assertRels((PrimitiveLongIterator)statement.nodeGetRelationships(refNode, Direction.INCOMING), fromOtherToRef);
        this.assertRels((PrimitiveLongIterator)statement.nodeGetRelationships(refNode, Direction.INCOMING, new int[]{relType1}), new long[0]);
        this.assertRels((PrimitiveLongIterator)statement.nodeGetRelationships(refNode, Direction.OUTGOING, new int[]{relType1, relType2}), fromRefToOther1, fromRefToOther2, fromRefToThird, fromRefToRef);
    }

    @Test
    public void shouldInterleaveModifiedRelationshipsWithExistingOnes() throws Exception {
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        int relType1 = statement.relationshipTypeGetOrCreateForName("Type1");
        int relType2 = statement.relationshipTypeGetOrCreateForName("Type2");
        long refNode = statement.nodeCreate();
        long otherNode = statement.nodeCreate();
        long fromRefToOther1 = statement.relationshipCreate(relType1, refNode, otherNode);
        long fromRefToOther2 = statement.relationshipCreate(relType2, refNode, otherNode);
        this.commit();
        statement = this.dataWriteOperationsInNewTransaction();
        statement.relationshipDelete(fromRefToOther1);
        long localTxRel = statement.relationshipCreate(relType1, refNode, statement.nodeCreate());
        this.assertRels((PrimitiveLongIterator)statement.nodeGetRelationships(refNode, Direction.BOTH), fromRefToOther2, localTxRel);
        this.assertRelsInSeparateTx(refNode, Direction.BOTH, fromRefToOther1, fromRefToOther2);
    }

    @Test
    public void shouldAllowIteratingAndDeletingRelsAtTheSameTime() throws Exception {
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        int relType1 = statement.relationshipTypeGetOrCreateForName("Type1");
        int relType2 = statement.relationshipTypeGetOrCreateForName("Type2");
        long refNode = statement.nodeCreate();
        long otherNode = statement.nodeCreate();
        long fromRefToOther1 = statement.relationshipCreate(relType1, refNode, otherNode);
        long fromRefToOther2 = statement.relationshipCreate(relType2, refNode, otherNode);
        this.commit();
        statement = this.dataWriteOperationsInNewTransaction();
        statement.relationshipDelete(fromRefToOther1);
        long localTxRel = statement.relationshipCreate(relType1, refNode, statement.nodeCreate());
        this.assertRels((PrimitiveLongIterator)statement.nodeGetRelationships(refNode, Direction.BOTH), fromRefToOther2, localTxRel);
        this.assertRelsInSeparateTx(refNode, Direction.BOTH, fromRefToOther1, fromRefToOther2);
    }

    @Test
    public void shouldReturnRelsWhenAskingForRelsWhereOnlySomeTypesExistInCurrentRel() throws Exception {
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        int relType1 = statement.relationshipTypeGetOrCreateForName("Type1");
        int relType2 = statement.relationshipTypeGetOrCreateForName("Type2");
        long refNode = statement.nodeCreate();
        long otherNode = statement.nodeCreate();
        long theRel = statement.relationshipCreate(relType1, refNode, otherNode);
        this.assertRels((PrimitiveLongIterator)statement.nodeGetRelationships(refNode, Direction.OUTGOING, new int[]{relType2, relType1}), theRel);
        this.commit();
    }

    @Test
    public void askingForNonExistantReltypeOnDenseNodeShouldNotCorruptState() throws Exception {
        long[] rels = new long[200];
        DataWriteOperations statement = this.dataWriteOperationsInNewTransaction();
        int relTypeTheNodeDoesUse = statement.relationshipTypeGetOrCreateForName("Type1");
        int relTypeTheNodeDoesNotUse = statement.relationshipTypeGetOrCreateForName("Type2");
        long refNode = statement.nodeCreate();
        long otherNode = statement.nodeCreate();
        for (int i = 0; i < rels.length; ++i) {
            rels[i] = statement.relationshipCreate(relTypeTheNodeDoesUse, refNode, otherNode);
        }
        this.commit();
        ReadOperations stmt = this.readOperationsInNewTransaction();
        this.assertRels((PrimitiveLongIterator)stmt.nodeGetRelationships(refNode, Direction.INCOMING, new int[]{relTypeTheNodeDoesNotUse}), new long[0]);
        this.assertRels((PrimitiveLongIterator)stmt.nodeGetRelationships(refNode, Direction.BOTH, new int[]{relTypeTheNodeDoesUse}), rels);
    }

    private void assertRelsInSeparateTx(final long refNode, final Direction both, final long ... longs) throws InterruptedException, ExecutionException, TimeoutException {
        Assert.assertTrue((boolean)this.otherThread.execute(new OtherThreadExecutor.WorkerCommand<Object, Boolean>(){

            @Override
            public Boolean doWork(Object state) throws Exception {
                try (Transaction tx = RelationshipIT.this.db.beginTx();){
                    ReadOperations stmt = RelationshipIT.this.statementContextSupplier.get().readOperations();
                    RelationshipIT.this.assertRels((PrimitiveLongIterator)stmt.nodeGetRelationships(refNode, both), longs);
                }
                return true;
            }
        }).get(10L, TimeUnit.SECONDS));
    }

    private void assertRels(PrimitiveLongIterator it, long ... rels) {
        ArrayList<Matcher> all = new ArrayList<Matcher>(rels.length);
        for (long element : rels) {
            all.add(CoreMatchers.hasItem((Object)element));
        }
        List list = PrimitiveLongCollections.asList((PrimitiveLongIterator)it);
        Assert.assertThat((Object)list, (Matcher)AllOf.allOf(all));
    }
}

