/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Arrays;
import java.util.Iterator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.state.PropertyContainerStateImpl;

public class PropertyContainerStateImplTest {
    @Test
    public void shouldListAddedProperties() throws Exception {
        PropertyContainerStateImpl state = new PropertyContainerStateImpl(1L);
        state.addProperty(Property.stringProperty((int)1, (String)"Hello"));
        state.addProperty(Property.stringProperty((int)2, (String)"Hello"));
        state.removeProperty(Property.stringProperty((int)1, (String)"Hello"));
        Iterator added = state.addedProperties();
        Assert.assertThat((Object)Iterators.asList((Iterator)added), (Matcher)CoreMatchers.equalTo(Arrays.asList(Property.stringProperty((int)2, (String)"Hello"))));
    }

    @Test
    public void shouldListAddedPropertiesEvenIfPropertiesHaveBeenReplaced() throws Exception {
        PropertyContainerStateImpl state = new PropertyContainerStateImpl(1L);
        state.addProperty(Property.stringProperty((int)1, (String)"Hello"));
        state.addProperty(Property.stringProperty((int)1, (String)"WAT"));
        state.addProperty(Property.stringProperty((int)2, (String)"Hello"));
        Iterator added = state.addedProperties();
        Assert.assertThat((Object)Iterators.asList((Iterator)added), (Matcher)CoreMatchers.equalTo(Arrays.asList(Property.stringProperty((int)1, (String)"WAT"), Property.stringProperty((int)2, (String)"Hello"))));
    }

    @Test
    public void shouldConvertAddRemoveToChange() throws Exception {
        PropertyContainerStateImpl state = new PropertyContainerStateImpl(1L);
        state.removeProperty(Property.stringProperty((int)4, (String)"a value"));
        state.addProperty(Property.stringProperty((int)4, (String)"another value"));
        Assert.assertThat((Object)Iterators.asList((Iterator)state.changedProperties()), (Matcher)CoreMatchers.equalTo(Arrays.asList(Property.stringProperty((int)4, (String)"another value"))));
        Assert.assertFalse((boolean)state.addedProperties().hasNext());
        Assert.assertFalse((boolean)state.removedProperties().hasNext());
    }
}

