/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.constraints.PropertyConstraint;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.legacyindex.AutoIndexing;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.IndexReaderFactory;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.StateHandlingStatementOperations;
import org.neo4j.kernel.impl.api.StatementOperationsTestHelper;
import org.neo4j.kernel.impl.api.legacyindex.InternalAutoIndexing;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.state.StubCursors;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.index.LegacyIndexStore;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.locking.ReentrantLockService;
import org.neo4j.kernel.impl.util.Cursors;
import org.neo4j.kernel.impl.util.diffsets.DiffSets;
import org.neo4j.storageengine.api.LabelItem;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.LabelScanReader;
import org.neo4j.test.MockedNeoStores;

public class StateHandlingStatementOperationsTest {
    StoreReadLayer inner = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);

    @Test
    public void shouldNeverDelegateWrites() throws Exception {
        KernelStatement state = StatementOperationsTestHelper.mockedState();
        Mockito.when((Object)state.txState()).thenReturn((Object)new TxState());
        StoreStatement storeStatement = (StoreStatement)Mockito.mock(StoreStatement.class);
        Mockito.when((Object)state.getStoreStatement()).thenReturn((Object)storeStatement);
        Mockito.when((Object)storeStatement.acquireSingleNodeCursor(Matchers.anyLong())).thenReturn(StubCursors.asNodeCursor(0L));
        StateHandlingStatementOperations ctx = this.newTxStateOps(this.inner);
        ctx.indexCreate(state, 0, 0);
        ctx.nodeAddLabel(state, 0L, 0);
        ctx.indexDrop(state, new IndexDescriptor(0, 0));
        ctx.nodeRemoveLabel(state, 0L, 0);
        ((StoreStatement)Mockito.verify((Object)storeStatement, (VerificationMode)Mockito.times((int)2))).acquireSingleNodeCursor(0L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{storeStatement});
    }

    @Test
    public void shouldNotAddConstraintAlreadyExistsInTheStore() throws Exception {
        UniquenessConstraint constraint = new UniquenessConstraint(10, 66);
        TransactionState txState = (TransactionState)Mockito.mock(TransactionState.class);
        Mockito.when((Object)txState.nodesWithLabelChanged(Matchers.anyInt())).thenReturn((Object)new DiffSets());
        Mockito.when((Object)txState.hasChanges()).thenReturn((Object)true);
        KernelStatement state = StatementOperationsTestHelper.mockedState(txState);
        Mockito.when((Object)this.inner.constraintsGetForLabelAndPropertyKey(10, 66)).thenAnswer(arg_0 -> StateHandlingStatementOperationsTest.lambda$shouldNotAddConstraintAlreadyExistsInTheStore$0((PropertyConstraint)constraint, arg_0));
        StateHandlingStatementOperations context = this.newTxStateOps(this.inner);
        context.uniquePropertyConstraintCreate(state, 10, 66);
        ((TransactionState)Mockito.verify((Object)txState)).constraintIndexDoUnRemove((IndexDescriptor)Matchers.any(IndexDescriptor.class));
    }

    @Test
    public void shouldGetConstraintsByLabelAndProperty() throws Exception {
        UniquenessConstraint constraint = new UniquenessConstraint(10, 66);
        TxState txState = new TxState();
        KernelStatement state = StatementOperationsTestHelper.mockedState((TransactionState)txState);
        Mockito.when((Object)this.inner.constraintsGetForLabelAndPropertyKey(10, 66)).thenAnswer(invocation -> Iterators.emptyIterator());
        StateHandlingStatementOperations context = this.newTxStateOps(this.inner);
        context.uniquePropertyConstraintCreate(state, 10, 66);
        Set result = Iterables.asSet((Iterable)Iterators.asIterable((Iterator)context.constraintsGetForLabelAndPropertyKey(state, 10, 66)));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new PropertyConstraint[]{constraint}), (Object)result);
    }

    @Test
    public void shouldGetConstraintsByLabel() throws Exception {
        UniquenessConstraint constraint2 = new UniquenessConstraint(11, 99);
        UniquenessConstraint constraint1 = new UniquenessConstraint(11, 66);
        TxState txState = new TxState();
        KernelStatement state = StatementOperationsTestHelper.mockedState((TransactionState)txState);
        Mockito.when((Object)this.inner.constraintsGetForLabelAndPropertyKey(10, 66)).thenAnswer(invocation -> Iterators.emptyIterator());
        Mockito.when((Object)this.inner.constraintsGetForLabelAndPropertyKey(11, 99)).thenAnswer(invocation -> Iterators.emptyIterator());
        Mockito.when((Object)this.inner.constraintsGetForLabel(10)).thenAnswer(invocation -> Iterators.emptyIterator());
        Mockito.when((Object)this.inner.constraintsGetForLabel(11)).thenAnswer(arg_0 -> StateHandlingStatementOperationsTest.lambda$shouldGetConstraintsByLabel$5((PropertyConstraint)constraint1, arg_0));
        StateHandlingStatementOperations context = this.newTxStateOps(this.inner);
        context.uniquePropertyConstraintCreate(state, 10, 66);
        context.uniquePropertyConstraintCreate(state, 11, 99);
        Set result = Iterables.asSet((Iterable)Iterators.asIterable((Iterator)context.constraintsGetForLabel(state, 11)));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new PropertyConstraint[]{constraint1, constraint2}), (Object)result);
    }

    @Test
    public void shouldGetAllConstraints() throws Exception {
        UniquenessConstraint constraint1 = new UniquenessConstraint(10, 66);
        UniquenessConstraint constraint2 = new UniquenessConstraint(11, 99);
        TxState txState = new TxState();
        KernelStatement state = StatementOperationsTestHelper.mockedState((TransactionState)txState);
        Mockito.when((Object)this.inner.constraintsGetForLabelAndPropertyKey(10, 66)).thenAnswer(invocation -> Iterators.emptyIterator());
        Mockito.when((Object)this.inner.constraintsGetForLabelAndPropertyKey(11, 99)).thenAnswer(invocation -> Iterators.emptyIterator());
        Mockito.when((Object)this.inner.constraintsGetAll()).thenAnswer(arg_0 -> StateHandlingStatementOperationsTest.lambda$shouldGetAllConstraints$8((PropertyConstraint)constraint2, arg_0));
        StateHandlingStatementOperations context = this.newTxStateOps(this.inner);
        context.uniquePropertyConstraintCreate(state, 10, 66);
        Set result = Iterables.asSet((Iterable)Iterators.asIterable((Iterator)context.constraintsGetAll(state)));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new PropertyConstraint[]{constraint1, constraint2}), (Object)result);
    }

    @Test
    public void shouldConsiderTransactionStateDuringIndexScan() throws Exception {
        TransactionState txState = (TransactionState)Mockito.mock(TransactionState.class);
        KernelStatement statement = (KernelStatement)Mockito.mock(KernelStatement.class);
        Mockito.when((Object)statement.hasTxStateWithChanges()).thenReturn((Object)true);
        Mockito.when((Object)statement.txState()).thenReturn((Object)txState);
        IndexDescriptor index = new IndexDescriptor(1, 2);
        Mockito.when((Object)txState.indexUpdatesForScanOrSeek(index, null)).thenReturn((Object)new DiffSets(Collections.singleton(42L), Collections.singleton(44L)));
        Mockito.when((Object)txState.addedAndRemovedNodes()).thenReturn((Object)new DiffSets(Collections.singleton(45L), Collections.singleton(46L)));
        StoreReadLayer storeReadLayer = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        IndexReader indexReader = this.addMockedIndexReader(statement);
        Mockito.when((Object)indexReader.scan()).thenReturn((Object)PrimitiveLongCollections.resourceIterator((PrimitiveLongIterator)PrimitiveLongCollections.iterator((long[])new long[]{43L, 44L, 46L}), null));
        StateHandlingStatementOperations context = this.newTxStateOps(storeReadLayer);
        PrimitiveLongIterator results = context.nodesGetFromIndexScan(statement, index);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{42L, 43L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)results));
    }

    @Test
    public void shouldConsiderTransactionStateDuringIndexSeek() throws Exception {
        TransactionState txState = (TransactionState)Mockito.mock(TransactionState.class);
        KernelStatement statement = (KernelStatement)Mockito.mock(KernelStatement.class);
        Mockito.when((Object)statement.hasTxStateWithChanges()).thenReturn((Object)true);
        Mockito.when((Object)statement.txState()).thenReturn((Object)txState);
        IndexDescriptor index = new IndexDescriptor(1, 2);
        Mockito.when((Object)txState.indexUpdatesForScanOrSeek(index, (Object)"value")).thenReturn((Object)new DiffSets(Collections.singleton(42L), Collections.singleton(44L)));
        Mockito.when((Object)txState.addedAndRemovedNodes()).thenReturn((Object)new DiffSets(Collections.singleton(45L), Collections.singleton(46L)));
        StoreReadLayer storeReadLayer = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        IndexReader indexReader = this.addMockedIndexReader(statement);
        Mockito.when((Object)indexReader.seek((Object)"value")).thenReturn((Object)PrimitiveLongCollections.resourceIterator((PrimitiveLongIterator)PrimitiveLongCollections.iterator((long[])new long[]{43L, 44L, 46L}), null));
        StateHandlingStatementOperations context = this.newTxStateOps(storeReadLayer);
        PrimitiveLongIterator results = context.nodesGetFromIndexSeek(statement, index, (Object)"value");
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{42L, 43L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)results));
    }

    @Test
    public void shouldConsiderTransactionStateDuringIndexRangeSeekByPrefix() throws Exception {
        TransactionState txState = (TransactionState)Mockito.mock(TransactionState.class);
        KernelStatement statement = (KernelStatement)Mockito.mock(KernelStatement.class);
        Mockito.when((Object)statement.hasTxStateWithChanges()).thenReturn((Object)true);
        Mockito.when((Object)statement.txState()).thenReturn((Object)txState);
        IndexDescriptor index = new IndexDescriptor(1, 2);
        Mockito.when((Object)txState.indexUpdatesForRangeSeekByPrefix(index, "prefix")).thenReturn((Object)new DiffSets(Collections.singleton(42L), Collections.singleton(44L)));
        Mockito.when((Object)txState.addedAndRemovedNodes()).thenReturn((Object)new DiffSets(Collections.singleton(45L), Collections.singleton(46L)));
        StoreReadLayer storeReadLayer = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        IndexReader indexReader = this.addMockedIndexReader(statement);
        Mockito.when((Object)indexReader.rangeSeekByPrefix("prefix")).thenReturn((Object)PrimitiveLongCollections.resourceIterator((PrimitiveLongIterator)PrimitiveLongCollections.iterator((long[])new long[]{43L, 44L, 46L}), null));
        StateHandlingStatementOperations context = this.newTxStateOps(storeReadLayer);
        PrimitiveLongIterator results = context.nodesGetFromIndexRangeSeekByPrefix(statement, index, "prefix");
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{42L, 43L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)results));
    }

    @Test
    public void shouldConsiderTransactionStateDuringIndexBetweenRangeSeekByNumber() throws Exception {
        int propertyKey = 2;
        int inRange = 15;
        int lower = 10;
        int upper = 20;
        TransactionState txState = (TransactionState)Mockito.mock(TransactionState.class);
        KernelStatement statement = (KernelStatement)Mockito.mock(KernelStatement.class);
        Mockito.when((Object)statement.hasTxStateWithChanges()).thenReturn((Object)true);
        Mockito.when((Object)statement.txState()).thenReturn((Object)txState);
        StorageStatement storageStatement = (StorageStatement)Mockito.mock(StorageStatement.class);
        Mockito.when((Object)statement.getStoreStatement()).thenReturn((Object)storageStatement);
        IndexDescriptor index = new IndexDescriptor(1, 2);
        Mockito.when((Object)txState.indexUpdatesForRangeSeekByNumber(index, (Number)lower, true, (Number)upper, false)).thenReturn((Object)new DiffSets(Collections.singleton(42L), Collections.singleton(44L)));
        Mockito.when((Object)txState.addedAndRemovedNodes()).thenReturn((Object)new DiffSets(Collections.singleton(45L), Collections.singleton(46L)));
        Mockito.when((Object)txState.augmentSingleNodeCursor((Cursor)Matchers.any(Cursor.class), Matchers.anyLong())).thenAnswer((Answer)new Answer<Cursor<NodeItem>>(){

            public Cursor<NodeItem> answer(InvocationOnMock invocationOnMock) throws Throwable {
                long nodeId = (Long)invocationOnMock.getArguments()[1];
                return StubCursors.asNodeCursor(nodeId, StubCursors.asPropertyCursor(Property.intProperty((int)2, (int)15)), (Cursor<LabelItem>)Cursors.empty());
            }
        });
        StoreReadLayer storeReadLayer = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        IndexReader indexReader = this.addMockedIndexReader(storageStatement);
        Mockito.when((Object)indexReader.rangeSeekByNumberInclusive((Number)lower, (Number)upper)).thenReturn((Object)PrimitiveLongCollections.resourceIterator((PrimitiveLongIterator)PrimitiveLongCollections.iterator((long[])new long[]{43L, 44L, 46L}), null));
        Mockito.when((Object)storageStatement.acquireSingleNodeCursor(Matchers.anyLong())).thenAnswer((Answer)new Answer<Cursor<NodeItem>>(){

            public Cursor<NodeItem> answer(InvocationOnMock invocationOnMock) throws Throwable {
                long nodeId = (Long)invocationOnMock.getArguments()[0];
                return StubCursors.asNodeCursor(nodeId, StubCursors.asPropertyCursor(Property.intProperty((int)2, (int)15)), (Cursor<LabelItem>)Cursors.empty());
            }
        });
        StateHandlingStatementOperations context = this.newTxStateOps(storeReadLayer);
        PrimitiveLongIterator results = context.nodesGetFromIndexRangeSeekByNumber(statement, index, (Number)lower, true, (Number)upper, false);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{42L, 43L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)results));
    }

    @Test
    public void shouldConsiderTransactionStateDuringIndexBetweenRangeSeekByString() throws Exception {
        TransactionState txState = (TransactionState)Mockito.mock(TransactionState.class);
        KernelStatement statement = (KernelStatement)Mockito.mock(KernelStatement.class);
        Mockito.when((Object)statement.hasTxStateWithChanges()).thenReturn((Object)true);
        Mockito.when((Object)statement.txState()).thenReturn((Object)txState);
        IndexDescriptor index = new IndexDescriptor(1, 2);
        Mockito.when((Object)txState.indexUpdatesForRangeSeekByString(index, "Anne", true, "Bill", false)).thenReturn((Object)new DiffSets(Collections.singleton(42L), Collections.singleton(44L)));
        Mockito.when((Object)txState.addedAndRemovedNodes()).thenReturn((Object)new DiffSets(Collections.singleton(45L), Collections.singleton(46L)));
        StoreReadLayer storeReadLayer = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
        IndexReader indexReader = this.addMockedIndexReader(statement);
        Mockito.when((Object)indexReader.rangeSeekByString("Anne", true, "Bill", false)).thenReturn((Object)PrimitiveLongCollections.resourceIterator((PrimitiveLongIterator)PrimitiveLongCollections.iterator((long[])new long[]{43L, 44L, 46L}), null));
        StateHandlingStatementOperations context = this.newTxStateOps(storeReadLayer);
        PrimitiveLongIterator results = context.nodesGetFromIndexRangeSeekByString(statement, index, "Anne", true, "Bill", false);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Long[]{42L, 43L}), (Object)PrimitiveLongCollections.toSet((PrimitiveLongIterator)results));
    }

    @Test
    public void nodeGetFromUniqueIndexSeekClosesIndexReader() throws Exception {
        KernelStatement kernelStatement = (KernelStatement)Mockito.mock(KernelStatement.class);
        StoreStatement storeStatement = (StoreStatement)Mockito.mock(StoreStatement.class);
        IndexReader indexReader = (IndexReader)Mockito.mock(IndexReader.class);
        Mockito.when((Object)indexReader.seek(Matchers.any())).thenReturn((Object)PrimitiveLongCollections.emptyIterator());
        Mockito.when((Object)storeStatement.getFreshIndexReader((IndexDescriptor)Matchers.any())).thenReturn((Object)indexReader);
        Mockito.when((Object)kernelStatement.getStoreStatement()).thenReturn((Object)storeStatement);
        StateHandlingStatementOperations operations = this.newTxStateOps((StoreReadLayer)Mockito.mock(StoreReadLayer.class));
        operations.nodeGetFromUniqueIndexSeek(kernelStatement, new IndexDescriptor(1, 1), (Object)"foo");
        ((IndexReader)Mockito.verify((Object)indexReader)).close();
    }

    @Test
    public void nodeCursorGetFromUniqueIndexSeekClosesIndexReader() throws Exception {
        KernelStatement kernelStatement = (KernelStatement)Mockito.mock(KernelStatement.class);
        IndexReader indexReader = (IndexReader)Mockito.mock(IndexReader.class);
        StoreStatementWithSingleFreshIndexReader storeStatement = new StoreStatementWithSingleFreshIndexReader(indexReader);
        Mockito.when((Object)indexReader.seek(Matchers.any())).thenReturn((Object)PrimitiveLongCollections.emptyIterator());
        Mockito.when((Object)kernelStatement.getStoreStatement()).thenReturn((Object)storeStatement);
        StateHandlingStatementOperations operations = this.newTxStateOps((StoreReadLayer)Mockito.mock(StoreReadLayer.class));
        try (Cursor cursor = operations.nodeCursorGetFromUniqueIndexSeek(kernelStatement, new IndexDescriptor(1, 1), (Object)"foo");){
            while (cursor.next()) {
                Assert.fail((String)"Cursor should be empty");
            }
        }
        ((IndexReader)Mockito.verify((Object)indexReader)).close();
    }

    private StateHandlingStatementOperations newTxStateOps(StoreReadLayer delegate) {
        return new StateHandlingStatementOperations(delegate, (AutoIndexing)Mockito.mock(InternalAutoIndexing.class), (ConstraintIndexCreator)Mockito.mock(ConstraintIndexCreator.class), (LegacyIndexStore)Mockito.mock(LegacyIndexStore.class));
    }

    private IndexReader addMockedIndexReader(KernelStatement kernelStatement) throws IndexNotFoundKernelException {
        StorageStatement storageStatement = (StorageStatement)Mockito.mock(StorageStatement.class);
        Mockito.when((Object)kernelStatement.getStoreStatement()).thenReturn((Object)storageStatement);
        return this.addMockedIndexReader(storageStatement);
    }

    private IndexReader addMockedIndexReader(StorageStatement storeStatement) throws IndexNotFoundKernelException {
        IndexReader indexReader = (IndexReader)Mockito.mock(IndexReader.class);
        Mockito.when((Object)storeStatement.getIndexReader((IndexDescriptor)Matchers.any(IndexDescriptor.class))).thenReturn((Object)indexReader);
        return indexReader;
    }

    private static /* synthetic */ Object lambda$shouldGetAllConstraints$8(PropertyConstraint constraint2, InvocationOnMock invocation) throws Throwable {
        return Iterators.iterator((Object)constraint2);
    }

    private static /* synthetic */ Object lambda$shouldGetConstraintsByLabel$5(PropertyConstraint constraint1, InvocationOnMock invocation) throws Throwable {
        return Iterators.iterator((Object)constraint1);
    }

    private static /* synthetic */ Object lambda$shouldNotAddConstraintAlreadyExistsInTheStore$0(PropertyConstraint constraint, InvocationOnMock invocation) throws Throwable {
        return Iterators.iterator((Object)constraint);
    }

    private static class StoreStatementWithSingleFreshIndexReader
    extends StoreStatement {
        final IndexReader reader;

        StoreStatementWithSingleFreshIndexReader(IndexReader reader) {
            super(MockedNeoStores.basicMockedNeoStores(), () -> (IndexReaderFactory)Mockito.mock(IndexReaderFactory.class), () -> (LabelScanReader)Mockito.mock(LabelScanReader.class), (LockService)new ReentrantLockService());
            this.reader = reader;
        }

        public IndexReader getFreshIndexReader(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
            return this.reader;
        }
    }
}

