/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class TestReferenceDangling {
    @Rule
    public ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();

    @Test
    public void testPropertyStoreReferencesOnRead() throws Throwable {
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        long nId = this.ensurePropertyIsCachedLazyProperty(db, "some");
        this.restartNeoDataSource(db);
        try (Transaction tx = db.beginTx();){
            db.getNodeById(nId).getProperty("some");
            tx.success();
        }
    }

    @Test
    public void testPropertyStoreReferencesOnWrite() throws Throwable {
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        long nId = this.ensurePropertyIsCachedLazyProperty(db, "some");
        this.restartNeoDataSource(db);
        try (Transaction tx = db.beginTx();){
            db.getNodeById(nId).setProperty("some", (Object)new long[]{-1L, 2L, 2L, 3L, 4L, 5L, 5L});
            tx.success();
        }
    }

    private long ensurePropertyIsCachedLazyProperty(GraphDatabaseAPI slave, String key) {
        long nId;
        try (Transaction tx = slave.beginTx();){
            Node n = slave.createNode();
            nId = n.getId();
            n.setProperty(key, (Object)new long[]{-1L, 2L, 2L, 3L, 4L, 5L, 5L});
            tx.success();
        }
        tx = slave.beginTx();
        var6_4 = null;
        try {
            slave.getNodeById(nId).hasProperty(key);
            tx.success();
        }
        catch (Throwable throwable) {
            var6_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        return nId;
    }

    private void restartNeoDataSource(GraphDatabaseAPI slave) throws Throwable {
        ((DataSourceManager)slave.getDependencyResolver().resolveDependency(DataSourceManager.class)).getDataSource().stop();
        ((DataSourceManager)slave.getDependencyResolver().resolveDependency(DataSourceManager.class)).getDataSource().start();
    }
}

