/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageCommandReaderFactory;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.storageengine.api.CommandReader;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class IndexDefineCommandTest {
    @Test
    public void testIndexCommandCreationEnforcesLimit() throws Exception {
        IndexDefineCommand idc = new IndexDefineCommand();
        int count = 65534;
        for (int i = 0; i < count; ++i) {
            idc.getOrAssignKeyId("key" + i);
            idc.getOrAssignIndexNameId("index" + i);
        }
        try {
            idc.getOrAssignKeyId("dropThatOverflows");
            Assert.fail((String)("IndexDefineCommand should not allow more than " + count + " indexes per transaction"));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            idc.getOrAssignIndexNameId("dropThatOverflows");
            Assert.fail((String)("IndexDefineCommand should not allow more than " + count + " keys per transaction"));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldWriteIndexDefineCommandIfMapWithinShortRange() throws IOException {
        InMemoryClosableChannel channel = new InMemoryClosableChannel(10000);
        IndexDefineCommand command = this.initIndexDefineCommand(300);
        command.serialize((WritableChannel)channel);
        CommandReader commandReader = new RecordStorageCommandReaderFactory().byVersion(LogEntryVersion.CURRENT.byteCode());
        IndexDefineCommand read = (IndexDefineCommand)commandReader.read((ReadableChannel)channel);
        Assert.assertEquals((Object)command.getIndexNameIdRange(), (Object)read.getIndexNameIdRange());
        Assert.assertEquals((Object)command.getKeyIdRange(), (Object)read.getKeyIdRange());
    }

    @Test
    public void shouldFailToWriteIndexDefineCommandIfMapIsLargerThanShort() throws IOException {
        InMemoryClosableChannel channel = new InMemoryClosableChannel(1000);
        IndexDefineCommand command = (IndexDefineCommand)Mockito.mock(IndexDefineCommand.class);
        Map<String, Integer> largeMap = this.initMap(65536);
        Mockito.when((Object)command.getIndexNameIdRange()).thenReturn(largeMap);
        Mockito.when((Object)command.getKeyIdRange()).thenReturn(largeMap);
        try {
            command.serialize((WritableChannel)channel);
            Assert.fail((String)"Expected an AssertionError");
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    private IndexDefineCommand initIndexDefineCommand(int nbrOfEntries) {
        IndexDefineCommand command = new IndexDefineCommand();
        Map<String, Integer> indexNames = this.initMap(nbrOfEntries);
        Map<String, Integer> keys = this.initMap(nbrOfEntries);
        command.init(indexNames, keys);
        return command;
    }

    private Map<String, Integer> initMap(int nbrOfEntries) {
        HashMap<String, Integer> toReturn = new HashMap<String, Integer>();
        while (nbrOfEntries-- > 0) {
            toReturn.put("key" + nbrOfEntries, nbrOfEntries);
        }
        return toReturn;
    }
}

