/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.time.Clock;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.locking.LockAcquisitionTimeoutException;
import org.neo4j.kernel.impl.locking.LockingCompatibilityTestSuite;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;

@Ignore(value="Not a test. This is a compatibility suite, run from LockingCompatibilityTestSuite.")
public class AcquisitionTimeoutCompatibility
extends LockingCompatibilityTestSuite.Compatibility {
    private final long TEST_TIMEOUT = 2000L;
    private FakeClock clock;
    private Config customConfig;
    private Locks lockManager;
    private Locks.Client client;
    private Locks.Client client2;

    public AcquisitionTimeoutCompatibility(LockingCompatibilityTestSuite suite) {
        super(suite);
    }

    @Before
    public void setUp() {
        this.customConfig = new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.lock_acquisition_timeout.name(), "100ms"}));
        this.clock = Clocks.fakeClock((long)100000L, (TimeUnit)TimeUnit.MINUTES);
        this.lockManager = this.suite.createLockManager(this.customConfig, (Clock)this.clock);
        this.client = this.lockManager.newClient();
        this.client2 = this.lockManager.newClient();
    }

    @After
    public void tearDown() {
        this.client2.close();
        this.client.close();
        this.lockManager.close();
    }

    @Test(timeout=2000L)
    public void terminateSharedLockAcquisition() throws ExecutionException, InterruptedException {
        this.client.acquireExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future<Boolean> sharedLockAcquisition = this.threadB.execute(state -> {
            this.client2.acquireShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
            return true;
        });
        Assert.assertFalse((boolean)sharedLockAcquisition.isDone());
        this.clock.forward(101L, TimeUnit.MILLISECONDS);
        this.verifyAcquisitionFailure(sharedLockAcquisition);
    }

    @Test(timeout=2000L)
    public void terminateExclusiveLockAcquisitionForExclusivelyLockedResource() throws InterruptedException {
        this.client.acquireExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future<Boolean> exclusiveLockAcquisition = this.threadB.execute(state -> {
            this.client2.acquireExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
            return true;
        });
        Assert.assertFalse((boolean)exclusiveLockAcquisition.isDone());
        this.clock.forward(101L, TimeUnit.MILLISECONDS);
        this.verifyAcquisitionFailure(exclusiveLockAcquisition);
    }

    @Test(timeout=2000L)
    public void terminateExclusiveLockAcquisitionForSharedLockedResource() throws InterruptedException {
        this.client.acquireShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future<Boolean> exclusiveLockAcquisition = this.threadB.execute(state -> {
            this.client2.acquireExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
            return true;
        });
        Assert.assertFalse((boolean)exclusiveLockAcquisition.isDone());
        this.clock.forward(101L, TimeUnit.MILLISECONDS);
        this.verifyAcquisitionFailure(exclusiveLockAcquisition);
    }

    @Test(timeout=2000L)
    public void terminateExclusiveLockAcquisitionForSharedLockedResourceWithSharedLockHeld() throws InterruptedException {
        this.client.acquireShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.client2.acquireShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
        Future<Boolean> exclusiveLockAcquisition = this.threadB.execute(state -> {
            this.client2.acquireExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
            return true;
        });
        Assert.assertFalse((boolean)exclusiveLockAcquisition.isDone());
        this.clock.forward(101L, TimeUnit.MILLISECONDS);
        this.verifyAcquisitionFailure(exclusiveLockAcquisition);
    }

    private void verifyAcquisitionFailure(Future<Boolean> lockAcquisition) throws InterruptedException {
        try {
            lockAcquisition.get();
            Assert.fail((String)"Lock acquisition should fail.");
        }
        catch (ExecutionException e) {
            Assert.assertThat((Object)Exceptions.rootCause((Throwable)e), (Matcher)CoreMatchers.instanceOf(LockAcquisitionTimeoutException.class));
        }
    }
}

