/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.locking.LockClientStateHolder;
import org.neo4j.kernel.impl.locking.LockClientStoppedException;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.NoOpClient;

public class LockClientStateHolderTest {
    @Test
    public void shouldAllowIncrementDecrementClientsWhileNotClosed() {
        LockClientStateHolder lockClientStateHolder = new LockClientStateHolder();
        Assert.assertFalse((boolean)lockClientStateHolder.hasActiveClients());
        lockClientStateHolder.incrementActiveClients((Locks.Client)new NoOpClient());
        Assert.assertTrue((boolean)lockClientStateHolder.hasActiveClients());
        lockClientStateHolder.incrementActiveClients((Locks.Client)new NoOpClient());
        lockClientStateHolder.incrementActiveClients((Locks.Client)new NoOpClient());
        lockClientStateHolder.decrementActiveClients();
        lockClientStateHolder.decrementActiveClients();
        lockClientStateHolder.decrementActiveClients();
        Assert.assertFalse((boolean)lockClientStateHolder.hasActiveClients());
    }

    @Test
    public void shouldNotAllowNewClientsWhenClosed() {
        LockClientStateHolder lockClientStateHolder = new LockClientStateHolder();
        lockClientStateHolder.stopClient();
        Assert.assertFalse((boolean)lockClientStateHolder.hasActiveClients());
        try {
            lockClientStateHolder.incrementActiveClients((Locks.Client)new NoOpClient());
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(LockClientStoppedException.class));
        }
    }

    @Test
    public void shouldBeAbleToDecrementActiveItemAndDetectWhenFree() {
        LockClientStateHolder lockClientStateHolder = new LockClientStateHolder();
        lockClientStateHolder.incrementActiveClients((Locks.Client)new NoOpClient());
        lockClientStateHolder.incrementActiveClients((Locks.Client)new NoOpClient());
        lockClientStateHolder.decrementActiveClients();
        lockClientStateHolder.incrementActiveClients((Locks.Client)new NoOpClient());
        Assert.assertTrue((boolean)lockClientStateHolder.hasActiveClients());
        lockClientStateHolder.stopClient();
        Assert.assertTrue((boolean)lockClientStateHolder.hasActiveClients());
        lockClientStateHolder.decrementActiveClients();
        Assert.assertTrue((boolean)lockClientStateHolder.hasActiveClients());
        lockClientStateHolder.decrementActiveClients();
        Assert.assertFalse((boolean)lockClientStateHolder.hasActiveClients());
    }

    @Test
    public void shouldBeAbleToResetAndReuseClientState() {
        LockClientStateHolder lockClientStateHolder = new LockClientStateHolder();
        lockClientStateHolder.incrementActiveClients((Locks.Client)new NoOpClient());
        lockClientStateHolder.incrementActiveClients((Locks.Client)new NoOpClient());
        lockClientStateHolder.decrementActiveClients();
        Assert.assertTrue((boolean)lockClientStateHolder.hasActiveClients());
        lockClientStateHolder.stopClient();
        Assert.assertTrue((boolean)lockClientStateHolder.hasActiveClients());
        Assert.assertTrue((boolean)lockClientStateHolder.isStopped());
        lockClientStateHolder.reset();
        Assert.assertFalse((boolean)lockClientStateHolder.hasActiveClients());
        Assert.assertFalse((boolean)lockClientStateHolder.isStopped());
        lockClientStateHolder.incrementActiveClients((Locks.Client)new NoOpClient());
        Assert.assertTrue((boolean)lockClientStateHolder.hasActiveClients());
        Assert.assertFalse((boolean)lockClientStateHolder.isStopped());
    }
}

