/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.kernel.impl.locking.LockClientStoppedException;
import org.neo4j.kernel.impl.locking.LockCountVisitor;
import org.neo4j.kernel.impl.locking.LockingCompatibilityTestSuite;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.test.OtherThreadExecutor;

@Ignore(value="Not a test. This is a compatibility suite, run from LockingCompatibilityTestSuite.")
public class StopCompatibility
extends LockingCompatibilityTestSuite.Compatibility {
    private static final ResourceType RESOURCE_TYPE = ResourceTypes.NODE;
    private static final long RESOURCE_ID = 42L;
    private static final long OTHER_RESOURCE_ID = 4242L;
    private Locks.Client client;

    public StopCompatibility(LockingCompatibilityTestSuite suite) {
        super(suite);
    }

    @Before
    public void setUp() throws Exception {
        this.client = this.locks.newClient();
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void releaseWriteLockWaitersOnStop() {
        this.clientA.acquireShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientB.acquireShared((ResourceType)ResourceTypes.NODE, new long[]{2L});
        this.clientC.acquireShared((ResourceType)ResourceTypes.NODE, new long[]{3L});
        this.acquireExclusive(this.clientB, (ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.acquireExclusive(this.clientC, (ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientC.stop();
        this.clientB.stop();
        this.clientA.stop();
        LockCountVisitor lockCountVisitor = new LockCountVisitor();
        this.locks.accept((Locks.Visitor)lockCountVisitor);
        Assert.assertEquals((long)3L, (long)lockCountVisitor.getLockCount());
    }

    @Test
    public void releaseReadLockWaitersOnStop() {
        this.clientA.acquireExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
        this.clientB.acquireExclusive((ResourceType)ResourceTypes.NODE, new long[]{2L});
        this.acquireShared(this.clientB, (ResourceType)ResourceTypes.NODE, 1L).callAndAssertWaiting();
        this.clientB.stop();
        this.clientA.stop();
        LockCountVisitor lockCountVisitor = new LockCountVisitor();
        this.locks.accept((Locks.Visitor)lockCountVisitor);
        Assert.assertEquals((long)2L, (long)lockCountVisitor.getLockCount());
    }

    @Test(expected=LockClientStoppedException.class)
    public void acquireSharedThrowsWhenClientStopped() {
        this.stoppedClient().acquireShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
    }

    @Test(expected=LockClientStoppedException.class)
    public void acquireExclusiveThrowsWhenClientStopped() {
        this.stoppedClient().acquireExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
    }

    @Test(expected=LockClientStoppedException.class)
    public void trySharedLockThrowsWhenClientStopped() {
        this.stoppedClient().trySharedLock((ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test(expected=LockClientStoppedException.class)
    public void tryExclusiveLockThrowsWhenClientStopped() {
        this.stoppedClient().tryExclusiveLock((ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test(expected=LockClientStoppedException.class)
    public void releaseSharedThrowsWhenClientStopped() {
        this.stoppedClient().releaseShared((ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test(expected=LockClientStoppedException.class)
    public void releaseExclusiveThrowsWhenClientStopped() {
        this.stoppedClient().releaseExclusive((ResourceType)ResourceTypes.NODE, 1L);
    }

    @Test
    public void sharedLockCanBeStopped() throws Exception {
        this.acquireExclusiveLockInThisThread();
        LockAcquisition sharedLockAcquisition = this.acquireSharedLockInAnotherThread();
        this.assertThreadIsWaitingForLock(sharedLockAcquisition);
        sharedLockAcquisition.stop();
        this.assertLockAcquisitionFailed(sharedLockAcquisition);
    }

    @Test
    public void exclusiveLockCanBeStopped() throws Exception {
        this.acquireExclusiveLockInThisThread();
        LockAcquisition exclusiveLockAcquisition = this.acquireExclusiveLockInAnotherThread();
        this.assertThreadIsWaitingForLock(exclusiveLockAcquisition);
        exclusiveLockAcquisition.stop();
        this.assertLockAcquisitionFailed(exclusiveLockAcquisition);
    }

    @Test
    public void acquireSharedLockAfterSharedLockStoppedOtherThread() throws Exception {
        AcquiredLock thisThreadsExclusiveLock = this.acquireExclusiveLockInThisThread();
        LockAcquisition sharedLockAcquisition1 = this.acquireSharedLockInAnotherThread();
        this.assertThreadIsWaitingForLock(sharedLockAcquisition1);
        sharedLockAcquisition1.stop();
        this.assertLockAcquisitionFailed(sharedLockAcquisition1);
        thisThreadsExclusiveLock.release();
        LockAcquisition sharedLockAcquisition2 = this.acquireSharedLockInAnotherThread();
        this.assertLockAcquisitionSucceeded(sharedLockAcquisition2);
    }

    @Test
    public void acquireExclusiveLockAfterExclusiveLockStoppedOtherThread() throws Exception {
        AcquiredLock thisThreadsExclusiveLock = this.acquireExclusiveLockInThisThread();
        LockAcquisition exclusiveLockAcquisition1 = this.acquireExclusiveLockInAnotherThread();
        this.assertThreadIsWaitingForLock(exclusiveLockAcquisition1);
        exclusiveLockAcquisition1.stop();
        this.assertLockAcquisitionFailed(exclusiveLockAcquisition1);
        thisThreadsExclusiveLock.release();
        LockAcquisition exclusiveLockAcquisition2 = this.acquireExclusiveLockInAnotherThread();
        this.assertLockAcquisitionSucceeded(exclusiveLockAcquisition2);
    }

    @Test
    public void acquireSharedLockAfterExclusiveLockStoppedOtherThread() throws Exception {
        AcquiredLock thisThreadsExclusiveLock = this.acquireExclusiveLockInThisThread();
        LockAcquisition exclusiveLockAcquisition = this.acquireExclusiveLockInAnotherThread();
        this.assertThreadIsWaitingForLock(exclusiveLockAcquisition);
        exclusiveLockAcquisition.stop();
        this.assertLockAcquisitionFailed(exclusiveLockAcquisition);
        thisThreadsExclusiveLock.release();
        LockAcquisition sharedLockAcquisition = this.acquireSharedLockInAnotherThread();
        this.assertLockAcquisitionSucceeded(sharedLockAcquisition);
    }

    @Test
    public void acquireExclusiveLockAfterSharedLockStoppedOtherThread() throws Exception {
        AcquiredLock thisThreadsExclusiveLock = this.acquireExclusiveLockInThisThread();
        LockAcquisition sharedLockAcquisition = this.acquireSharedLockInAnotherThread();
        this.assertThreadIsWaitingForLock(sharedLockAcquisition);
        sharedLockAcquisition.stop();
        this.assertLockAcquisitionFailed(sharedLockAcquisition);
        thisThreadsExclusiveLock.release();
        LockAcquisition exclusiveLockAcquisition = this.acquireExclusiveLockInAnotherThread();
        this.assertLockAcquisitionSucceeded(exclusiveLockAcquisition);
    }

    @Test
    public void acquireSharedLockAfterSharedLockStoppedSameThread() throws Exception {
        this.acquireLockAfterOtherLockStoppedSameThread(true, true);
    }

    @Test
    public void acquireExclusiveLockAfterExclusiveLockStoppedSameThread() throws Exception {
        this.acquireLockAfterOtherLockStoppedSameThread(false, false);
    }

    @Test
    public void acquireSharedLockAfterExclusiveLockStoppedSameThread() throws Exception {
        this.acquireLockAfterOtherLockStoppedSameThread(true, false);
    }

    @Test
    public void acquireExclusiveLockAfterSharedLockStoppedSameThread() throws Exception {
        this.acquireLockAfterOtherLockStoppedSameThread(false, true);
    }

    @Test
    public void closeClientAfterSharedLockStopped() throws Exception {
        this.closeClientAfterLockStopped(true);
    }

    @Test
    public void closeClientAfterExclusiveLockStopped() throws Exception {
        this.closeClientAfterLockStopped(false);
    }

    @Test
    public void acquireExclusiveLockWhileHoldingSharedLockCanBeStopped() throws Exception {
        AcquiredLock thisThreadsSharedLock = this.acquireSharedLockInThisThread();
        CountDownLatch sharedLockAcquired = new CountDownLatch(1);
        CountDownLatch startExclusiveLock = new CountDownLatch(1);
        LockAcquisition acquisition = this.acquireSharedAndExclusiveLocksInAnotherThread(sharedLockAcquired, startExclusiveLock);
        StopCompatibility.await(sharedLockAcquired);
        startExclusiveLock.countDown();
        this.assertThreadIsWaitingForLock(acquisition);
        acquisition.stop();
        this.assertLockAcquisitionFailed(acquisition);
        thisThreadsSharedLock.release();
        this.assertNoLocksHeld();
    }

    private Locks.Client stoppedClient() {
        try {
            this.client.stop();
            return this.client;
        }
        catch (Throwable t) {
            throw new AssertionError("Unable to stop client", t);
        }
    }

    private void closeClientAfterLockStopped(boolean shared) throws Exception {
        AcquiredLock thisThreadsExclusiveLock = this.acquireExclusiveLockInThisThread();
        CountDownLatch firstLockAcquired = new CountDownLatch(1);
        LockAcquisition acquisition = this.tryAcquireTwoLocksLockInAnotherThread(shared, firstLockAcquired);
        StopCompatibility.await(firstLockAcquired);
        this.assertThreadIsWaitingForLock(acquisition);
        this.assertLocksHeld(42L, 4242L);
        acquisition.stop();
        this.assertLockAcquisitionFailed(acquisition);
        this.assertLocksHeld(42L);
        thisThreadsExclusiveLock.release();
        this.assertNoLocksHeld();
    }

    private void acquireLockAfterOtherLockStoppedSameThread(boolean firstLockShared, boolean secondLockShared) throws Exception {
        AcquiredLock thisThreadsExclusiveLock = this.acquireExclusiveLockInThisThread();
        CountDownLatch firstLockFailed = new CountDownLatch(1);
        CountDownLatch startSecondLock = new CountDownLatch(1);
        LockAcquisition lockAcquisition = this.acquireTwoLocksInAnotherThread(firstLockShared, secondLockShared, firstLockFailed, startSecondLock);
        this.assertThreadIsWaitingForLock(lockAcquisition);
        lockAcquisition.stop();
        StopCompatibility.await(firstLockFailed);
        thisThreadsExclusiveLock.release();
        startSecondLock.countDown();
        this.assertLockAcquisitionSucceeded(lockAcquisition);
    }

    private AcquiredLock acquireSharedLockInThisThread() {
        this.client.acquireShared(RESOURCE_TYPE, new long[]{42L});
        this.assertLocksHeld(42L);
        return AcquiredLock.shared(this.client, RESOURCE_TYPE, 42L);
    }

    private AcquiredLock acquireExclusiveLockInThisThread() {
        this.client.acquireExclusive(RESOURCE_TYPE, new long[]{42L});
        this.assertLocksHeld(42L);
        return AcquiredLock.exclusive(this.client, RESOURCE_TYPE, 42L);
    }

    private LockAcquisition acquireSharedLockInAnotherThread() {
        return this.acquireLockInAnotherThread(true);
    }

    private LockAcquisition acquireExclusiveLockInAnotherThread() {
        return this.acquireLockInAnotherThread(false);
    }

    private LockAcquisition acquireLockInAnotherThread(boolean shared) {
        LockAcquisition lockAcquisition = new LockAcquisition();
        Future<Void> future = this.threadA.execute(state -> {
            Locks.Client client = this.newLockClient(lockAcquisition);
            if (shared) {
                client.acquireShared(RESOURCE_TYPE, new long[]{42L});
            } else {
                client.acquireExclusive(RESOURCE_TYPE, new long[]{42L});
            }
            return null;
        });
        lockAcquisition.setFuture(future, this.threadA.get());
        return lockAcquisition;
    }

    private LockAcquisition acquireTwoLocksInAnotherThread(boolean firstShared, boolean secondShared, CountDownLatch firstLockFailed, CountDownLatch startSecondLock) {
        LockAcquisition lockAcquisition = new LockAcquisition();
        Future<Void> future = this.threadA.execute(state -> {
            try (Locks.Client client = this.newLockClient(lockAcquisition);){
                try {
                    if (firstShared) {
                        client.acquireShared(RESOURCE_TYPE, new long[]{42L});
                    } else {
                        client.acquireExclusive(RESOURCE_TYPE, new long[]{42L});
                    }
                    Assert.fail((String)"Transaction termination expected");
                }
                catch (Exception e) {
                    Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(LockClientStoppedException.class));
                }
            }
            lockAcquisition.setClient(null);
            firstLockFailed.countDown();
            StopCompatibility.await(startSecondLock);
            client = this.newLockClient(lockAcquisition);
            var8_8 = null;
            try {
                if (secondShared) {
                    client.acquireShared(RESOURCE_TYPE, new long[]{42L});
                } else {
                    client.acquireExclusive(RESOURCE_TYPE, new long[]{42L});
                }
            }
            catch (Throwable throwable) {
                var8_8 = throwable;
                throw throwable;
            }
            finally {
                if (client != null) {
                    if (var8_8 != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            var8_8.addSuppressed(throwable);
                        }
                    } else {
                        client.close();
                    }
                }
            }
            return null;
        });
        lockAcquisition.setFuture(future, this.threadA.get());
        return lockAcquisition;
    }

    private LockAcquisition acquireSharedAndExclusiveLocksInAnotherThread(CountDownLatch sharedLockAcquired, CountDownLatch startExclusiveLock) {
        LockAcquisition lockAcquisition = new LockAcquisition();
        Future<Void> future = this.threadA.execute(state -> {
            try (Locks.Client client = this.newLockClient(lockAcquisition);){
                client.acquireShared(RESOURCE_TYPE, new long[]{42L});
                sharedLockAcquired.countDown();
                StopCompatibility.await(startExclusiveLock);
                client.acquireExclusive(RESOURCE_TYPE, new long[]{42L});
            }
            return null;
        });
        lockAcquisition.setFuture(future, this.threadA.get());
        return lockAcquisition;
    }

    private LockAcquisition tryAcquireTwoLocksLockInAnotherThread(boolean shared, CountDownLatch firstLockAcquired) {
        LockAcquisition lockAcquisition = new LockAcquisition();
        Future<Void> future = this.threadA.execute(state -> {
            try (Locks.Client client = this.newLockClient(lockAcquisition);){
                if (shared) {
                    client.acquireShared(RESOURCE_TYPE, new long[]{4242L});
                } else {
                    client.acquireExclusive(RESOURCE_TYPE, new long[]{4242L});
                }
                firstLockAcquired.countDown();
                if (shared) {
                    client.acquireShared(RESOURCE_TYPE, new long[]{42L});
                } else {
                    client.acquireExclusive(RESOURCE_TYPE, new long[]{42L});
                }
            }
            return null;
        });
        lockAcquisition.setFuture(future, this.threadA.get());
        return lockAcquisition;
    }

    private Locks.Client newLockClient(LockAcquisition lockAcquisition) {
        Locks.Client client = this.locks.newClient();
        lockAcquisition.setClient(client);
        return client;
    }

    private void assertLocksHeld(Long ... expectedResourceIds) {
        List<Long> expectedLockedIds = Arrays.asList(expectedResourceIds);
        ArrayList seenLockedIds = new ArrayList();
        this.locks.accept((resourceType, resourceId, description, estimatedWaitTime, lockIdentityHashCode) -> seenLockedIds.add(resourceId));
        Collections.sort(expectedLockedIds);
        Collections.sort(seenLockedIds);
        Assert.assertEquals((String)"unexpected locked resource ids", expectedLockedIds, seenLockedIds);
    }

    private void assertNoLocksHeld() {
        this.locks.accept((resourceType, resourceId, description, estimatedWaitTime, lockIdentityHashCode) -> Assert.fail((String)("Unexpected lock on " + resourceType + " " + resourceId)));
    }

    private void assertThreadIsWaitingForLock(LockAcquisition lockAcquisition) throws Exception {
        for (int i = 0; i < 30 && !this.suite.isAwaitingLockAcquisition(lockAcquisition.executor.waitUntilWaiting()); ++i) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(100L));
        }
        Assert.assertFalse((String)"locking thread completed", (boolean)lockAcquisition.completed());
    }

    private void assertLockAcquisitionSucceeded(LockAcquisition lockAcquisition) throws Exception {
        boolean completed = false;
        for (int i = 0; i < 30; ++i) {
            try {
                Assert.assertNull((Object)lockAcquisition.result());
                completed = true;
                continue;
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }
        Assert.assertTrue((String)"lock was not acquired in time", (boolean)completed);
        Assert.assertTrue((String)"locking thread seem to be still in progress", (boolean)lockAcquisition.completed());
    }

    private void assertLockAcquisitionFailed(LockAcquisition lockAcquisition) throws Exception {
        ExecutionException executionException = null;
        for (int i = 0; i < 30; ++i) {
            try {
                lockAcquisition.result();
                Assert.fail((String)"Transaction termination expected");
                continue;
            }
            catch (ExecutionException e) {
                executionException = e;
                continue;
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }
        Assert.assertNotNull((String)"execution should fail", executionException);
        Assert.assertThat((Object)executionException.getCause(), (Matcher)Matchers.instanceOf(LockClientStoppedException.class));
        Assert.assertTrue((String)"locking thread seem to be still in progress", (boolean)lockAcquisition.completed());
    }

    private static void await(CountDownLatch latch) throws InterruptedException {
        if (!latch.await(1L, TimeUnit.MINUTES)) {
            Assert.fail((String)"Count down did not happen");
        }
    }

    private static class AcquiredLock {
        final Locks.Client client;
        final boolean shared;
        final ResourceType resourceType;
        final long resourceId;

        AcquiredLock(Locks.Client client, boolean shared, ResourceType resourceType, long resourceId) {
            this.client = client;
            this.shared = shared;
            this.resourceType = resourceType;
            this.resourceId = resourceId;
        }

        static AcquiredLock shared(Locks.Client client, ResourceType resourceType, long resourceId) {
            return new AcquiredLock(client, true, resourceType, resourceId);
        }

        static AcquiredLock exclusive(Locks.Client client, ResourceType resourceType, long resourceId) {
            return new AcquiredLock(client, false, resourceType, resourceId);
        }

        void release() {
            if (this.shared) {
                this.client.releaseShared(this.resourceType, this.resourceId);
            } else {
                this.client.releaseExclusive(this.resourceType, this.resourceId);
            }
        }
    }

    private static class LockAcquisition {
        volatile Future<?> future;
        volatile Locks.Client client;
        volatile OtherThreadExecutor<Void> executor;

        private LockAcquisition() {
        }

        Future<?> getFuture() {
            Objects.requireNonNull(this.future, "lock acquisition was not initialized with future");
            return this.future;
        }

        void setFuture(Future<?> future, OtherThreadExecutor<Void> executor) {
            this.future = future;
            this.executor = executor;
        }

        Locks.Client getClient() {
            Objects.requireNonNull(this.client, "lock acquisition was not initialized with client");
            return this.client;
        }

        void setClient(Locks.Client client) {
            this.client = client;
        }

        Object result() throws InterruptedException, ExecutionException, TimeoutException {
            return this.getFuture().get(100L, TimeUnit.MILLISECONDS);
        }

        boolean completed() {
            return this.getFuture().isDone();
        }

        void stop() {
            this.getClient().stop();
        }
    }
}

