/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import com.google.common.jimfs.Configuration;
import com.google.common.jimfs.Jimfs;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import org.apache.commons.lang3.SystemUtils;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.io.fs.DelegateFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.pagecache.StandalonePageCacheFactory;

public class StandalonePageCacheFactoryTest {
    @Test(timeout=10000L)
    public void mustAutomaticallyStartEvictionThread() throws IOException {
        try (DelegateFileSystemAbstraction fs = new DelegateFileSystemAbstraction(Jimfs.newFileSystem((Configuration)this.jimConfig()));){
            File file = new File("/a").getCanonicalFile();
            fs.create(file).close();
            try (PageCache cache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fs);
                 PagedFile pf = cache.map(file, 4096, new OpenOption[0]);
                 PageCursor cursor = pf.io(0L, 2);){
                for (int i = 0; i < 10000; ++i) {
                    Assert.assertTrue((boolean)cursor.next());
                    cursor.putInt(42);
                }
            }
        }
    }

    private Configuration jimConfig() {
        if (SystemUtils.IS_OS_WINDOWS) {
            ArrayList rootList = new ArrayList();
            FileSystems.getDefault().getRootDirectories().forEach(path -> rootList.add(path.toString()));
            Configuration.Builder builder = Configuration.windows().toBuilder();
            if (rootList.size() > 1) {
                builder.setRoots((String)rootList.get(0), rootList.subList(1, rootList.size()).toArray(new String[0]));
            } else {
                builder.setRoots((String)rootList.get(0), new String[0]);
            }
        } else if (SystemUtils.IS_OS_MAC_OSX) {
            return Configuration.osX();
        }
        return Configuration.unix();
    }
}

