/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.collection.RawIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.proc.BasicContext;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.impl.proc.ComponentRegistry;
import org.neo4j.kernel.impl.proc.ProcedureAllowedConfig;
import org.neo4j.kernel.impl.proc.ReflectiveProcedureCompiler;
import org.neo4j.kernel.impl.proc.TypeMappers;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ReflectiveProcedureWithArgumentsTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void shouldCompileSimpleProcedure() throws Throwable {
        List<CallableProcedure> procedures = this.compile(ClassWithProcedureWithSimpleArgs.class);
        TestCase.assertEquals((int)1, (int)procedures.size());
        Assert.assertThat((Object)procedures.get(0).signature(), (Matcher)Matchers.equalTo((Object)ProcedureSignature.procedureSignature((String[])new String[]{"org", "neo4j", "kernel", "impl", "proc", "listCoolPeople"}).in("name", (Neo4jTypes.AnyType)Neo4jTypes.NTString).in("age", (Neo4jTypes.AnyType)Neo4jTypes.NTInteger).out("name", (Neo4jTypes.AnyType)Neo4jTypes.NTString).build()));
    }

    @Test
    public void shouldRunSimpleProcedure() throws Throwable {
        CallableProcedure procedure = this.compile(ClassWithProcedureWithSimpleArgs.class).get(0);
        RawIterator out = procedure.apply((Context)new BasicContext(), new Object[]{"Pontus", 35L});
        List collect = Iterators.asList((RawIterator)out);
        Assert.assertThat((Object)((Object[])collect.get(0))[0], (Matcher)Matchers.equalTo((Object)"Pontus is 35 years old."));
    }

    @Test
    public void shouldRunGenericProcedure() throws Throwable {
        CallableProcedure procedure = this.compile(ClassWithProcedureWithGenericArgs.class).get(0);
        RawIterator out = procedure.apply((Context)new BasicContext(), new Object[]{Arrays.asList("Roland", "Eddie", "Susan", "Jake"), Arrays.asList(1000L, 23L, 29L, 12L)});
        List collect = Iterators.asList((RawIterator)out);
        Assert.assertThat((Object)((Object[])collect.get(0))[0], (Matcher)Matchers.equalTo((Object)"Roland is 1000 years old."));
        Assert.assertThat((Object)((Object[])collect.get(1))[0], (Matcher)Matchers.equalTo((Object)"Eddie is 23 years old."));
        Assert.assertThat((Object)((Object[])collect.get(2))[0], (Matcher)Matchers.equalTo((Object)"Susan is 29 years old."));
        Assert.assertThat((Object)((Object[])collect.get(3))[0], (Matcher)Matchers.equalTo((Object)"Jake is 12 years old."));
    }

    @Test
    public void shouldFailIfMissingAnnotations() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage(String.format("Argument at position 0 in method `listCoolPeople` is missing an `@Name` annotation.%nPlease add the annotation, recompile the class and try again.", new Object[0]));
        this.compile(ClassWithProcedureWithoutAnnotatedArgs.class);
    }

    @Test
    public void shouldFailIfMisplacedDefaultValue() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Non-default argument at position 2 with name c in method defaultValues follows default argument. Add a default value or rearrange arguments so that the non-default values comes first.");
        this.compile(ClassWithProcedureWithMisplacedDefault.class);
    }

    @Test
    public void shouldFailIfWronglyTypedDefaultValue() throws Throwable {
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage(String.format("Argument `a` at position 0 in `defaultValues` with%ntype `long` cannot be converted to a Neo4j type: Default value `forty-two` could not be parsed as a Long", new Object[0]));
        this.compile(ClassWithProcedureWithBadlyTypedDefault.class);
    }

    private List<CallableProcedure> compile(Class<?> clazz) throws KernelException {
        return new ReflectiveProcedureCompiler(new TypeMappers(), new ComponentRegistry(), (Log)NullLog.getInstance(), ProcedureAllowedConfig.DEFAULT).compileProcedure(clazz);
    }

    public static class ClassWithProcedureWithBadlyTypedDefault {
        @Procedure
        public Stream<MyOutputRecord> defaultValues(@Name(value="a", defaultValue="forty-two") long b) {
            return Stream.empty();
        }
    }

    public static class ClassWithProcedureWithMisplacedDefault {
        @Procedure
        public Stream<MyOutputRecord> defaultValues(@Name(value="a") String a, @Name(value="b", defaultValue="42") long b, @Name(value="c") Object c) {
            return Stream.empty();
        }
    }

    public static class ClassWithProcedureWithDefaults {
        @Procedure
        public Stream<MyOutputRecord> defaultValues(@Name(value="a", defaultValue="a") String a, @Name(value="b", defaultValue="42") long b, @Name(value="c", defaultValue="3.14") double c) {
            return Stream.empty();
        }
    }

    public static class ClassWithProcedureWithoutAnnotatedArgs {
        @Procedure
        public Stream<MyOutputRecord> listCoolPeople(String name, int age) {
            return Stream.of(new MyOutputRecord(name + " is " + age + " years old."));
        }
    }

    public static class ClassWithProcedureWithGenericArgs {
        @Procedure
        public Stream<MyOutputRecord> listCoolPeople(@Name(value="names") List<String> names, @Name(value="age") List<Long> ages) {
            Iterator<String> nameIterator = names.iterator();
            Iterator<Long> ageIterator = ages.iterator();
            ArrayList<MyOutputRecord> result = new ArrayList<MyOutputRecord>(names.size());
            while (nameIterator.hasNext()) {
                long age = ageIterator.hasNext() ? ageIterator.next() : -1L;
                result.add(new MyOutputRecord(nameIterator.next() + " is " + age + " years old."));
            }
            return result.stream();
        }
    }

    public static class ClassWithProcedureWithSimpleArgs {
        @Procedure
        public Stream<MyOutputRecord> listCoolPeople(@Name(value="name") String name, @Name(value="age") long age) {
            return Stream.of(new MyOutputRecord(name + " is " + age + " years old."));
        }
    }

    public static class MyOutputRecord {
        public String name;

        public MyOutputRecord(String name) {
            this.name = name;
        }
    }
}

