/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.recovery;

import java.io.File;
import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.recovery.RecoveryRequiredChecker;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class RecoveryRequiredCheckerTest {
    private final EphemeralFileSystemRule fileSystemRule = new EphemeralFileSystemRule();
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    private final TestDirectory testDirectory = TestDirectory.testDirectory((FileSystemAbstraction)this.fileSystemRule.get());
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.pageCacheRule).around((TestRule)this.fileSystemRule).around((TestRule)this.testDirectory);
    private EphemeralFileSystemAbstraction fileSystem;
    private File storeDir;

    @Before
    public void setup() {
        this.storeDir = this.testDirectory.graphDbDir();
        this.fileSystem = this.fileSystemRule.get();
        new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)this.fileSystem).newImpermanentDatabase(this.storeDir).shutdown();
    }

    @Test
    public void shouldNotWantToRecoverIntactStore() throws Exception {
        PageCache pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fileSystem);
        RecoveryRequiredChecker recoverer = new RecoveryRequiredChecker((FileSystemAbstraction)this.fileSystem, pageCache);
        Assert.assertThat((Object)recoverer.isRecoveryRequiredAt(this.storeDir), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void shouldWantToRecoverBrokenStore() throws Exception {
        try (FileSystemAbstraction fileSystemAbstraction = this.createSomeDataAndCrash(this.storeDir, this.fileSystem);){
            PageCache pageCache = this.pageCacheRule.getPageCache(fileSystemAbstraction);
            RecoveryRequiredChecker recoverer = new RecoveryRequiredChecker(fileSystemAbstraction, pageCache);
            Assert.assertThat((Object)recoverer.isRecoveryRequiredAt(this.storeDir), (Matcher)CoreMatchers.is((Object)true));
        }
    }

    @Test
    public void shouldBeAbleToRecoverBrokenStore() throws Exception {
        try (FileSystemAbstraction fileSystemAbstraction = this.createSomeDataAndCrash(this.storeDir, this.fileSystem);){
            PageCache pageCache = this.pageCacheRule.getPageCache(fileSystemAbstraction);
            RecoveryRequiredChecker recoverer = new RecoveryRequiredChecker(fileSystemAbstraction, pageCache);
            Assert.assertThat((Object)recoverer.isRecoveryRequiredAt(this.storeDir), (Matcher)CoreMatchers.is((Object)true));
            new TestGraphDatabaseFactory().setFileSystem(fileSystemAbstraction).newImpermanentDatabase(this.storeDir).shutdown();
            Assert.assertThat((Object)recoverer.isRecoveryRequiredAt(this.storeDir), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    private FileSystemAbstraction createSomeDataAndCrash(File store, EphemeralFileSystemAbstraction fileSystem) throws IOException {
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)fileSystem).newImpermanentDatabase(store);
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        EphemeralFileSystemAbstraction snapshot = fileSystem.snapshot();
        db.shutdown();
        return snapshot;
    }
}

