/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.countStore;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.store.countStore.CountsSnapshot;
import org.neo4j.kernel.impl.store.countStore.CountsSnapshotDeserializer;
import org.neo4j.kernel.impl.store.countStore.CountsSnapshotSerializer;
import org.neo4j.kernel.impl.store.countStore.CountsStoreMapGenerator;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalFlushableChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosableChannel;
import org.neo4j.test.rule.TestDirectory;

public class InMemoryCountsStoreCountsSnapshotSerializerIntegrationTest {
    @Rule
    public TestDirectory testDir = TestDirectory.testDirectory();

    @Test
    public void smallWorkloadOnInMemoryLogTest() throws IOException {
        long[] value;
        InMemoryClosableChannel tempChannel = new InMemoryClosableChannel();
        Map<CountsKey, long[]> map = CountsStoreMapGenerator.simpleCountStoreMap(1);
        CountsSnapshot countsSnapshot = new CountsSnapshot(1L, map);
        CountsSnapshotSerializer.serialize((FlushableChannel)tempChannel, (CountsSnapshot)countsSnapshot);
        CountsSnapshot recovered = CountsSnapshotDeserializer.deserialize((ReadableClosableChannel)tempChannel);
        Assert.assertEquals((long)countsSnapshot.getTxId(), (long)recovered.getTxId());
        for (Map.Entry pair : countsSnapshot.getMap().entrySet()) {
            value = (long[])recovered.getMap().get(pair.getKey());
            Assert.assertNotNull((Object)value);
            Assert.assertArrayEquals((long[])value, (long[])((long[])pair.getValue()));
        }
        for (Map.Entry pair : recovered.getMap().entrySet()) {
            value = (long[])countsSnapshot.getMap().get(pair.getKey());
            Assert.assertNotNull((Object)value);
            Assert.assertArrayEquals((long[])value, (long[])((long[])pair.getValue()));
        }
    }

    @Test
    public void largeWorkloadOnPhysicalLogTest() throws IOException {
        try (DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();){
            File tempFile = new File(this.testDir.directory(), "temp");
            StoreChannel rawChannel = fs.create(tempFile);
            Map<CountsKey, long[]> map = CountsStoreMapGenerator.simpleCountStoreMap(100000);
            CountsSnapshot countsSnapshot = new CountsSnapshot(1L, map);
            try (PhysicalFlushableChannel tempChannel = new PhysicalFlushableChannel(rawChannel);){
                CountsSnapshotSerializer.serialize((FlushableChannel)tempChannel, (CountsSnapshot)countsSnapshot);
            }
            rawChannel = fs.open(tempFile, "r");
            var9_10 = null;
            try (ReadAheadChannel readAheadChannel = new ReadAheadChannel(rawChannel);){
                long[] value;
                CountsSnapshot recovered = CountsSnapshotDeserializer.deserialize((ReadableClosableChannel)readAheadChannel);
                Assert.assertEquals((long)countsSnapshot.getTxId(), (long)recovered.getTxId());
                for (Map.Entry pair : countsSnapshot.getMap().entrySet()) {
                    value = (long[])recovered.getMap().get(pair.getKey());
                    Assert.assertNotNull((Object)value);
                    Assert.assertArrayEquals((long[])value, (long[])((long[])pair.getValue()));
                }
                for (Map.Entry pair : recovered.getMap().entrySet()) {
                    value = (long[])countsSnapshot.getMap().get(pair.getKey());
                    Assert.assertNotNull((Object)value);
                    Assert.assertArrayEquals((long[])value, (long[])((long[])pair.getValue()));
                }
            }
            catch (Throwable throwable) {
                var9_10 = throwable;
                throw throwable;
            }
        }
    }
}

