/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.countStore;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.kernel.impl.store.countStore.CountsSnapshot;
import org.neo4j.kernel.impl.store.countStore.CountsSnapshotSerializer;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyFactory;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyType;
import org.neo4j.kernel.impl.store.counts.keys.IndexSampleKey;
import org.neo4j.kernel.impl.store.counts.keys.IndexStatisticsKey;
import org.neo4j.kernel.impl.store.counts.keys.NodeKey;
import org.neo4j.kernel.impl.store.counts.keys.RelationshipKey;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;

public class InMemoryCountsStoreCountsSnapshotSerializerTest {
    InMemoryClosableChannel logChannel;
    CountsSnapshot countsSnapshot;
    ByteBuffer expectedBytes;
    ByteBuffer serializedBytes;

    @Before
    public void setup() throws IOException {
        this.logChannel = new InMemoryClosableChannel();
        this.countsSnapshot = new CountsSnapshot(1L, new ConcurrentHashMap());
    }

    @After
    public void after() throws IOException {
        this.logChannel.close();
    }

    @Test
    public void correctlySerializesTxId() throws IOException {
        this.serializedBytes = ByteBuffer.allocate(8);
        this.expectedBytes = ByteBuffer.allocate(8);
        this.writeExpectedTxID(this.expectedBytes, 1L);
        this.writeAndSerializeEntityNode(1, 1L);
        this.expectedBytes.position(0);
        this.logChannel.get(this.serializedBytes.array(), this.serializedBytes.limit());
        Assert.assertEquals((Object)this.expectedBytes, (Object)this.serializedBytes);
    }

    @Test
    public void correctlySerializesTxIdAndMapSize() throws IOException {
        ByteBuffer serializedBytes = ByteBuffer.allocate(12);
        ByteBuffer expectedBytes = ByteBuffer.allocate(12);
        this.writeExpectedTxID(expectedBytes, 1L);
        this.writeExpectedCountStoreSize(expectedBytes, 1);
        this.writeAndSerializeEntityNode(1, 1L);
        expectedBytes.position(0);
        this.logChannel.get(serializedBytes.array(), serializedBytes.limit());
        Assert.assertEquals((Object)expectedBytes, (Object)serializedBytes);
    }

    @Test
    public void correctlySerializesEntityNode() throws IOException {
        int serializedLength = 25;
        this.initializeBuffers(serializedLength);
        this.writeAndSerializeEntityNode(1, 1L);
        this.expectedBytes.put(CountsKeyType.ENTITY_NODE.code);
        this.expectedBytes.putInt(1);
        this.expectedBytes.putLong(1L);
        this.expectedBytes.position(0);
        this.logChannel.get(this.serializedBytes.array(), serializedLength);
        Assert.assertEquals((Object)this.expectedBytes, (Object)this.serializedBytes);
    }

    @Test
    public void correctlySerializesEntityRelationship() throws IOException {
        int serializedLength = 33;
        this.initializeBuffers(serializedLength);
        this.writeAndSerializeEntityRelationship(1, 1, 1, 1L);
        this.expectedBytes.put(CountsKeyType.ENTITY_RELATIONSHIP.code);
        this.expectedBytes.putInt(1);
        this.expectedBytes.putInt(1);
        this.expectedBytes.putInt(1);
        this.expectedBytes.putLong(1L);
        this.expectedBytes.position(0);
        this.logChannel.get(this.serializedBytes.array(), serializedLength);
        Assert.assertEquals((Object)this.expectedBytes, (Object)this.serializedBytes);
    }

    @Test
    public void correctlySerializesIndexSample() throws IOException {
        int serializedLength = 37;
        this.writeAndSerializeIndexSample(1, 1, 1L);
        this.initializeBuffers(serializedLength);
        this.expectedBytes.put(CountsKeyType.INDEX_SAMPLE.code);
        this.expectedBytes.putInt(1);
        this.expectedBytes.putInt(1);
        this.expectedBytes.putLong(1L);
        this.expectedBytes.putLong(1L);
        this.expectedBytes.position(0);
        this.logChannel.get(this.serializedBytes.array(), serializedLength);
        Assert.assertEquals((Object)this.expectedBytes, (Object)this.serializedBytes);
    }

    @Test
    public void correctlySerializesIndexStatistics() throws IOException {
        int serializedLength = 37;
        this.writeAndSerializeIndexStatistics(1, 1, 1L);
        this.initializeBuffers(serializedLength);
        this.expectedBytes.put(CountsKeyType.INDEX_STATISTICS.code);
        this.expectedBytes.putInt(1);
        this.expectedBytes.putInt(1);
        this.expectedBytes.putLong(1L);
        this.expectedBytes.putLong(1L);
        this.expectedBytes.position(0);
        this.logChannel.get(this.serializedBytes.array(), serializedLength);
        Assert.assertEquals((Object)this.expectedBytes, (Object)this.serializedBytes);
    }

    @Test(expected=IllegalArgumentException.class)
    public void throwsExceptionOnWrongValueLengthForEntityNode() throws IOException {
        ConcurrentHashMap<NodeKey, long[]> brokenMap = new ConcurrentHashMap<NodeKey, long[]>();
        brokenMap.put(CountsKeyFactory.nodeKey((int)1), new long[]{1L, 1L});
        CountsSnapshot brokenSnapshot = new CountsSnapshot(1L, brokenMap);
        CountsSnapshotSerializer.serialize((FlushableChannel)this.logChannel, (CountsSnapshot)brokenSnapshot);
    }

    @Test(expected=IllegalArgumentException.class)
    public void throwsExceptionOnWrongValueLengthForEntityRelationship() throws IOException {
        ConcurrentHashMap<RelationshipKey, long[]> brokenMap = new ConcurrentHashMap<RelationshipKey, long[]>();
        brokenMap.put(CountsKeyFactory.relationshipKey((int)1, (int)1, (int)1), new long[]{1L, 1L});
        CountsSnapshot brokenSnapshot = new CountsSnapshot(1L, brokenMap);
        CountsSnapshotSerializer.serialize((FlushableChannel)this.logChannel, (CountsSnapshot)brokenSnapshot);
    }

    @Test(expected=IllegalArgumentException.class)
    public void throwsExceptionOnWrongValueLengthForIndexSample() throws IOException {
        ConcurrentHashMap<IndexSampleKey, long[]> brokenMap = new ConcurrentHashMap<IndexSampleKey, long[]>();
        brokenMap.put(CountsKeyFactory.indexSampleKey((int)1, (int)1), new long[]{1L});
        CountsSnapshot brokenSnapshot = new CountsSnapshot(1L, brokenMap);
        CountsSnapshotSerializer.serialize((FlushableChannel)this.logChannel, (CountsSnapshot)brokenSnapshot);
    }

    @Test(expected=IllegalArgumentException.class)
    public void throwsExceptionOnWrongValueLengthForIndexStatistics() throws IOException {
        ConcurrentHashMap<IndexStatisticsKey, long[]> brokenMap = new ConcurrentHashMap<IndexStatisticsKey, long[]>();
        brokenMap.put(CountsKeyFactory.indexStatisticsKey((int)1, (int)1), new long[]{1L});
        CountsSnapshot brokenSnapshot = new CountsSnapshot(1L, brokenMap);
        CountsSnapshotSerializer.serialize((FlushableChannel)this.logChannel, (CountsSnapshot)brokenSnapshot);
    }

    @Test
    public void onlyHandleExpectedRecordTypes() {
        Assert.assertArrayEquals((Object[])CountsKeyType.values(), (Object[])new CountsKeyType[]{CountsKeyType.EMPTY, CountsKeyType.ENTITY_NODE, CountsKeyType.ENTITY_RELATIONSHIP, CountsKeyType.INDEX_STATISTICS, CountsKeyType.INDEX_SAMPLE});
    }

    private void initializeBuffers(int serializedLength) {
        this.serializedBytes = ByteBuffer.allocate(serializedLength);
        this.expectedBytes = ByteBuffer.allocate(serializedLength);
        this.writeExpectedTxID(this.expectedBytes, 1L);
        this.writeExpectedCountStoreSize(this.expectedBytes, 1);
    }

    private void writeExpectedTxID(ByteBuffer buffer, long txId) {
        buffer.putLong(txId);
    }

    private void writeExpectedCountStoreSize(ByteBuffer buffer, int size) {
        buffer.putInt(size);
    }

    private void writeAndSerializeEntityNode(int labelId, long count) throws IOException {
        this.countsSnapshot.getMap().put(CountsKeyFactory.nodeKey((int)labelId), new long[]{count});
        CountsSnapshotSerializer.serialize((FlushableChannel)this.logChannel, (CountsSnapshot)this.countsSnapshot);
    }

    private void writeAndSerializeEntityRelationship(int startId, int type, int endId, long count) throws IOException {
        this.countsSnapshot.getMap().put(CountsKeyFactory.relationshipKey((int)startId, (int)type, (int)endId), new long[]{count});
        CountsSnapshotSerializer.serialize((FlushableChannel)this.logChannel, (CountsSnapshot)this.countsSnapshot);
    }

    private void writeAndSerializeIndexSample(int labelId, int propertyKeyId, long count) throws IOException {
        this.countsSnapshot.getMap().put(CountsKeyFactory.indexSampleKey((int)labelId, (int)propertyKeyId), new long[]{count, count});
        CountsSnapshotSerializer.serialize((FlushableChannel)this.logChannel, (CountsSnapshot)this.countsSnapshot);
    }

    private void writeAndSerializeIndexStatistics(int labelId, int propertyKeyId, long count) throws IOException {
        this.countsSnapshot.getMap().put(CountsKeyFactory.indexStatisticsKey((int)labelId, (int)propertyKeyId), new long[]{count, count});
        CountsSnapshotSerializer.serialize((FlushableChannel)this.logChannel, (CountsSnapshot)this.countsSnapshot);
    }
}

