/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.countStore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.store.countStore.CountsSnapshot;
import org.neo4j.kernel.impl.store.countStore.InMemoryCountsStore;
import org.neo4j.kernel.impl.store.countStore.IntermediateStateTestManager;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;

public class InMemoryCountsStoreIntegrationTest {
    @Test
    public void singleWriteTest() {
        InMemoryCountsStore countStore = new InMemoryCountsStore();
        IntermediateStateTestManager intermediateStateTestManager = new IntermediateStateTestManager();
        ConcurrentHashMap<CountsKey, long[]> updateMap = new ConcurrentHashMap<CountsKey, long[]>();
        ConcurrentHashMap<CountsKey, long[]> map = new ConcurrentHashMap<CountsKey, long[]>();
        long txId = intermediateStateTestManager.getNextUpdateMap(updateMap);
        InMemoryCountsStoreIntegrationTest.updateMapByDiff(map, updateMap);
        countStore.updateAll(txId, updateMap);
        CountsSnapshot countsSnapshot = countStore.snapshot(txId);
        Map snapshotMap = countsSnapshot.getMap();
        InMemoryCountsStoreIntegrationTest.assertMapEquals(map, snapshotMap);
    }

    @Test
    public void sequentialWorkload() {
        ConcurrentHashMap<CountsKey, long[]> map = new ConcurrentHashMap<CountsKey, long[]>();
        ConcurrentHashMap<CountsKey, long[]> updateMap = new ConcurrentHashMap<CountsKey, long[]>();
        IntermediateStateTestManager intermediateStateTestManager = new IntermediateStateTestManager();
        InMemoryCountsStore countStore = new InMemoryCountsStore();
        for (int i = 0; i < 1000; ++i) {
            long txId = intermediateStateTestManager.getNextUpdateMap(updateMap);
            InMemoryCountsStoreIntegrationTest.updateMapByDiff(map, updateMap);
            countStore.updateAll(txId, updateMap);
            CountsSnapshot countsSnapshot = countStore.snapshot(txId);
            Map snapshotMap = countsSnapshot.getMap();
            InMemoryCountsStoreIntegrationTest.assertMapEquals(map, snapshotMap);
        }
    }

    @Test
    public void concurrentWorkload() throws Exception {
        InMemoryCountsStore countStore = new InMemoryCountsStore();
        IntermediateStateTestManager intermediateStateTestManager = new IntermediateStateTestManager();
        ExecutorService executor = Executors.newFixedThreadPool(10);
        ExecutorCompletionService ecs = new ExecutorCompletionService(executor);
        ArrayList<Runnable> workers = new ArrayList<Runnable>(10);
        AtomicBoolean stop = new AtomicBoolean();
        for (int i = 0; i < 9; ++i) {
            workers.add(new UpdateWorker(stop, intermediateStateTestManager, countStore));
        }
        workers.add(new SnapshotWorker(10, stop, intermediateStateTestManager, countStore));
        for (Runnable worker : workers) {
            ecs.submit(worker, null);
        }
        for (int i = 0; i < workers.size(); ++i) {
            ecs.take().get();
        }
        executor.shutdown();
    }

    private static void assertMapEquals(Map<CountsKey, long[]> expected, Map<CountsKey, long[]> actual) {
        try {
            Assert.assertEquals((long)expected.size(), (long)actual.size());
            actual.forEach((key, value) -> {
                Assert.assertNotNull((String)"Example counts store snapshot has null where key was expected.", expected.get(key));
                Assert.assertArrayEquals((String)"Example counts store snapshot has different value for a key than expected.", (long[])((long[])expected.get(key)), (long[])value);
            });
        }
        catch (Throwable t) {
            actual.forEach((key, value) -> System.out.printf("(%s) -> (%s)\n", key, Arrays.toString(value)));
            System.out.println();
            expected.forEach((key, value) -> System.out.printf("(%s) -> (%s)\n", key, Arrays.toString(value)));
            System.out.println();
            throw t;
        }
    }

    private static synchronized Map<CountsKey, long[]> updateMapByDiff(Map<CountsKey, long[]> map, Map<CountsKey, long[]> diff) {
        diff.entrySet().forEach(pair -> map.compute((CountsKey)pair.getKey(), (k, v) -> v == null ? (long[])pair.getValue() : InMemoryCountsStoreIntegrationTest.updateEachValue(v, (long[])pair.getValue())));
        return map;
    }

    private static long[] updateEachValue(long[] v, long[] value) {
        for (int i = 0; i < v.length; ++i) {
            v[i] = v[i] + value[i];
        }
        return v;
    }

    private class SnapshotWorker
    implements Runnable {
        private AtomicBoolean stop;
        private final IntermediateStateTestManager intermediateStateTestManager;
        private final InMemoryCountsStore countStore;
        private final int repeatTimes;

        public SnapshotWorker(int repeatTimes, AtomicBoolean stop, IntermediateStateTestManager intermediateStateTestManager, InMemoryCountsStore countStore) {
            this.stop = stop;
            this.intermediateStateTestManager = intermediateStateTestManager;
            this.countStore = countStore;
            this.repeatTimes = repeatTimes;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.repeatTimes; ++i) {
                int id = this.intermediateStateTestManager.getId();
                long txId = (long)id + ThreadLocalRandom.current().nextLong(0L, 5L);
                CountsSnapshot countsSnapshot = this.countStore.snapshot(txId);
                long snapshotTxId = countsSnapshot.getTxId();
                Map snapshotMap = countsSnapshot.getMap();
                ConcurrentHashMap<CountsKey, long[]> expectedMap = this.intermediateStateTestManager.getIntermediateMap((int)snapshotTxId);
                Assert.assertThat((String)"Counts store snapshot was recorded with transaction ID less than the requested value.", (Object)snapshotTxId, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(txId)));
                InMemoryCountsStoreIntegrationTest.assertMapEquals(expectedMap, snapshotMap);
            }
            this.stop.set(true);
        }
    }

    private class UpdateWorker
    implements Runnable {
        private final AtomicBoolean stop;
        private final IntermediateStateTestManager manager;
        private final InMemoryCountsStore countStore;

        public UpdateWorker(AtomicBoolean stop, IntermediateStateTestManager manager, InMemoryCountsStore countStore) {
            this.stop = stop;
            this.manager = manager;
            this.countStore = countStore;
        }

        @Override
        public void run() {
            while (!this.stop.get()) {
                HashMap<CountsKey, long[]> map = new HashMap<CountsKey, long[]>();
                int txId = this.manager.getNextUpdateMap(map);
                if (ThreadLocalRandom.current().nextInt(0, 5) == 3) {
                    Thread.yield();
                }
                this.countStore.updateAll((long)txId, map);
            }
        }
    }
}

