/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.countStore;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.store.countStore.CountsSnapshot;
import org.neo4j.kernel.impl.store.countStore.InMemoryCountsStore;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyFactory;
import org.neo4j.kernel.impl.store.counts.keys.NodeKey;

public class InMemoryCountsStoreTest {
    @Test
    public void getExpectedValue() {
        InMemoryCountsStore countStore = new InMemoryCountsStore();
        HashMap<NodeKey, long[]> update = new HashMap<NodeKey, long[]>();
        NodeKey key = CountsKeyFactory.nodeKey((int)1);
        update.put(key, new long[]{1L});
        countStore.updateAll(1L, update);
        Assert.assertEquals((long)countStore.get((CountsKey)key)[0], (long)1L);
    }

    @Test
    public void neverSetKeyReturnsNull() {
        InMemoryCountsStore countStore = new InMemoryCountsStore();
        HashMap<NodeKey, long[]> update = new HashMap<NodeKey, long[]>();
        NodeKey key = CountsKeyFactory.nodeKey((int)1);
        update.put(key, new long[]{1L});
        countStore.updateAll(1L, update);
        Assert.assertNull((Object)countStore.get((CountsKey)CountsKeyFactory.relationshipKey((int)1, (int)1, (int)1)));
    }

    @Test(expected=NullPointerException.class)
    public void getNullKeyResultsInNPE() {
        InMemoryCountsStore countStore = new InMemoryCountsStore();
        HashMap<NodeKey, long[]> update = new HashMap<NodeKey, long[]>();
        NodeKey key = CountsKeyFactory.nodeKey((int)1);
        update.put(key, new long[]{1L});
        countStore.updateAll(1L, update);
        countStore.get(null);
    }

    @Test
    public void emptyUpdate() {
        InMemoryCountsStore countStore = new InMemoryCountsStore();
        HashMap update = new HashMap();
        countStore.updateAll(1L, update);
        CountsSnapshot countsSnapshot = countStore.snapshot(1L);
        Assert.assertEquals((long)countsSnapshot.getTxId(), (long)1L);
        Assert.assertEquals((long)countsSnapshot.getMap().size(), (long)0L);
    }

    @Test
    public void validSnapshot() {
        InMemoryCountsStore countStore = new InMemoryCountsStore();
        HashMap<NodeKey, long[]> update = new HashMap<NodeKey, long[]>();
        NodeKey key = CountsKeyFactory.nodeKey((int)1);
        update.put(key, new long[]{1L});
        countStore.updateAll(1L, update);
        CountsSnapshot countsSnapshot = countStore.snapshot(1L);
        Assert.assertEquals((long)countsSnapshot.getTxId(), (long)1L);
        Assert.assertEquals((long)countsSnapshot.getMap().size(), (long)1L);
        Assert.assertEquals((long)((long[])countsSnapshot.getMap().get(key))[0], (long)1L);
    }

    @Test
    public void restoreFromSnapshot() {
        InMemoryCountsStore countStore = new InMemoryCountsStore();
        HashMap<NodeKey, long[]> update = new HashMap<NodeKey, long[]>();
        NodeKey keyA = CountsKeyFactory.nodeKey((int)1);
        NodeKey keyB = CountsKeyFactory.nodeKey((int)2);
        NodeKey keyC = CountsKeyFactory.nodeKey((int)3);
        update.put(keyA, new long[]{1L});
        countStore.updateAll(1L, update);
        update.clear();
        update.put(keyB, new long[]{1L});
        countStore.updateAll(2L, update);
        update.clear();
        update.put(keyC, new long[]{1L});
        countStore.updateAll(3L, update);
        CountsSnapshot countsSnapshot = countStore.snapshot(3L);
        long beforeTxId = countsSnapshot.getTxId();
        Assert.assertEquals((long)3L, (long)beforeTxId);
        countStore = new InMemoryCountsStore(countsSnapshot);
        CountsSnapshot secondCountsSnapshot = countStore.snapshot(3L);
        Assert.assertEquals((long)3L, (long)secondCountsSnapshot.getTxId());
        update.put(keyC, new long[]{1L});
        countStore.updateAll(4L, update);
        CountsSnapshot thirdCountsSnapshot = countStore.snapshot(4L);
        Assert.assertEquals((long)4L, (long)thirdCountsSnapshot.getTxId());
    }
}

