/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.api.KernelTransactionsSnapshot;
import org.neo4j.kernel.impl.store.id.BufferingIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdReuseEligibility;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.id.configuration.CommunityIdTypeConfigurationProvider;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfigurationProvider;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;

public class BufferingIdGeneratorFactoryTest {
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();

    @Test
    public void shouldDelayFreeingOfAggressivelyReusedIds() throws Exception {
        MockedIdGeneratorFactory actual = new MockedIdGeneratorFactory();
        ControllableSnapshotSupplier boundaries = new ControllableSnapshotSupplier();
        BufferingIdGeneratorFactory bufferingIdGeneratorFactory = new BufferingIdGeneratorFactory((IdGeneratorFactory)actual, (Supplier)boundaries, IdReuseEligibility.ALWAYS, (IdTypeConfigurationProvider)new CommunityIdTypeConfigurationProvider());
        IdGenerator idGenerator = bufferingIdGeneratorFactory.open(new File("doesnt-matter"), 10, IdType.STRING_BLOCK, 0L, Integer.MAX_VALUE);
        idGenerator.freeId(7L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{actual.get(IdType.STRING_BLOCK)});
        bufferingIdGeneratorFactory.maintenance();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{actual.get(IdType.STRING_BLOCK)});
        boundaries.setMostRecentlyReturnedSnapshotToAllClosed();
        bufferingIdGeneratorFactory.maintenance();
        ((IdGenerator)Mockito.verify((Object)actual.get(IdType.STRING_BLOCK))).freeId(7L);
    }

    @Test
    public void shouldDelayFreeingOfAggressivelyReusedIdsConsideringTimeAsWell() throws Exception {
        MockedIdGeneratorFactory actual = new MockedIdGeneratorFactory();
        FakeClock clock = Clocks.fakeClock();
        long safeZone = TimeUnit.MINUTES.toMillis(1L);
        ControllableSnapshotSupplier boundaries = new ControllableSnapshotSupplier();
        BufferingIdGeneratorFactory bufferingIdGeneratorFactory = new BufferingIdGeneratorFactory((IdGeneratorFactory)actual, (Supplier)boundaries, t -> clock.millis() - t.snapshotTime() >= safeZone, (IdTypeConfigurationProvider)new CommunityIdTypeConfigurationProvider());
        IdGenerator idGenerator = bufferingIdGeneratorFactory.open(new File("doesnt-matter"), 10, IdType.STRING_BLOCK, 0L, Integer.MAX_VALUE);
        idGenerator.freeId(7L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{actual.get(IdType.STRING_BLOCK)});
        bufferingIdGeneratorFactory.maintenance();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{actual.get(IdType.STRING_BLOCK)});
        boundaries.setMostRecentlyReturnedSnapshotToAllClosed();
        bufferingIdGeneratorFactory.maintenance();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{actual.get(IdType.STRING_BLOCK)});
        clock.forward(70L, TimeUnit.SECONDS);
        bufferingIdGeneratorFactory.maintenance();
        ((IdGenerator)Mockito.verify((Object)actual.get(IdType.STRING_BLOCK))).freeId(7L);
    }

    private static class MockedIdGeneratorFactory
    implements IdGeneratorFactory {
        private final IdGenerator[] generators = new IdGenerator[IdType.values().length];

        private MockedIdGeneratorFactory() {
        }

        public IdGenerator open(File filename, IdType idType, long highId, long maxId) {
            return this.open(filename, 0, idType, highId, maxId);
        }

        public IdGenerator open(File filename, int grabSize, IdType idType, long highId, long maxId) {
            IdGenerator idGenerator = (IdGenerator)Mockito.mock(IdGenerator.class);
            this.generators[idType.ordinal()] = idGenerator;
            return idGenerator;
        }

        public void create(File filename, long highId, boolean throwIfFileExists) {
        }

        public IdGenerator get(IdType idType) {
            return this.generators[idType.ordinal()];
        }
    }

    private static class ControllableSnapshotSupplier
    implements Supplier<KernelTransactionsSnapshot> {
        KernelTransactionsSnapshot mostRecentlyReturned;

        private ControllableSnapshotSupplier() {
        }

        @Override
        public KernelTransactionsSnapshot get() {
            this.mostRecentlyReturned = (KernelTransactionsSnapshot)Mockito.mock(KernelTransactionsSnapshot.class);
            return this.mostRecentlyReturned;
        }

        void setMostRecentlyReturnedSnapshotToAllClosed() {
            Mockito.when((Object)this.mostRecentlyReturned.allClosed()).thenReturn((Object)true);
        }
    }
}

