/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import org.neo4j.kernel.impl.store.kvstore.HeaderField;
import org.neo4j.kernel.impl.store.kvstore.MetadataCollector;
import org.neo4j.kernel.impl.store.kvstore.ReadableBuffer;
import org.neo4j.kernel.impl.store.kvstore.WritableBuffer;

class StubCollector
extends MetadataCollector {
    StubCollector(int entriesPerPage, String ... header) {
        super(entriesPerPage, StubCollector.headerFields(header));
    }

    boolean verifyFormatSpecifier(ReadableBuffer value) {
        return true;
    }

    static HeaderField<byte[]>[] headerFields(String[] keys) {
        HeaderField[] fields = new HeaderField[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            fields[i] = StubCollector.headerField(keys[i]);
        }
        return fields;
    }

    private static HeaderField<byte[]> headerField(final String key) {
        return new HeaderField<byte[]>(){

            public byte[] read(ReadableBuffer header) {
                return header.get(0, new byte[header.size()]);
            }

            public void write(byte[] bytes, WritableBuffer header) {
                header.put(0, bytes);
            }

            public String toString() {
                return key;
            }
        };
    }
}

