/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacylogs;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.cursor.IOCursor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.storemigration.legacylogs.LegacyLogEntryWriter;
import org.neo4j.kernel.impl.storemigration.legacylogs.LegacyLogFilenames;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.ArrayIOCursor;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.entry.OnePhaseCommit;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class LegacyLogEntryWriterTest {
    @Rule
    public final EphemeralFileSystemRule fileSystemRule = new EphemeralFileSystemRule();
    private final FileSystemAbstraction fs = this.fileSystemRule.get();
    private final NodeRecord nodeRecord = new NodeRecord(42L);
    private final RelationshipRecord relRecord = new RelationshipRecord(42L);

    @Test
    public void shouldWriteTheHeaderInTheFile() throws IOException {
        LegacyLogEntryWriter writer = new LegacyLogEntryWriter(this.fs);
        File output = new File(LegacyLogFilenames.getLegacyLogFilename((int)3));
        LogHeader header = new LogHeader(6, 1L, 42L);
        try (LogVersionedStoreChannel channel = writer.openWritableChannel(output);){
            writer.writeLogHeader(channel, header);
        }
        Assert.assertEquals((Object)header, (Object)LogHeaderReader.readLogHeader((FileSystemAbstraction)this.fs, (File)output));
    }

    @Test
    public void shouldWriteAllTheEntryInACommitToTheFile() throws IOException {
        LogVersionedStoreChannel channel = (LogVersionedStoreChannel)Mockito.mock(LogVersionedStoreChannel.class);
        LogEntryWriter logEntryWriter = (LogEntryWriter)Mockito.mock(LogEntryWriter.class);
        LegacyLogEntryWriter writer = new LegacyLogEntryWriter(this.fs, this.liftToFactory(logEntryWriter));
        LogEntryStart start = new LogEntryStart(0, 1, 2L, 3L, LogEntryStart.EMPTY_ADDITIONAL_ARRAY, LogPosition.UNSPECIFIED);
        LogEntryCommand command = new LogEntryCommand((StorageCommand)new Command.NodeCommand(this.nodeRecord, this.nodeRecord));
        OnePhaseCommit commit = new OnePhaseCommit(42L, 43L);
        IOCursor<LogEntry> cursor = this.mockCursor(new LogEntry[]{start, command, commit});
        writer.writeAllLogEntries(channel, cursor);
        ((LogEntryWriter)Mockito.verify((Object)logEntryWriter, (VerificationMode)Mockito.times((int)1))).writeStartEntry(0, 1, 2L, 3L, LogEntryStart.EMPTY_ADDITIONAL_ARRAY);
        PhysicalTransactionRepresentation expected = new PhysicalTransactionRepresentation(Arrays.asList(command.getXaCommand()));
        ((LogEntryWriter)Mockito.verify((Object)logEntryWriter, (VerificationMode)Mockito.times((int)1))).serialize((TransactionRepresentation)Matchers.eq((Object)expected));
        ((LogEntryWriter)Mockito.verify((Object)logEntryWriter, (VerificationMode)Mockito.times((int)1))).writeCommitEntry(42L, 43L);
    }

    @Test
    public void shouldWriteAllTheEntryInSeveralCommitsToTheFile() throws IOException {
        LogVersionedStoreChannel channel = (LogVersionedStoreChannel)Mockito.mock(LogVersionedStoreChannel.class);
        LogEntryWriter logEntryWriter = (LogEntryWriter)Mockito.mock(LogEntryWriter.class);
        LegacyLogEntryWriter writer = new LegacyLogEntryWriter(this.fs, this.liftToFactory(logEntryWriter));
        LogEntryStart start1 = new LogEntryStart(0, 1, 2L, 3L, LogEntryStart.EMPTY_ADDITIONAL_ARRAY, LogPosition.UNSPECIFIED);
        LogEntryCommand command1 = new LogEntryCommand((StorageCommand)new Command.NodeCommand(this.nodeRecord, this.nodeRecord));
        OnePhaseCommit commit1 = new OnePhaseCommit(42L, 43L);
        LogEntryStart start2 = new LogEntryStart(9, 8, 7L, 6L, LogEntryStart.EMPTY_ADDITIONAL_ARRAY, LogPosition.UNSPECIFIED);
        LogEntryCommand command2 = new LogEntryCommand((StorageCommand)new Command.RelationshipCommand(this.relRecord, this.relRecord));
        OnePhaseCommit commit2 = new OnePhaseCommit(84L, 85L);
        IOCursor<LogEntry> cursor = this.mockCursor(new LogEntry[]{start1, command1, commit1, start2, command2, commit2});
        writer.writeAllLogEntries(channel, cursor);
        ((LogEntryWriter)Mockito.verify((Object)logEntryWriter, (VerificationMode)Mockito.times((int)1))).writeStartEntry(0, 1, 2L, 3L, LogEntryStart.EMPTY_ADDITIONAL_ARRAY);
        PhysicalTransactionRepresentation expected1 = new PhysicalTransactionRepresentation(Arrays.asList(command1.getXaCommand()));
        ((LogEntryWriter)Mockito.verify((Object)logEntryWriter, (VerificationMode)Mockito.times((int)1))).serialize((TransactionRepresentation)Matchers.eq((Object)expected1));
        ((LogEntryWriter)Mockito.verify((Object)logEntryWriter, (VerificationMode)Mockito.times((int)1))).writeCommitEntry(42L, 43L);
        ((LogEntryWriter)Mockito.verify((Object)logEntryWriter, (VerificationMode)Mockito.times((int)1))).writeStartEntry(9, 8, 7L, 6L, LogEntryStart.EMPTY_ADDITIONAL_ARRAY);
        PhysicalTransactionRepresentation expected2 = new PhysicalTransactionRepresentation(Arrays.asList(command2.getXaCommand()));
        ((LogEntryWriter)Mockito.verify((Object)logEntryWriter, (VerificationMode)Mockito.times((int)1))).serialize((TransactionRepresentation)Matchers.eq((Object)expected2));
        ((LogEntryWriter)Mockito.verify((Object)logEntryWriter, (VerificationMode)Mockito.times((int)1))).writeCommitEntry(84L, 85L);
    }

    private Function<FlushableChannel, LogEntryWriter> liftToFactory(LogEntryWriter logEntryWriter) {
        return ignored -> logEntryWriter;
    }

    private IOCursor<LogEntry> mockCursor(LogEntry ... entries) {
        return new ArrayIOCursor<LogEntry>(entries);
    }
}

