/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacylogs;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.cursor.IOCursor;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.storemigration.FileOperation;
import org.neo4j.kernel.impl.storemigration.legacylogs.LegacyLogEntryReader;
import org.neo4j.kernel.impl.storemigration.legacylogs.LegacyLogEntryWriter;
import org.neo4j.kernel.impl.storemigration.legacylogs.LegacyLogFilenames;
import org.neo4j.kernel.impl.storemigration.legacylogs.LegacyLogs;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.ArrayIOCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.MissingLogDataException;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.OnePhaseCommit;
import org.neo4j.storageengine.api.StorageCommand;

public class LegacyLogsTest {
    private static final long NO_NEXT_REL = Record.NO_NEXT_RELATIONSHIP.intValue();
    private static final int NO_LABELS = Record.NO_LABELS_FIELD.intValue();
    private final FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
    private final LegacyLogEntryReader reader = (LegacyLogEntryReader)Mockito.mock(LegacyLogEntryReader.class);
    private final LegacyLogEntryWriter writer = (LegacyLogEntryWriter)Mockito.mock(LegacyLogEntryWriter.class);
    private final File storeDir = LegacyLogsTest.getRootFile("/store");
    private final File migrationDir = LegacyLogsTest.getRootFile("/migration");

    private static File getRootFile(String pathname) {
        try {
            return new File(pathname).getCanonicalFile();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Test
    public void shouldRewriteLogFiles() throws IOException {
        IOCursor cursor = (IOCursor)Mockito.mock(IOCursor.class);
        LogVersionedStoreChannel writeChannel = (LogVersionedStoreChannel)Mockito.mock(LogVersionedStoreChannel.class);
        LogHeader header = new LogHeader(6, 1L, 42L);
        Mockito.when((Object)this.fs.listFiles(this.storeDir, LegacyLogFilenames.versionedLegacyLogFilesFilter)).thenReturn((Object)new File[]{new File(LegacyLogFilenames.getLegacyLogFilename((int)1))});
        Mockito.when((Object)this.reader.openReadableChannel(new File(LegacyLogFilenames.getLegacyLogFilename((int)1)))).thenReturn((Object)Pair.of((Object)header, (Object)cursor));
        Mockito.when((Object)this.writer.openWritableChannel(new File(this.migrationDir, LegacyLogFilenames.getLegacyLogFilename((int)1)))).thenReturn((Object)writeChannel);
        new LegacyLogs(this.fs, this.reader, this.writer).migrateLogs(this.storeDir, this.migrationDir);
        ((LegacyLogEntryWriter)Mockito.verify((Object)this.writer, (VerificationMode)Mockito.times((int)1))).writeLogHeader(writeChannel, header);
        ((LegacyLogEntryWriter)Mockito.verify((Object)this.writer, (VerificationMode)Mockito.times((int)1))).writeAllLogEntries(writeChannel, cursor);
    }

    @Test
    public void shouldMoveFiles() throws Exception {
        try (EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();){
            ByteBuffer buffer2;
            Throwable throwable;
            StoreChannel channel;
            fs.mkdirs(this.storeDir);
            fs.mkdirs(this.migrationDir);
            HashSet<File> logsInStoreDir = new HashSet<File>(Arrays.asList(new File(this.storeDir, LegacyLogFilenames.getLegacyLogFilename((int)1)), new File(this.storeDir, LegacyLogFilenames.getLegacyLogFilename((int)2))));
            List<File> logsInMigrationDir = Arrays.asList(new File(this.migrationDir, LegacyLogFilenames.getLegacyLogFilename((int)1)), new File(this.migrationDir, LegacyLogFilenames.getLegacyLogFilename((int)2)));
            for (File file : logsInMigrationDir) {
                channel = fs.create(file);
                throwable = null;
                try {
                    buffer2 = ByteBuffer.allocate(8);
                    buffer2.putLong(42L);
                    buffer2.flip();
                    channel.write(buffer2);
                }
                catch (Throwable buffer2) {
                    throwable = buffer2;
                    throw buffer2;
                }
                finally {
                    if (channel == null) continue;
                    if (throwable != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable buffer2) {
                            throwable.addSuppressed(buffer2);
                        }
                        continue;
                    }
                    channel.close();
                }
            }
            for (File file : logsInStoreDir) {
                channel = fs.create(file);
                throwable = null;
                try {
                    buffer2 = ByteBuffer.allocate(8);
                    buffer2.putLong(13L);
                    buffer2.flip();
                    channel.write(buffer2);
                }
                catch (Throwable buffer3) {
                    throwable = buffer3;
                    throw buffer3;
                }
                finally {
                    if (channel == null) continue;
                    if (throwable != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable buffer3) {
                            throwable.addSuppressed(buffer3);
                        }
                        continue;
                    }
                    channel.close();
                }
            }
            new LegacyLogs((FileSystemAbstraction)fs, this.reader, this.writer).operate(FileOperation.MOVE, this.migrationDir, this.storeDir);
            Assert.assertEquals(logsInStoreDir, new HashSet<File>(Arrays.asList(fs.listFiles(this.storeDir))));
            for (File file : logsInStoreDir) {
                channel = fs.open(file, "r");
                throwable = null;
                try {
                    buffer2 = ByteBuffer.allocate(8);
                    channel.read(buffer2);
                    buffer2.flip();
                    Assert.assertEquals((long)42L, (long)buffer2.getLong());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (channel == null) continue;
                    if (throwable != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    channel.close();
                }
            }
        }
    }

    @Test
    public void shouldRenameFiles() throws Exception {
        try (EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();){
            fs.mkdirs(this.storeDir);
            File unrelated = new File(this.storeDir, "unrelated");
            List<File> files = Arrays.asList(new File(this.storeDir, "active_tx_log"), new File(this.storeDir, "tm_tx_log.v0"), new File(this.storeDir, "tm_tx_log.v1"), new File(this.storeDir, "nioneo_logical.log.1"), new File(this.storeDir, "nioneo_logical.log.2"), new File(this.storeDir, LegacyLogFilenames.getLegacyLogFilename((int)1)), new File(this.storeDir, LegacyLogFilenames.getLegacyLogFilename((int)2)), unrelated);
            for (File file : files) {
                fs.create(file).close();
            }
            new LegacyLogs((FileSystemAbstraction)fs, this.reader, this.writer).renameLogFiles(this.storeDir);
            HashSet<File> expected = new HashSet<File>(Arrays.asList(unrelated, new File(this.storeDir, this.getLogFilenameForVersion(1)), new File(this.storeDir, this.getLogFilenameForVersion(2))));
            Assert.assertEquals(expected, new HashSet<File>(Arrays.asList(fs.listFiles(this.storeDir))));
        }
    }

    @Test
    public void transactionInformationRetrievedFromCommitEntries() throws IOException {
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        File logFile = new File(LegacyLogFilenames.getLegacyLogFilename((int)1));
        Mockito.when((Object)fs.listFiles((File)Matchers.any(File.class), (FilenameFilter)Matchers.any(FilenameFilter.class))).thenReturn((Object)new File[]{logFile});
        LegacyLogEntryReader reader = (LegacyLogEntryReader)Mockito.mock(LegacyLogEntryReader.class);
        LogEntry[] entries = new LogEntry[]{LegacyLogsTest.start(1), LegacyLogsTest.createNode(1), LegacyLogsTest.createNode(2), LegacyLogsTest.commit(1), LegacyLogsTest.start(2), LegacyLogsTest.createNode(3), LegacyLogsTest.createNode(4), LegacyLogsTest.commit(2), LegacyLogsTest.start(3), LegacyLogsTest.createNode(5), LegacyLogsTest.commit(3)};
        Mockito.when((Object)reader.openReadableChannel((File)Matchers.any(File.class))).thenReturn(this.readableChannel(entries), (Object[])new Pair[]{this.readableChannel(entries), this.readableChannel(entries)});
        LegacyLogEntryWriter writer = new LegacyLogEntryWriter(fs);
        LegacyLogs legacyLogs = new LegacyLogs(fs, reader, writer);
        Assert.assertEquals((Object)LegacyLogsTest.newTransactionId(1), (Object)this.getTransactionInformation(legacyLogs, 1));
        Assert.assertEquals((Object)LegacyLogsTest.newTransactionId(2), (Object)this.getTransactionInformation(legacyLogs, 2));
        Assert.assertEquals((Object)LegacyLogsTest.newTransactionId(3), (Object)this.getTransactionInformation(legacyLogs, 3));
    }

    @Test(expected=IOException.class)
    public void ioExceptionsPropagatedWhenFailToReadLegacyLog() throws IOException {
        File logFile = new File(LegacyLogFilenames.getLegacyLogFilename((int)1));
        Mockito.when((Object)this.fs.listFiles((File)Matchers.any(File.class), (FilenameFilter)Matchers.any(FilenameFilter.class))).thenReturn((Object)new File[]{logFile});
        Mockito.when((Object)this.reader.openReadableChannel((File)Matchers.any(File.class))).thenThrow(new Class[]{IOException.class});
        LegacyLogs legacyLogs = new LegacyLogs(this.fs, this.reader, this.writer);
        this.getTransactionInformation(legacyLogs, 1);
    }

    @Test
    public void noTransactionalInformationWhenLogsNotPresent() throws IOException {
        Mockito.when((Object)this.fs.listFiles((File)Matchers.any(File.class), (FilenameFilter)Matchers.any(FilenameFilter.class))).thenReturn((Object)new File[0]);
        LegacyLogs legacyLogs = new LegacyLogs(this.fs, this.reader, this.writer);
        Assert.assertFalse((String)"There are not logs. Nothing to return", (boolean)legacyLogs.getTransactionInformation(this.storeDir, 1L).isPresent());
    }

    private TransactionId getTransactionInformation(LegacyLogs legacyLogs, int transactionId) throws IOException {
        return (TransactionId)legacyLogs.getTransactionInformation(this.storeDir, (long)transactionId).orElseThrow(MissingLogDataException::new);
    }

    private String getLogFilenameForVersion(int version) {
        return "neostore.transaction.db." + version;
    }

    private static TransactionId newTransactionId(int id) {
        return new TransactionId((long)id, LogEntryStart.checksum((byte[])new byte[]{(byte)id}, (int)id, (int)id), (long)id);
    }

    private static LogEntry start(int id) {
        return new LogEntryStart(id, id, 1L, (long)(id - 1), new byte[]{(byte)id}, new LogPosition(1L, 1L));
    }

    private static LogEntry createNode(int id) {
        NodeRecord before = new NodeRecord((long)id).initialize(false, NO_NEXT_REL, false, NO_NEXT_REL, (long)NO_LABELS);
        NodeRecord after = new NodeRecord((long)id).initialize(true, NO_NEXT_REL, false, NO_NEXT_REL, (long)NO_LABELS);
        Command.NodeCommand command = new Command.NodeCommand(before, after);
        return new LogEntryCommand((StorageCommand)command);
    }

    private static LogEntry commit(int id) {
        return new OnePhaseCommit((long)id, (long)id);
    }

    private Pair<LogHeader, IOCursor<LogEntry>> readableChannel(LogEntry[] entries) {
        ArrayIOCursor<LogEntry> cursor = new ArrayIOCursor<LogEntry>(entries);
        LogHeader logHeader = new LogHeader(1, 1L, 1L);
        return Pair.of((Object)logHeader, cursor);
    }
}

