/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.participant;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexProvider;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_0;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_1;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_2;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_3;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_0;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.monitoring.SilentMigrationProgressMonitor;
import org.neo4j.kernel.impl.storemigration.participant.StoreMigrator;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

@RunWith(value=Parameterized.class)
public class StoreMigratorIT {
    private final TestDirectory directory = TestDirectory.testDirectory();
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.directory).around((TestRule)this.fileSystemRule).around((TestRule)this.pageCacheRule);
    private final SchemaIndexProvider schemaIndexProvider = new InMemoryIndexProvider();
    private final FileSystemAbstraction fs = this.fileSystemRule.get();
    @Parameterized.Parameter(value=0)
    public String version;
    @Parameterized.Parameter(value=1)
    public LogPosition expectedLogPosition;
    @Parameterized.Parameter(value=2)
    public Function<TransactionId, Boolean> txIdComparator;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> versions() {
        return Arrays.asList({StandardV2_0.STORE_VERSION, new LogPosition(0L, 16L), StoreMigratorIT.txInfoAcceptanceOnIdAndTimestamp(1039L, 1L)}, {StandardV2_1.STORE_VERSION, new LogPosition(0L, 16L), StoreMigratorIT.txInfoAcceptanceOnIdAndTimestamp(38L, 1L)}, {StandardV2_2.STORE_VERSION, new LogPosition(2L, 16L), StoreMigratorIT.txInfoAcceptanceOnIdAndTimestamp(38L, 1L)}, {StandardV2_3.STORE_VERSION, new LogPosition(3L, 169L), StoreMigratorIT.txInfoAcceptanceOnIdAndTimestamp(39L, 1L)});
    }

    private static Function<TransactionId, Boolean> txInfoAcceptanceOnIdAndTimestamp(long id, long timestamp) {
        return txInfo -> txInfo.transactionId() == id && txInfo.commitTimestamp() == timestamp;
    }

    @Test
    public void shouldBeAbleToResumeMigrationOnMoving() throws Exception {
        File storeDirectory = this.directory.graphDbDir();
        File prepare = this.directory.directory("prepare");
        MigrationTestUtils.prepareSampleLegacyDatabase(this.version, this.fs, storeDirectory, prepare);
        NullLogService logService = NullLogService.getInstance();
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fs);
        UpgradableDatabase upgradableDatabase = new UpgradableDatabase(this.fs, new StoreVersionCheck(pageCache), new LegacyStoreVersionCheck(this.fs), this.selectFormat());
        String versionToMigrateFrom = upgradableDatabase.checkUpgradeable(storeDirectory).storeVersion();
        SilentMigrationProgressMonitor progressMonitor = new SilentMigrationProgressMonitor();
        StoreMigrator migrator = new StoreMigrator(this.fs, pageCache, Config.empty(), (LogService)logService, this.schemaIndexProvider);
        File migrationDir = new File(storeDirectory, "upgrade");
        this.fs.mkdirs(migrationDir);
        migrator.migrate(storeDirectory, migrationDir, progressMonitor.startSection("section"), versionToMigrateFrom, upgradableDatabase.currentVersion());
        progressMonitor = new SilentMigrationProgressMonitor();
        migrator = new StoreMigrator(this.fs, pageCache, Config.empty(), (LogService)logService, this.schemaIndexProvider);
        migrator.moveMigratedFiles(migrationDir, storeDirectory, versionToMigrateFrom, upgradableDatabase.currentVersion());
        StoreFactory storeFactory = new StoreFactory(storeDirectory, pageCache, this.fs, logService.getInternalLogProvider());
        storeFactory.openAllNeoStores().close();
    }

    @Test
    public void shouldBeAbleToResumeMigrationOnRebuildingCounts() throws Exception {
        File storeDirectory = this.directory.graphDbDir();
        File prepare = this.directory.directory("prepare");
        MigrationTestUtils.prepareSampleLegacyDatabase(this.version, this.fs, storeDirectory, prepare);
        NullLogService logService = NullLogService.getInstance();
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fs);
        UpgradableDatabase upgradableDatabase = new UpgradableDatabase(this.fs, new StoreVersionCheck(pageCache), new LegacyStoreVersionCheck(this.fs), this.selectFormat());
        String versionToMigrateFrom = upgradableDatabase.checkUpgradeable(storeDirectory).storeVersion();
        SilentMigrationProgressMonitor progressMonitor = new SilentMigrationProgressMonitor();
        StoreMigrator migrator = new StoreMigrator(this.fs, pageCache, Config.empty(), (LogService)logService, this.schemaIndexProvider);
        File migrationDir = new File(storeDirectory, "upgrade");
        this.fs.mkdirs(migrationDir);
        migrator.migrate(storeDirectory, migrationDir, progressMonitor.startSection("section"), versionToMigrateFrom, upgradableDatabase.currentVersion());
        migrator.moveMigratedFiles(migrationDir, storeDirectory, versionToMigrateFrom, upgradableDatabase.currentVersion());
        progressMonitor = new SilentMigrationProgressMonitor();
        migrator = new StoreMigrator(this.fs, pageCache, Config.empty(), (LogService)logService, this.schemaIndexProvider);
        migrator.rebuildCounts(storeDirectory, versionToMigrateFrom, upgradableDatabase.currentVersion());
        StoreFactory storeFactory = new StoreFactory(storeDirectory, pageCache, this.fs, logService.getInternalLogProvider());
        storeFactory.openAllNeoStores().close();
    }

    @Test
    public void shouldComputeTheLastTxLogPositionCorrectly() throws Throwable {
        File storeDirectory = this.directory.graphDbDir();
        File prepare = this.directory.directory("prepare");
        MigrationTestUtils.prepareSampleLegacyDatabase(this.version, this.fs, storeDirectory, prepare);
        NullLogService logService = NullLogService.getInstance();
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fs);
        UpgradableDatabase upgradableDatabase = new UpgradableDatabase(this.fs, new StoreVersionCheck(pageCache), new LegacyStoreVersionCheck(this.fs), this.selectFormat());
        String versionToMigrateFrom = upgradableDatabase.checkUpgradeable(storeDirectory).storeVersion();
        SilentMigrationProgressMonitor progressMonitor = new SilentMigrationProgressMonitor();
        StoreMigrator migrator = new StoreMigrator(this.fs, pageCache, Config.empty(), (LogService)logService, this.schemaIndexProvider);
        File migrationDir = new File(storeDirectory, "upgrade");
        this.fs.mkdirs(migrationDir);
        migrator.migrate(storeDirectory, migrationDir, progressMonitor.startSection("section"), versionToMigrateFrom, upgradableDatabase.currentVersion());
        Assert.assertEquals((Object)this.expectedLogPosition, (Object)migrator.readLastTxLogPosition(migrationDir));
    }

    @Test
    public void shouldComputeTheLastTxInfoCorrectly() throws Exception {
        File storeDirectory = this.directory.graphDbDir();
        File prepare = this.directory.directory("prepare");
        MigrationTestUtils.prepareSampleLegacyDatabase(this.version, this.fs, storeDirectory, prepare);
        NullLogService logService = NullLogService.getInstance();
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fs);
        UpgradableDatabase upgradableDatabase = new UpgradableDatabase(this.fs, new StoreVersionCheck(pageCache), new LegacyStoreVersionCheck(this.fs), this.selectFormat());
        String versionToMigrateFrom = upgradableDatabase.checkUpgradeable(storeDirectory).storeVersion();
        SilentMigrationProgressMonitor progressMonitor = new SilentMigrationProgressMonitor();
        StoreMigrator migrator = new StoreMigrator(this.fs, pageCache, Config.empty(), (LogService)logService, this.schemaIndexProvider);
        File migrationDir = new File(storeDirectory, "upgrade");
        this.fs.mkdir(migrationDir);
        migrator.migrate(storeDirectory, migrationDir, progressMonitor.startSection("section"), versionToMigrateFrom, upgradableDatabase.currentVersion());
        Assert.assertTrue((boolean)this.txIdComparator.apply(migrator.readLastTxInformation(migrationDir)));
    }

    private RecordFormats selectFormat() {
        return StandardV3_0.RECORD_FORMATS;
    }
}

