/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.participant;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.Mockito;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexProvider;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.logging.SimpleLogService;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.storemigration.legacylogs.LegacyLogs;
import org.neo4j.kernel.impl.storemigration.participant.StoreMigrator;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class StoreMigratorTest {
    private final TestDirectory directory = TestDirectory.testDirectory();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    private final RandomRule random = new RandomRule();
    private final SchemaIndexProvider schemaIndexProvider = new InMemoryIndexProvider();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.directory).around((TestRule)this.fileSystemRule).around((TestRule)this.pageCacheRule).around((TestRule)this.random);

    @Test
    public void shouldExtractTransactionInformationFromMetaDataStore() throws Exception {
        long txId = 42L;
        long checksum = 123456789123456789L;
        long timestamp = 919191919191919191L;
        TransactionId expected = new TransactionId(txId, checksum, timestamp);
        PageCache pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fileSystemRule.get());
        File storeDir = this.directory.graphDbDir();
        File neoStore = new File(storeDir, "neostore");
        neoStore.createNewFile();
        Config config = (Config)Mockito.mock(Config.class);
        LogService logService = (LogService)Mockito.mock(LogService.class);
        MetaDataStore.setRecord((PageCache)pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_ID, (long)txId);
        MetaDataStore.setRecord((PageCache)pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_CHECKSUM, (long)checksum);
        MetaDataStore.setRecord((PageCache)pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_COMMIT_TIMESTAMP, (long)timestamp);
        StoreMigrator migrator = new StoreMigrator((FileSystemAbstraction)this.fileSystemRule.get(), pageCache, config, logService, SchemaIndexProvider.NO_INDEX_PROVIDER);
        TransactionId actual = migrator.extractTransactionIdInformation(neoStore, storeDir, txId);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldExtractTransactionInformationFromLegacyLogsWhenCantFindInStore() throws Exception {
        long txId = 42L;
        long checksum = 123456789123456789L;
        long timestamp = 919191919191919191L;
        TransactionId expected = new TransactionId(txId, checksum, timestamp);
        PageCache pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fileSystemRule.get());
        File storeDir = this.directory.graphDbDir();
        File neoStore = new File(storeDir, "neostore");
        neoStore.createNewFile();
        Config config = (Config)Mockito.mock(Config.class);
        LogService logService = (LogService)Mockito.mock(LogService.class);
        LegacyLogs legacyLogs = (LegacyLogs)Mockito.mock(LegacyLogs.class);
        Mockito.when((Object)legacyLogs.getTransactionInformation(storeDir, txId)).thenReturn(Optional.of(expected));
        StoreMigrator migrator = new StoreMigrator((FileSystemAbstraction)this.fileSystemRule.get(), pageCache, config, logService, this.schemaIndexProvider, legacyLogs);
        TransactionId actual = migrator.extractTransactionIdInformation(neoStore, storeDir, txId);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldGenerateTransactionInformationWhenLogsNotPresent() throws Exception {
        long txId = 42L;
        PageCache pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fileSystemRule.get());
        File storeDir = this.directory.graphDbDir();
        File neoStore = new File(storeDir, "neostore");
        neoStore.createNewFile();
        Config config = (Config)Mockito.mock(Config.class);
        SimpleLogService logService = new SimpleLogService((LogProvider)NullLogProvider.getInstance(), (LogProvider)NullLogProvider.getInstance());
        LegacyLogs legacyLogs = (LegacyLogs)Mockito.mock(LegacyLogs.class);
        Assert.assertEquals((long)-1L, (long)MetaDataStore.getRecord((PageCache)pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_ID));
        Assert.assertEquals((long)-1L, (long)MetaDataStore.getRecord((PageCache)pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_CHECKSUM));
        Assert.assertEquals((long)-1L, (long)MetaDataStore.getRecord((PageCache)pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_COMMIT_TIMESTAMP));
        Mockito.when((Object)legacyLogs.getTransactionInformation(storeDir, txId)).thenReturn(Optional.empty());
        StoreMigrator migrator = new StoreMigrator((FileSystemAbstraction)this.fileSystemRule.get(), pageCache, config, (LogService)logService, this.schemaIndexProvider);
        TransactionId actual = migrator.extractTransactionIdInformation(neoStore, storeDir, txId);
        Assert.assertEquals((long)txId, (long)actual.transactionId());
        Assert.assertEquals((long)1L, (long)actual.checksum());
        Assert.assertEquals((long)1L, (long)actual.commitTimestamp());
    }

    @Test
    public void shouldGenerateTransactionInformationWhenLogsAreEmpty() throws Exception {
        long txId = 1L;
        PageCache pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fileSystemRule.get());
        File storeDir = this.directory.graphDbDir();
        File neoStore = new File(storeDir, "neostore");
        neoStore.createNewFile();
        Config config = (Config)Mockito.mock(Config.class);
        SimpleLogService logService = new SimpleLogService((LogProvider)NullLogProvider.getInstance(), (LogProvider)NullLogProvider.getInstance());
        LegacyLogs legacyLogs = (LegacyLogs)Mockito.mock(LegacyLogs.class);
        Assert.assertEquals((long)-1L, (long)MetaDataStore.getRecord((PageCache)pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_ID));
        Assert.assertEquals((long)-1L, (long)MetaDataStore.getRecord((PageCache)pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_CHECKSUM));
        Assert.assertEquals((long)-1L, (long)MetaDataStore.getRecord((PageCache)pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_COMMIT_TIMESTAMP));
        Mockito.when((Object)legacyLogs.getTransactionInformation(storeDir, txId)).thenReturn(Optional.empty());
        StoreMigrator migrator = new StoreMigrator((FileSystemAbstraction)this.fileSystemRule.get(), pageCache, config, (LogService)logService, this.schemaIndexProvider);
        TransactionId actual = migrator.extractTransactionIdInformation(neoStore, storeDir, txId);
        Assert.assertEquals((long)txId, (long)actual.transactionId());
        Assert.assertEquals((long)0L, (long)actual.checksum());
        Assert.assertEquals((long)0L, (long)actual.commitTimestamp());
    }

    @Test
    public void writeAndReadLastTxInformation() throws IOException {
        StoreMigrator migrator = this.newStoreMigrator();
        TransactionId writtenTxId = new TransactionId(this.random.nextLong(), this.random.nextLong(), this.random.nextLong());
        migrator.writeLastTxInformation(this.directory.graphDbDir(), writtenTxId);
        TransactionId readTxId = migrator.readLastTxInformation(this.directory.graphDbDir());
        Assert.assertEquals((Object)writtenTxId, (Object)readTxId);
    }

    @Test
    public void writeAndReadLastTxLogPosition() throws IOException {
        StoreMigrator migrator = this.newStoreMigrator();
        LogPosition writtenLogPosition = new LogPosition(this.random.nextLong(), this.random.nextLong());
        migrator.writeLastTxLogPosition(this.directory.graphDbDir(), writtenLogPosition);
        LogPosition readLogPosition = migrator.readLastTxLogPosition(this.directory.graphDbDir());
        Assert.assertEquals((Object)writtenLogPosition, (Object)readLogPosition);
    }

    private StoreMigrator newStoreMigrator() {
        return new StoreMigrator((FileSystemAbstraction)this.fileSystemRule.get(), this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fileSystemRule.get()), Config.empty(), (LogService)NullLogService.getInstance(), this.schemaIndexProvider);
    }
}

