/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactoryState;
import org.neo4j.kernel.impl.api.index.RemoveOrphanConstraintIndexesOnStartup;
import org.neo4j.kernel.impl.factory.CommunityEditionModule;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.transaction.TransactionStats;
import org.neo4j.test.rule.TestDirectory;

public class CommitContentionTests {
    @Rule
    public final TestDirectory storeLocation = TestDirectory.testDirectory();
    final Semaphore semaphore1 = new Semaphore(1);
    final Semaphore semaphore2 = new Semaphore(1);
    final AtomicReference<Exception> reference = new AtomicReference();
    private GraphDatabaseService db;

    @Before
    public void before() throws Exception {
        this.semaphore1.acquire();
        this.semaphore2.acquire();
        this.db = this.createDb();
    }

    @After
    public void after() throws Exception {
        this.db.shutdown();
    }

    @Test
    public void shouldNotContendOnCommitWhenPushingUpdates() throws Exception {
        Thread thread = this.startFirstTransactionWhichBlocksDuringPushUntilSecondTransactionFinishes();
        this.runAndFinishSecondTransaction();
        thread.join();
        this.assertNoFailures();
    }

    private void assertNoFailures() {
        Exception e = this.reference.get();
        if (e != null) {
            throw new AssertionError((Object)e);
        }
    }

    private void runAndFinishSecondTransaction() {
        this.createNode();
        this.signalSecondTransactionFinished();
    }

    private void createNode() {
        try (Transaction transaction = this.db.beginTx();){
            this.db.createNode();
            transaction.success();
        }
    }

    private Thread startFirstTransactionWhichBlocksDuringPushUntilSecondTransactionFinishes() throws InterruptedException {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                CommitContentionTests.this.createNode();
            }
        });
        thread.start();
        this.waitForFirstTransactionToStartPushing();
        return thread;
    }

    private GraphDatabaseService createDb() {
        GraphDatabaseFactoryState state = new GraphDatabaseFactoryState();
        return new GraphDatabaseFacadeFactory(DatabaseInfo.COMMUNITY, CommunityEditionModule::new){

            protected PlatformModule createPlatform(File storeDir, Map<String, String> params, GraphDatabaseFacadeFactory.Dependencies dependencies, GraphDatabaseFacade graphDatabaseFacade) {
                return new PlatformModule(storeDir, params, this.databaseInfo, dependencies, graphDatabaseFacade){

                    protected TransactionStats createTransactionStats() {
                        return new TransactionStats(){
                            public boolean skip;

                            public void transactionFinished(boolean committed, boolean write) {
                                super.transactionFinished(committed, write);
                                if (this.isTheRemoveOrphanedConstraintIndexesOnStartupTransaction()) {
                                    return;
                                }
                                if (committed) {
                                    if (this.skip) {
                                        return;
                                    }
                                    this.skip = true;
                                    CommitContentionTests.this.signalFirstTransactionStartedPushing();
                                    CommitContentionTests.this.waitForSecondTransactionToFinish();
                                }
                            }

                            private boolean isTheRemoveOrphanedConstraintIndexesOnStartupTransaction() {
                                for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
                                    if (!element.getClassName().contains(RemoveOrphanConstraintIndexesOnStartup.class.getSimpleName())) continue;
                                    return true;
                                }
                                return false;
                            }
                        };
                    }
                };
            }
        }.newFacade(this.storeLocation.graphDbDir(), Collections.emptyMap(), state.databaseDependencies());
    }

    private void waitForFirstTransactionToStartPushing() throws InterruptedException {
        if (!this.semaphore1.tryAcquire(10L, TimeUnit.SECONDS)) {
            throw new IllegalStateException("First transaction never started pushing");
        }
    }

    private void signalFirstTransactionStartedPushing() {
        this.semaphore1.release();
    }

    private void signalSecondTransactionFinished() {
        this.semaphore2.release();
    }

    private void waitForSecondTransactionToFinish() {
        try {
            boolean acquired = this.semaphore2.tryAcquire(10L, TimeUnit.SECONDS);
            if (!acquired) {
                this.reference.set(new IllegalStateException("Second transaction never finished"));
            }
        }
        catch (InterruptedException e) {
            this.reference.set(e);
        }
    }
}

