/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.api.BatchTransactionApplier;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.storageengine.api.CommandsToApply;

public class CommandHandlerContract {
    public static void apply(BatchTransactionApplier applier, TransactionToApply ... transactions) throws Exception {
        for (TransactionToApply tx : transactions) {
            try (TransactionApplier txApplier = applier.startTx((CommandsToApply)tx, new LockGroup());){
                tx.transactionRepresentation().accept((Visitor)txApplier);
            }
        }
        applier.close();
    }

    public static boolean apply(BatchTransactionApplier applier, ApplyFunction function, TransactionToApply ... transactions) throws Exception {
        boolean result = true;
        for (TransactionToApply tx : transactions) {
            try (TransactionApplier txApplier = applier.startTx((CommandsToApply)tx, new LockGroup());){
                result &= function.apply(txApplier);
            }
        }
        applier.close();
        return result;
    }

    @FunctionalInterface
    public static interface ApplyFunction {
        public boolean apply(TransactionApplier var1) throws Exception;
    }
}

