/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadChannel;
import org.neo4j.storageengine.api.ReadPastEndException;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class ReadAheadChannelTest {
    @Rule
    public final EphemeralFileSystemRule fileSystemRule = new EphemeralFileSystemRule();

    @Test
    public void shouldThrowExceptionForReadAfterEOFIfNotEnoughBytesExist() throws Exception {
        EphemeralFileSystemAbstraction fileSystem = this.fileSystemRule.get();
        StoreChannel storeChannel = fileSystem.open(new File("foo.txt"), "rw");
        ByteBuffer buffer = ByteBuffer.allocate(1);
        buffer.put((byte)1);
        buffer.flip();
        storeChannel.writeAll(buffer);
        storeChannel.force(false);
        storeChannel.close();
        storeChannel = fileSystem.open(new File("foo.txt"), "r");
        ReadAheadChannel channel = new ReadAheadChannel(storeChannel);
        Assert.assertEquals((long)1L, (long)channel.get());
        try {
            channel.get();
            Assert.fail((String)"Should have thrown exception signalling end of file reached");
        }
        catch (ReadPastEndException readPastEndException) {
            // empty catch block
        }
        try {
            channel.get();
            Assert.fail((String)"Should have thrown exception signalling end of file reached");
        }
        catch (ReadPastEndException readPastEndException) {
            // empty catch block
        }
    }

    @Test
    public void shouldReturnValueIfSufficientBytesAreBufferedEvenIfEOFHasBeenEncountered() throws Exception {
        EphemeralFileSystemAbstraction fileSystem = this.fileSystemRule.get();
        StoreChannel storeChannel = fileSystem.open(new File("foo.txt"), "rw");
        ByteBuffer buffer = ByteBuffer.allocate(1);
        buffer.put((byte)1);
        buffer.flip();
        storeChannel.writeAll(buffer);
        storeChannel.force(false);
        storeChannel.close();
        storeChannel = fileSystem.open(new File("foo.txt"), "r");
        ReadAheadChannel channel = new ReadAheadChannel(storeChannel);
        try {
            channel.getShort();
            Assert.fail((String)"Should have thrown exception signalling end of file reached");
        }
        catch (ReadPastEndException readPastEndException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)channel.get());
        try {
            channel.get();
            Assert.fail((String)"Should have thrown exception signalling end of file reached");
        }
        catch (ReadPastEndException readPastEndException) {
            // empty catch block
        }
    }

    @Test
    public void shouldHandleRunningOutOfBytesWhenRequestSpansMultipleFiles() throws Exception {
        EphemeralFileSystemAbstraction fileSystem = this.fileSystemRule.get();
        StoreChannel storeChannel1 = fileSystem.open(new File("foo.1"), "rw");
        ByteBuffer buffer = ByteBuffer.allocate(2);
        buffer.put((byte)0);
        buffer.put((byte)0);
        buffer.flip();
        storeChannel1.writeAll(buffer);
        storeChannel1.force(false);
        storeChannel1.close();
        buffer.flip();
        StoreChannel storeChannel2 = fileSystem.open(new File("foo.2"), "r");
        buffer.put((byte)0);
        buffer.put((byte)1);
        buffer.flip();
        storeChannel2.writeAll(buffer);
        storeChannel2.force(false);
        storeChannel2.close();
        storeChannel1 = fileSystem.open(new File("foo.1"), "r");
        final StoreChannel storeChannel2Copy = fileSystem.open(new File("foo.2"), "r");
        ReadAheadChannel<StoreChannel> channel = new ReadAheadChannel<StoreChannel>(storeChannel1){

            protected StoreChannel next(StoreChannel channel) throws IOException {
                return storeChannel2Copy;
            }
        };
        try {
            channel.getLong();
            Assert.fail((String)"Should have thrown exception signalling end of file reached");
        }
        catch (ReadPastEndException readPastEndException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)channel.getInt());
        try {
            channel.get();
            Assert.fail((String)"Should have thrown exception signalling end of file reached");
        }
        catch (ReadPastEndException readPastEndException) {
            // empty catch block
        }
    }

    @Test
    public void shouldReturnPositionWithinBufferedStream() throws Exception {
        EphemeralFileSystemAbstraction fsa = this.fileSystemRule.get();
        File file = new File("foo.txt");
        int readAheadSize = 512;
        int fileSize = readAheadSize * 8;
        this.createFile(fsa, file, fileSize);
        ReadAheadChannel bufferedReader = new ReadAheadChannel(fsa.open(file, "r"), readAheadSize);
        for (int i = 0; i < fileSize / 8; ++i) {
            Assert.assertEquals((long)(8 * i), (long)bufferedReader.position());
            bufferedReader.getLong();
        }
        Assert.assertEquals((long)fileSize, (long)bufferedReader.position());
        try {
            bufferedReader.getLong();
            Assert.fail();
        }
        catch (ReadPastEndException readPastEndException) {
            // empty catch block
        }
        Assert.assertEquals((long)fileSize, (long)bufferedReader.position());
    }

    private void createFile(EphemeralFileSystemAbstraction fsa, File name, int bufferSize) throws IOException {
        StoreChannel storeChannel = fsa.open(name, "w");
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        for (int i = 0; i < bufferSize; ++i) {
            buffer.put((byte)i);
        }
        buffer.flip();
        storeChannel.writeAll(buffer);
        storeChannel.close();
    }
}

