/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.Mockito;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.core.DatabasePanicEventGenerator;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.transaction.DeadSimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.DeadSimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Commands;
import org.neo4j.kernel.impl.transaction.log.BatchingTransactionAppender;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.LogHeaderCache;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotationImpl;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.test.Race;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class TransactionLogAppendAndRotateIT {
    private final LifeRule life = new LifeRule(true);
    private final TestDirectory directory = TestDirectory.testDirectory();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public final RuleChain chain = RuleChain.outerRule((TestRule)this.directory).around((TestRule)this.life).around((TestRule)this.fileSystemRule);

    @Test
    public void shouldKeepTransactionsIntactWhenConcurrentlyRotationAndAppending() throws Throwable {
        PhysicalLogFiles logFiles = new PhysicalLogFiles(this.directory.directory().getAbsoluteFile(), (FileSystemAbstraction)this.fileSystemRule.get());
        long rotationThreshold = ByteUnit.mebiBytes((long)1L);
        DeadSimpleLogVersionRepository logVersionRepository = new DeadSimpleLogVersionRepository(0L);
        final AtomicBoolean end = new AtomicBoolean();
        AllTheMonitoring monitoring = new AllTheMonitoring(end, 100);
        DeadSimpleTransactionIdStore txIdStore = new DeadSimpleTransactionIdStore();
        TransactionMetadataCache metadataCache = new TransactionMetadataCache(100);
        LogHeaderCache logHeaderCache = new LogHeaderCache(10);
        LogFile logFile = (LogFile)this.life.add((Lifecycle)new PhysicalLogFile((FileSystemAbstraction)this.fileSystemRule.get(), logFiles, rotationThreshold, () -> txIdStore.getLastCommittedTransactionId(), (LogVersionRepository)logVersionRepository, (PhysicalLogFile.Monitor)monitoring, logHeaderCache));
        monitoring.setLogFile(logFile);
        DatabaseHealth health = new DatabaseHealth((DatabasePanicEventGenerator)Mockito.mock(DatabasePanicEventGenerator.class), (Log)NullLog.getInstance());
        LogRotationImpl rotation = new LogRotationImpl((LogRotation.Monitor)monitoring, logFile, health);
        final TransactionAppender appender = (TransactionAppender)this.life.add((Lifecycle)new BatchingTransactionAppender(logFile, (LogRotation)rotation, metadataCache, (TransactionIdStore)txIdStore, IdOrderingQueue.BYPASS, health));
        Race race = new Race();
        for (int i = 0; i < 10; ++i) {
            race.addContestant(new Runnable(){

                @Override
                public void run() {
                    while (!end.get()) {
                        try {
                            appender.append(new TransactionToApply(TransactionLogAppendAndRotateIT.this.sillyTransaction(1000)), LogAppendEvent.NULL);
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.out);
                            end.set(true);
                            Assert.fail((String)e.getMessage());
                        }
                    }
                }
            });
        }
        race.addContestant(this.endAfterMax(10, TimeUnit.SECONDS, end));
        race.go();
        Assert.assertTrue((monitoring.numberOfRotations() > 0 ? 1 : 0) != 0);
    }

    private Runnable endAfterMax(final int time, final TimeUnit unit, final AtomicBoolean end) {
        return new Runnable(){

            @Override
            public void run() {
                long endTime = System.currentTimeMillis() + unit.toMillis(time);
                while (System.currentTimeMillis() < endTime && !end.get()) {
                    LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(50L));
                }
                end.set(true);
            }
        };
    }

    private static void assertWholeTransactionsIn(LogFile logFile, long logVersion) throws IOException {
        try (ReadableLogChannel reader = logFile.getReader(new LogPosition(logVersion, 16L));){
            VersionAwareLogEntryReader entryReader = new VersionAwareLogEntryReader();
            LogEntry entry = null;
            boolean inTx = false;
            int transactions = 0;
            while ((entry = entryReader.readLogEntry((ReadableClosablePositionAwareChannel)reader)) != null) {
                if (!inTx) {
                    Assert.assertTrue((boolean)(entry instanceof LogEntryStart));
                    inTx = true;
                    continue;
                }
                Assert.assertTrue((entry instanceof LogEntryCommand || entry instanceof LogEntryCommit ? 1 : 0) != 0);
                if (!(entry instanceof LogEntryCommit)) continue;
                inTx = false;
                ++transactions;
            }
            Assert.assertFalse((boolean)inTx);
            Assert.assertTrue((transactions > 0 ? 1 : 0) != 0);
        }
    }

    private TransactionRepresentation sillyTransaction(int size) {
        ArrayList<Object> commands = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            commands.add(Commands.createNode(i, new long[0]));
            commands.add(Commands.createProperty(i, PropertyType.INT, 0, new long[0]));
        }
        PhysicalTransactionRepresentation tx = new PhysicalTransactionRepresentation(commands);
        tx.setHeader(new byte[0], 0, 0, 0L, 0L, 0L, 0);
        return tx;
    }

    private static class AllTheMonitoring
    implements PhysicalLogFile.Monitor,
    LogRotation.Monitor {
        private final AtomicBoolean end;
        private final int maxNumberOfRotations;
        private volatile LogFile logFile;
        private volatile int rotations;

        public AllTheMonitoring(AtomicBoolean end, int maxNumberOfRotations) {
            this.end = end;
            this.maxNumberOfRotations = maxNumberOfRotations;
        }

        void setLogFile(LogFile logFile) {
            this.logFile = logFile;
        }

        public void startedRotating(long currentVersion) {
        }

        public void finishedRotating(long currentVersion) {
            try {
                TransactionLogAppendAndRotateIT.assertWholeTransactionsIn(this.logFile, currentVersion);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (this.rotations++ > this.maxNumberOfRotations) {
                    this.end.set(true);
                }
            }
        }

        int numberOfRotations() {
            return this.rotations;
        }

        public void opened(File logFile, long logVersion, long lastTransactionId, boolean clean) {
        }
    }
}

