/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.mockfs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.entry.CheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class CheckPointerIntegrationTest {
    private static final File storeDir = new File(System.getProperty("java.io.tmpdir"), "graph.db");
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private GraphDatabaseBuilder builder;
    private FileSystemAbstraction fs;

    @Before
    public void setup() throws IOException {
        this.fs = this.fsRule.get();
        this.fs.deleteRecursively(storeDir);
        this.builder = new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction(this.fs)).newImpermanentDatabaseBuilder(storeDir);
    }

    @Test
    public void databaseShutdownDuringConstantCheckPointing() throws InterruptedException, IOException {
        GraphDatabaseService db = this.builder.setConfig(GraphDatabaseSettings.check_point_interval_time, "0ms").setConfig(GraphDatabaseSettings.check_point_interval_tx, "1").setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, "1g").newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        Thread.sleep(10L);
        db.shutdown();
    }

    @Test
    public void shouldCheckPointBasedOnTime() throws Throwable {
        long millis = 200L;
        GraphDatabaseService db = this.builder.setConfig(GraphDatabaseSettings.check_point_interval_time, millis + "ms").setConfig(GraphDatabaseSettings.check_point_interval_tx, "10000").setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, "1g").newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L);
        while (!this.checkPointInTxLog(db)) {
            Thread.sleep(millis);
            Assert.assertTrue((String)"Took too long to produce a checkpoint", (System.currentTimeMillis() < endTime ? 1 : 0) != 0);
        }
        db.shutdown();
        List<CheckPoint> checkPoints = new CheckPointCollector(storeDir, this.fs).find(0L);
        Assert.assertTrue((String)("Expected at least two (at least one for time interval and one for shutdown), was " + checkPoints.toString()), (checkPoints.size() >= 2 ? 1 : 0) != 0);
    }

    private boolean checkPointInTxLog(GraphDatabaseService db) throws IOException {
        LogFile logFile = (LogFile)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(LogFile.class);
        try (ReadableLogChannel reader = logFile.getReader(new LogPosition(0L, 16L));){
            VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader();
            LogEntry entry = null;
            while ((entry = logEntryReader.readLogEntry((ReadableClosablePositionAwareChannel)reader)) != null) {
                if (!(entry instanceof CheckPoint)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Test
    public void shouldCheckPointBasedOnTxCount() throws Throwable {
        GraphDatabaseService db = this.builder.setConfig(GraphDatabaseSettings.check_point_interval_time, "300m").setConfig(GraphDatabaseSettings.check_point_interval_tx, "1").setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, "1g").newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        this.triggerCheckPointAttempt(db);
        Assert.assertTrue((boolean)this.checkPointInTxLog(db));
        db.shutdown();
        List<CheckPoint> checkPoints = new CheckPointCollector(storeDir, this.fs).find(0L);
        Assert.assertEquals((long)2L, (long)checkPoints.size());
    }

    @Test
    public void shouldNotCheckPointWhenThereAreNoCommits() throws Throwable {
        GraphDatabaseService db = this.builder.setConfig(GraphDatabaseSettings.check_point_interval_time, "1s").setConfig(GraphDatabaseSettings.check_point_interval_tx, "10000").setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, "1g").newGraphDatabase();
        this.triggerCheckPointAttempt(db);
        Assert.assertFalse((boolean)this.checkPointInTxLog(db));
        db.shutdown();
        List<CheckPoint> checkPoints = new CheckPointCollector(storeDir, this.fs).find(0L);
        Assert.assertEquals((long)1L, (long)checkPoints.size());
    }

    @Test
    public void shouldBeAbleToStartAndShutdownMultipleTimesTheDBWithoutCommittingTransactions() throws Throwable {
        GraphDatabaseBuilder graphDatabaseBuilder = this.builder.setConfig(GraphDatabaseSettings.check_point_interval_time, "300m").setConfig(GraphDatabaseSettings.check_point_interval_tx, "10000").setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, "1g");
        graphDatabaseBuilder.newGraphDatabase().shutdown();
        graphDatabaseBuilder.newGraphDatabase().shutdown();
        List<CheckPoint> checkPoints = new CheckPointCollector(storeDir, this.fs).find(0L);
        Assert.assertEquals((long)2L, (long)checkPoints.size());
    }

    private void triggerCheckPointAttempt(GraphDatabaseService db) throws Exception {
        ((CheckPointer)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(CheckPointer.class)).checkPointIfNeeded((TriggerInfo)new SimpleTriggerInfo("Test"));
    }

    private static class CheckPointCollector {
        private final PhysicalLogFiles logFiles;
        private final FileSystemAbstraction fileSystem;
        private final LogEntryReader<ReadableClosablePositionAwareChannel> logEntryReader;

        public CheckPointCollector(File directory, FileSystemAbstraction fileSystem) {
            this.fileSystem = fileSystem;
            this.logFiles = new PhysicalLogFiles(directory, fileSystem);
            this.logEntryReader = new VersionAwareLogEntryReader();
        }

        public List<CheckPoint> find(long version) throws IOException {
            PhysicalLogVersionedStoreChannel channel;
            ArrayList<CheckPoint> checkPoints = new ArrayList<CheckPoint>();
            while (version >= 0L && (channel = PhysicalLogFile.tryOpenForVersion((PhysicalLogFiles)this.logFiles, (FileSystemAbstraction)this.fileSystem, (long)version, (boolean)false)) != null) {
                ReadAheadLogChannel recoveredDataChannel = new ReadAheadLogChannel((LogVersionedStoreChannel)channel, LogVersionBridge.NO_MORE_CHANNELS);
                try (LogEntryCursor cursor = new LogEntryCursor(this.logEntryReader, (ReadableClosablePositionAwareChannel)recoveredDataChannel);){
                    while (cursor.next()) {
                        LogEntry entry = cursor.get();
                        if (!(entry instanceof CheckPoint)) continue;
                        checkPoints.add((CheckPoint)entry.as());
                    }
                }
                --version;
            }
            return checkPoints;
        }
    }
}

