/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;

public class DataSourceManagerTest {
    @Test
    public void shouldCallListenersOnStart() throws Throwable {
        DataSourceManager manager = new DataSourceManager();
        DataSourceManager.Listener listener = (DataSourceManager.Listener)Mockito.mock(DataSourceManager.Listener.class);
        manager.register((NeoStoreDataSource)Mockito.mock(NeoStoreDataSource.class));
        manager.addListener(listener);
        manager.start();
        ((DataSourceManager.Listener)Mockito.verify((Object)listener)).registered((NeoStoreDataSource)Matchers.any(NeoStoreDataSource.class));
    }

    @Test
    public void shouldCallListenersWhenAddedIfManagerAlreadyStarted() throws Throwable {
        DataSourceManager manager = new DataSourceManager();
        DataSourceManager.Listener listener = (DataSourceManager.Listener)Mockito.mock(DataSourceManager.Listener.class);
        manager.register((NeoStoreDataSource)Mockito.mock(NeoStoreDataSource.class));
        manager.start();
        manager.addListener(listener);
        ((DataSourceManager.Listener)Mockito.verify((Object)listener)).registered((NeoStoreDataSource)Matchers.any(NeoStoreDataSource.class));
    }

    @Test
    public void shouldCallListenersOnDataSourceRegistrationIfManagerAlreadyStarted() throws Throwable {
        DataSourceManager manager = new DataSourceManager();
        DataSourceManager.Listener listener = (DataSourceManager.Listener)Mockito.mock(DataSourceManager.Listener.class);
        manager.addListener(listener);
        manager.start();
        manager.register((NeoStoreDataSource)Mockito.mock(NeoStoreDataSource.class));
        ((DataSourceManager.Listener)Mockito.verify((Object)listener)).registered((NeoStoreDataSource)Matchers.any(NeoStoreDataSource.class));
    }

    @Test
    public void shouldSupportMultipleStartStopCycles() throws Throwable {
        DataSourceManager manager = new DataSourceManager();
        NeoStoreDataSource dataSource = (NeoStoreDataSource)Mockito.mock(NeoStoreDataSource.class);
        manager.register(dataSource);
        manager.init();
        manager.start();
        manager.stop();
        manager.start();
        ((NeoStoreDataSource)Mockito.verify((Object)dataSource, (VerificationMode)Mockito.times((int)2))).start();
    }
}

