/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;

public class DependencyResolverSupplierTest {
    @Test
    public void shouldReturnTheDependencyResolveFromTheRegisteredDatasource() throws Exception {
        DataSourceManager dataSourceManager = new DataSourceManager();
        DataSourceManager.DependencyResolverSupplier supplier = new DataSourceManager.DependencyResolverSupplier(dataSourceManager);
        NeoStoreDataSource neoStoreDataSource = (NeoStoreDataSource)Mockito.mock(NeoStoreDataSource.class);
        DependencyResolver dependencyResolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
        Mockito.when((Object)neoStoreDataSource.getDependencyResolver()).thenReturn((Object)dependencyResolver);
        dataSourceManager.register(neoStoreDataSource);
        Assert.assertEquals((Object)dependencyResolver, (Object)supplier.get());
    }

    @Test
    public void shouldReturnNullIfDataSourceHasBeenUnregistered() throws Exception {
        DataSourceManager dataSourceManager = new DataSourceManager();
        DataSourceManager.DependencyResolverSupplier supplier = new DataSourceManager.DependencyResolverSupplier(dataSourceManager);
        NeoStoreDataSource neoStoreDataSource = (NeoStoreDataSource)Mockito.mock(NeoStoreDataSource.class);
        DependencyResolver dependencyResolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
        Mockito.when((Object)neoStoreDataSource.getDependencyResolver()).thenReturn((Object)dependencyResolver);
        dataSourceManager.register(neoStoreDataSource);
        dataSourceManager.unregister(neoStoreDataSource);
        Assert.assertEquals(null, (Object)supplier.get());
    }
}

