/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.LegacyIndexProviderLookup;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.storemigration.StoreFile;
import org.neo4j.kernel.impl.storemigration.StoreFileType;
import org.neo4j.kernel.impl.transaction.state.NeoStoreFileListing;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StoreFileMetadata;
import org.neo4j.test.rule.EmbeddedDatabaseRule;

public class NeoStoreFileListingTest {
    @Rule
    public EmbeddedDatabaseRule db = new EmbeddedDatabaseRule(this.getClass());
    private NeoStoreDataSource neoStoreDataSource;
    private static final String[] STANDARD_STORE_DIR_FILES = new String[]{"lock", "debug.log", "neostore", "neostore.id", "neostore.counts.db.a", "neostore.counts.db.b", "neostore.labeltokenstore.db", "neostore.labeltokenstore.db.id", "neostore.labeltokenstore.db.names", "neostore.labeltokenstore.db.names.id", "neostore.nodestore.db", "neostore.nodestore.db.id", "neostore.nodestore.db.labels", "neostore.nodestore.db.labels.id", "neostore.propertystore.db", "neostore.propertystore.db.arrays", "neostore.propertystore.db.arrays.id", "neostore.propertystore.db.id", "neostore.propertystore.db.index", "neostore.propertystore.db.index.id", "neostore.propertystore.db.index.keys", "neostore.propertystore.db.index.keys.id", "neostore.propertystore.db.strings", "neostore.propertystore.db.strings.id", "neostore.relationshipstore.db", "neostore.relationshipstore.db.id", "neostore.relationshiptypestore.db", "neostore.relationshiptypestore.db.id", "neostore.relationshiptypestore.db.names", "neostore.relationshiptypestore.db.names.id", "neostore.schemastore.db", "neostore.schemastore.db.id", "neostore.transaction.db.active", "neostore.transaction.db.0", "neostore.transaction.db.1", "neostore.transaction.db.2", "store_lock"};
    private static final String[] STANDARD_STORE_DIR_DIRECTORIES = new String[]{"schema", "index", "branched"};

    @Before
    public void setUp() throws IOException {
        this.createIndexDbFile();
        this.neoStoreDataSource = (NeoStoreDataSource)this.db.getDependencyResolver().resolveDependency(NeoStoreDataSource.class);
    }

    private void createIndexDbFile() throws IOException {
        File storeDir = new File(this.db.getStoreDir());
        File indexFile = new File(storeDir, "index.db");
        if (!indexFile.exists()) {
            Assert.assertTrue((boolean)indexFile.createNewFile());
        }
    }

    private Set<String> expectedStoreFiles(boolean includeLogFiles) {
        HashSet<String> storeFileNames = new HashSet<String>();
        for (StoreType type : StoreType.values()) {
            if (type.equals((Object)StoreType.COUNTS)) continue;
            storeFileNames.add(type.getStoreFile().fileName(StoreFileType.STORE));
        }
        if (includeLogFiles) {
            storeFileNames.add("neostore.transaction.db.0");
        }
        storeFileNames.add("index.db");
        return storeFileNames;
    }

    private List<String> countStoreFiles() {
        ArrayList<String> countStoreFiles = new ArrayList<String>();
        countStoreFiles.add(StoreFile.COUNTS_STORE_LEFT.fileName(StoreFileType.STORE));
        countStoreFiles.add(StoreFile.COUNTS_STORE_RIGHT.fileName(StoreFileType.STORE));
        return countStoreFiles;
    }

    @Test
    public void shouldNotIncludeTransactionLogFile() throws Exception {
        ResourceIterator storeFiles = this.neoStoreDataSource.listStoreFiles(false);
        Set<String> actual = this.asSetOfPaths((ResourceIterator<StoreFileMetadata>)storeFiles);
        Set<String> expectedStoreFiles = this.expectedStoreFiles(false);
        List<String> countStoreFiles = this.countStoreFiles();
        Assert.assertTrue((String)this.diffSet(actual, expectedStoreFiles), (boolean)actual.containsAll(expectedStoreFiles));
        Assert.assertFalse((boolean)Collections.disjoint(actual, countStoreFiles));
    }

    @Test
    public void shouldIncludeTransactionLogFile() throws Exception {
        ResourceIterator storeFiles = this.neoStoreDataSource.listStoreFiles(true);
        Set<String> actual = this.asSetOfPaths((ResourceIterator<StoreFileMetadata>)storeFiles);
        Set<String> expectedStoreFiles = this.expectedStoreFiles(true);
        List<String> countStoreFiles = this.countStoreFiles();
        Assert.assertTrue((String)this.diffSet(actual, expectedStoreFiles), (boolean)actual.containsAll(expectedStoreFiles));
        Assert.assertFalse((boolean)Collections.disjoint(actual, countStoreFiles));
    }

    @Test
    public void shouldCloseIndexAndLabelScanSnapshots() throws Exception {
        LabelScanStore labelScanStore = (LabelScanStore)Mockito.mock(LabelScanStore.class);
        IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        LegacyIndexProviderLookup legacyIndexes = (LegacyIndexProviderLookup)Mockito.mock(LegacyIndexProviderLookup.class);
        Mockito.when((Object)legacyIndexes.all()).thenReturn(Collections.emptyList());
        File storeDir = (File)Mockito.mock(File.class);
        this.filesInStoreDirAre(storeDir, STANDARD_STORE_DIR_FILES, STANDARD_STORE_DIR_DIRECTORIES);
        StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
        NeoStoreFileListing fileListing = new NeoStoreFileListing(storeDir, labelScanStore, indexingService, legacyIndexes, storageEngine);
        ResourceIterator<File> scanSnapshot = this.scanStoreFilesAre(labelScanStore, new String[]{"blah/scan.store", "scan.more"});
        ResourceIterator<File> indexSnapshot = this.indexFilesAre(indexingService, new String[]{"schema/index/my.index"});
        ResourceIterator result = fileListing.listStoreFiles(false);
        result.close();
        ((ResourceIterator)Mockito.verify(scanSnapshot)).close();
        ((ResourceIterator)Mockito.verify(indexSnapshot)).close();
    }

    @Test
    public void shouldListNeostoreDbLast() throws Exception {
        Boolean[] foundStoreType = new Boolean[StoreType.values().length];
        boolean foundTxLogs = false;
        ResourceIterator storeFiles = this.neoStoreDataSource.listStoreFiles(true);
        while (storeFiles.hasNext()) {
            StoreFileMetadata storeFile = (StoreFileMetadata)storeFiles.next();
            if (storeFile.storeType().isPresent()) {
                StoreType storeType = (StoreType)storeFile.storeType().get();
                foundStoreType[storeType.ordinal()] = true;
                if (storeType != StoreType.META_DATA) continue;
                Arrays.stream(foundStoreType).forEach(Assert::assertTrue);
                Assert.assertTrue((String)"Transaction logs was not listed before neostore.db", (boolean)foundTxLogs);
                continue;
            }
            if (!this.transactionLogFile(storeFile.file().getName())) continue;
            foundTxLogs = true;
        }
    }

    private boolean transactionLogFile(String name) {
        return name.startsWith("neostore.transaction") && !name.endsWith(".active");
    }

    private void filesInStoreDirAre(File storeDir, String[] filenames, String[] dirs) {
        ArrayList<File> files = new ArrayList<File>();
        this.mockFiles(filenames, files, false);
        this.mockFiles(dirs, files, true);
        Mockito.when((Object)storeDir.listFiles()).thenReturn((Object)files.toArray(new File[files.size()]));
    }

    private String diffSet(Set<String> actual, Set<String> expected) {
        HashSet<String> extra = new HashSet<String>(actual);
        HashSet<String> missing = new HashSet<String>(expected);
        extra.removeAll(expected);
        missing.removeAll(actual);
        return "Extra entries: " + extra + "\nMissing entries: " + missing;
    }

    private Set<String> asSetOfPaths(ResourceIterator<StoreFileMetadata> result) {
        ArrayList<String> names = new ArrayList<String>();
        while (result.hasNext()) {
            names.add(((StoreFileMetadata)result.next()).file().getName());
        }
        return Iterables.asUniqueSet(names);
    }

    private ResourceIterator<File> scanStoreFilesAre(LabelScanStore labelScanStore, String[] fileNames) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        this.mockFiles(fileNames, files, false);
        ResourceIterator snapshot = (ResourceIterator)Mockito.spy((Object)Iterators.asResourceIterator(files.iterator()));
        Mockito.when((Object)labelScanStore.snapshotStoreFiles()).thenReturn((Object)snapshot);
        return snapshot;
    }

    private ResourceIterator<File> indexFilesAre(IndexingService indexingService, String[] fileNames) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        this.mockFiles(fileNames, files, false);
        ResourceIterator snapshot = (ResourceIterator)Mockito.spy((Object)Iterators.asResourceIterator(files.iterator()));
        Mockito.when((Object)indexingService.snapshotStoreFiles()).thenReturn((Object)snapshot);
        return snapshot;
    }

    private void mockFiles(String[] filenames, ArrayList<File> files, boolean isDirectories) {
        for (String filename : filenames) {
            File file = (File)Mockito.mock(File.class);
            String[] fileNameParts = filename.split("/");
            Mockito.when((Object)file.getName()).thenReturn((Object)fileNameParts[fileNameParts.length - 1]);
            Mockito.when((Object)file.isFile()).thenReturn((Object)(!isDirectories ? 1 : 0));
            Mockito.when((Object)file.isDirectory()).thenReturn((Object)isDirectories);
            Mockito.when((Object)file.exists()).thenReturn((Object)true);
            Mockito.when((Object)file.getPath()).thenReturn((Object)filename);
            files.add(file);
        }
    }
}

