/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.File;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.transaction.state.Loaders;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.transaction.state.RelationshipGroupGetter;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;
import org.neo4j.unsafe.batchinsert.DirectRecordAccess;

public class RelationshipGroupGetterTest {
    private final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private final PageCacheRule pageCache = new PageCacheRule();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.fs).around((TestRule)this.pageCache);

    @Test
    public void shouldAbortLoadingGroupChainIfComeTooFar() throws Exception {
        File dir = new File("dir");
        this.fs.get().mkdirs(dir);
        NullLogProvider logProvider = NullLogProvider.getInstance();
        StoreFactory storeFactory = new StoreFactory(dir, this.pageCache.getPageCache((FileSystemAbstraction)this.fs.get()), (FileSystemAbstraction)this.fs.get(), (LogProvider)logProvider);
        try (NeoStores stores = storeFactory.openNeoStores(true, new StoreType[]{StoreType.RELATIONSHIP_GROUP});){
            RecordStore store = (RecordStore)Mockito.spy((Object)stores.getRelationshipGroupStore());
            RelationshipGroupRecord group_2 = this.group(0L, 2);
            RelationshipGroupRecord group_4 = this.group(1L, 4);
            RelationshipGroupRecord group_10 = this.group(2L, 10);
            RelationshipGroupRecord group_23 = this.group(3L, 23);
            this.link(group_2, group_4, group_10, group_23);
            store.updateRecord((AbstractBaseRecord)group_2);
            store.updateRecord((AbstractBaseRecord)group_4);
            store.updateRecord((AbstractBaseRecord)group_10);
            store.updateRecord((AbstractBaseRecord)group_23);
            RelationshipGroupGetter groupGetter = new RelationshipGroupGetter(store);
            NodeRecord node = new NodeRecord(0L, true, group_2.getId(), -1L);
            DirectRecordAccess access = new DirectRecordAccess(store, Loaders.relationshipGroupLoader((RecordStore)store));
            RelationshipGroupGetter.RelationshipGroupPosition result = groupGetter.getRelationshipGroup(node, 7, (RecordAccess)access);
            InOrder verification = Mockito.inOrder((Object[])new Object[]{store});
            ((RecordStore)verification.verify((Object)store)).getRecord(Matchers.eq((long)group_2.getId()), (AbstractBaseRecord)Matchers.any(RelationshipGroupRecord.class), (RecordLoad)Matchers.any(RecordLoad.class));
            ((RecordStore)verification.verify((Object)store)).getRecord(Matchers.eq((long)group_4.getId()), (AbstractBaseRecord)Matchers.any(RelationshipGroupRecord.class), (RecordLoad)Matchers.any(RecordLoad.class));
            ((RecordStore)verification.verify((Object)store)).getRecord(Matchers.eq((long)group_10.getId()), (AbstractBaseRecord)Matchers.any(RelationshipGroupRecord.class), (RecordLoad)Matchers.any(RecordLoad.class));
            ((RecordStore)verification.verify((Object)store, Mockito.times((int)0))).getRecord(Matchers.eq((long)group_23.getId()), (AbstractBaseRecord)Matchers.any(RelationshipGroupRecord.class), (RecordLoad)Matchers.any(RecordLoad.class));
            Assert.assertNull((Object)result.group());
            Assert.assertEquals((Object)group_4, (Object)result.closestPrevious().forReadingData());
        }
    }

    private void link(RelationshipGroupRecord ... groups) {
        for (int i = 0; i < groups.length; ++i) {
            if (i > 0) {
                groups[i].setPrev(groups[i - 1].getId());
            }
            if (i >= groups.length - 1) continue;
            groups[i].setNext(groups[i + 1].getId());
        }
    }

    private RelationshipGroupRecord group(long id, int type) {
        RelationshipGroupRecord group = new RelationshipGroupRecord(id, type);
        group.setInUse(true);
        return group;
    }
}

