/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.transaction.state.storeview.LabelScanViewIdIterator;
import org.neo4j.kernel.impl.transaction.state.storeview.LabelScanViewNodeStoreScan;
import org.neo4j.storageengine.api.schema.LabelScanReader;

public class LabelScanViewIdIteratorTest {
    private LabelScanViewNodeStoreScan labelScanView = (LabelScanViewNodeStoreScan)Mockito.mock(LabelScanViewNodeStoreScan.class);
    private LabelScanStore labelScanStore = (LabelScanStore)Mockito.mock(LabelScanStore.class);
    private LabelScanReader labelScanReader = (LabelScanReader)Mockito.mock(LabelScanReader.class);
    private LabelScanViewIdIterator scanViewIdIterator;
    private PrimitiveLongIterator nodeIdsIterator = PrimitiveLongCollections.iterator((long[])new long[]{2L, 4L, 7L});

    @Before
    public void setUp() {
        this.setUpMocks();
        this.scanViewIdIterator = new LabelScanViewIdIterator(this.labelScanView, this.labelScanStore, new int[]{1, 2});
    }

    @Test
    public void iterateOverStoredLabelNodeIds() throws Exception {
        this.checkItem(this.scanViewIdIterator, 2L);
        this.checkItem(this.scanViewIdIterator, 4L);
        this.checkItem(this.scanViewIdIterator, 7L);
        Assert.assertFalse((String)"Should contain only 3 nodes.", (boolean)this.scanViewIdIterator.hasNext());
    }

    @Test
    public void iterateOverStoredLabelNodeIdsWithUpdates() {
        Mockito.when((Object)this.labelScanView.isOutdated()).thenReturn((Object)true);
        this.verifyOpenIteratorAndResetMocks();
        this.checkItem(this.scanViewIdIterator, 2L);
        this.verifyLabelScanReopenAndResetMocks();
        this.checkItem(this.scanViewIdIterator, 4L);
        this.verifyLabelScanReopenAndResetMocks();
        this.checkItem(this.scanViewIdIterator, 7L);
        this.verifyLabelScanReopenAndResetMocks();
        Assert.assertFalse((String)"Should contain only 3 nodes.", (boolean)this.scanViewIdIterator.hasNext());
    }

    @Test
    public void iterateOverIncreasedNumberOfAffectedStoredLabelNodeIds() {
        Mockito.when((Object)this.labelScanView.isOutdated()).thenReturn((Object)true);
        this.verifyOpenIteratorAndResetMocks();
        this.checkItem(this.scanViewIdIterator, 2L);
        this.verifyLabelScanReopenAndResetMocks();
        this.checkItem(this.scanViewIdIterator, 4L);
        this.nodeIdsIterator = PrimitiveLongCollections.iterator((long[])new long[]{2L, 3L, 4L, 5L, 6L, 7L});
        this.verifyLabelScanReopenAndResetMocks();
        this.checkItem(this.scanViewIdIterator, 5L);
        this.verifyLabelScanReopenAndResetMocks();
        this.checkItem(this.scanViewIdIterator, 6L);
        this.verifyLabelScanReopenAndResetMocks();
        this.checkItem(this.scanViewIdIterator, 7L);
        Assert.assertFalse((String)"Should iterate as result over 5 nodes.", (boolean)this.scanViewIdIterator.hasNext());
    }

    @Test
    public void iterateOverDecreasedNumberOfAffectedNodes() {
        Mockito.when((Object)this.labelScanView.isOutdated()).thenReturn((Object)true);
        this.verifyOpenIteratorAndResetMocks();
        this.checkItem(this.scanViewIdIterator, 2L);
        this.nodeIdsIterator = PrimitiveLongCollections.iterator((long[])new long[]{1L, 2L});
        this.verifyLabelScanReopenAndResetMocks();
        Assert.assertFalse((String)"Should iterate as result over 1 node only.", (boolean)this.scanViewIdIterator.hasNext());
    }

    private void setUpMocks() {
        Mockito.when((Object)this.labelScanStore.newReader()).thenReturn((Object)this.labelScanReader);
        Mockito.when((Object)this.labelScanReader.nodesWithAnyOfLabels(new int[]{1, 2})).thenReturn((Object)this.nodeIdsIterator);
    }

    private void verifyOpenIteratorAndResetMocks() {
        ((LabelScanStore)Mockito.verify((Object)this.labelScanStore)).newReader();
        ((LabelScanReader)Mockito.verify((Object)this.labelScanReader)).nodesWithAnyOfLabels(new int[]{1, 2});
        Mockito.reset((Object[])new Object[]{this.labelScanReader, this.labelScanStore});
        this.setUpMocks();
    }

    private void verifyLabelScanReopenAndResetMocks() {
        ((LabelScanReader)Mockito.verify((Object)this.labelScanReader)).close();
        this.verifyOpenIteratorAndResetMocks();
    }

    private void checkItem(LabelScanViewIdIterator scanViewIdIterator, long expectedItem) {
        Assert.assertTrue((String)"Should contain at least one more item.", (boolean)scanViewIdIterator.hasNext());
        Assert.assertEquals((String)"Item should be equal to expected.", (long)expectedItem, (long)scanViewIdIterator.next());
    }
}

