/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.Uniqueness;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.traversal.TraversalTestBase;

public class SmallestGraphEverTest
extends TraversalTestBase {
    @Before
    public void setup() {
        this.createGraph("1 TO 2");
    }

    @Test
    public void testUnrestrictedTraversalCanFinishDepthFirst() throws Exception {
        this.execute(this.getGraphDb().traversalDescription().depthFirst(), Uniqueness.NONE);
    }

    @Test
    public void testUnrestrictedTraversalCanFinishBreadthFirst() throws Exception {
        this.execute(this.getGraphDb().traversalDescription().breadthFirst(), Uniqueness.NONE);
    }

    @Test
    public void testNodeGlobalTraversalCanFinishDepthFirst() throws Exception {
        this.execute(this.getGraphDb().traversalDescription().depthFirst(), Uniqueness.NODE_GLOBAL);
    }

    @Test
    public void testNodeGlobalTraversalCanFinishBreadthFirst() throws Exception {
        this.execute(this.getGraphDb().traversalDescription().breadthFirst(), Uniqueness.NODE_GLOBAL);
    }

    @Test
    public void testRelationshipGlobalTraversalCanFinishDepthFirst() throws Exception {
        this.execute(this.getGraphDb().traversalDescription().depthFirst(), Uniqueness.RELATIONSHIP_GLOBAL);
    }

    @Test
    public void testRelationshipGlobalTraversalCanFinishBreadthFirst() throws Exception {
        this.execute(this.getGraphDb().traversalDescription().breadthFirst(), Uniqueness.RELATIONSHIP_GLOBAL);
    }

    @Test
    public void testNodePathTraversalCanFinishDepthFirst() throws Exception {
        this.execute(this.getGraphDb().traversalDescription().depthFirst(), Uniqueness.NODE_PATH);
    }

    @Test
    public void testNodePathTraversalCanFinishBreadthFirst() throws Exception {
        this.execute(this.getGraphDb().traversalDescription().breadthFirst(), Uniqueness.NODE_PATH);
    }

    @Test
    public void testRelationshipPathTraversalCanFinishDepthFirst() throws Exception {
        this.execute(this.getGraphDb().traversalDescription().depthFirst(), Uniqueness.RELATIONSHIP_PATH);
    }

    @Test
    public void testRelationshipPathTraversalCanFinishBreadthFirst() throws Exception {
        this.execute(this.getGraphDb().traversalDescription().breadthFirst(), Uniqueness.RELATIONSHIP_PATH);
    }

    @Test
    public void testNodeRecentTraversalCanFinishDepthFirst() throws Exception {
        this.execute(this.getGraphDb().traversalDescription().depthFirst(), Uniqueness.NODE_RECENT);
    }

    @Test
    public void testNodeRecentTraversalCanFinishBreadthFirst() throws Exception {
        this.execute(this.getGraphDb().traversalDescription().breadthFirst(), Uniqueness.NODE_RECENT);
    }

    @Test
    public void testRelationshipRecentTraversalCanFinishDepthFirst() throws Exception {
        this.execute(this.getGraphDb().traversalDescription().depthFirst(), Uniqueness.RELATIONSHIP_RECENT);
    }

    @Test
    public void testRelationshipRecentTraversalCanFinishBreadthFirst() throws Exception {
        this.execute(this.getGraphDb().traversalDescription().breadthFirst(), Uniqueness.RELATIONSHIP_RECENT);
    }

    private void execute(TraversalDescription traversal, Uniqueness uniqueness) {
        try (Transaction transaction = this.beginTx();){
            Traverser traverser = traversal.uniqueness((UniquenessFactory)uniqueness).traverse(this.node("1"));
            Assert.assertFalse((String)"empty traversal", (Iterables.count((Iterable)traverser) == 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testTraverseRelationshipsWithStartNodeNotIncluded() throws Exception {
        try (Transaction transaction = this.beginTx();){
            TraversalDescription traversal = this.getGraphDb().traversalDescription().evaluator(Evaluators.excludeStartPosition());
            Assert.assertEquals((long)1L, (long)Iterables.count((Iterable)traversal.traverse(this.node("1")).relationships()));
        }
    }
}

