/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;

public final class DatabaseFunctions {
    private DatabaseFunctions() {
        throw new AssertionError((Object)"Not for instantiation!");
    }

    public static Function<GraphDatabaseService, Node> createNode() {
        return GraphDatabaseService::createNode;
    }

    public static Function<Node, Node> addLabel(Label label) {
        return node -> {
            node.addLabel(label);
            return node;
        };
    }

    public static Function<Node, Node> setProperty(String propertyKey, Object value) {
        return node -> {
            node.setProperty(propertyKey, value);
            return node;
        };
    }

    public static Function<GraphDatabaseService, Void> index(Label label, String propertyKey) {
        return graphDb -> {
            graphDb.schema().indexFor(label).on(propertyKey).create();
            return null;
        };
    }

    public static Function<GraphDatabaseService, Void> uniquenessConstraint(Label label, String propertyKey) {
        return graphDb -> {
            graphDb.schema().constraintFor(label).assertPropertyIsUnique(propertyKey).create();
            return null;
        };
    }

    public static Function<GraphDatabaseService, Void> awaitIndexesOnline(long timeout, TimeUnit unit) {
        return graphDb -> {
            graphDb.schema().awaitIndexesOnline(timeout, unit);
            return null;
        };
    }
}

