/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.assertion;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.StringDescription;
import org.hamcrest.core.StringContains;
import org.neo4j.function.ThrowingAction;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.helpers.Strings;

public final class Assert {
    private Assert() {
    }

    public static <E extends Exception> void assertException(ThrowingAction<E> f, Class typeOfException, String partOfErrorMessage) throws Exception {
        try {
            f.apply();
            org.junit.Assert.fail((String)("Expected exception of type " + typeOfException + ", but no exception was thrown"));
        }
        catch (Exception e) {
            if (typeOfException.isInstance(e)) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)StringContains.containsString((String)partOfErrorMessage));
            }
            org.junit.Assert.fail((String)("Got unexpected exception " + e.getClass() + "\nExpected: " + typeOfException));
        }
    }

    public static void assertObjectOrArrayEquals(Object expected, Object actual) {
        Assert.assertObjectOrArrayEquals("", expected, actual);
    }

    public static void assertObjectOrArrayEquals(String message, Object expected, Object actual) {
        if (expected.getClass().isArray() ? !ArrayUtil.equals((Object)expected, (Object)actual) : !Objects.equals(expected, actual)) {
            throw Assert.newAssertionError(message, expected, actual);
        }
    }

    public static <T, E extends Exception> void assertEventually(String reason, ThrowingSupplier<T, E> actual, Matcher<? super T> matcher, long timeout, TimeUnit timeUnit) throws E, InterruptedException {
        boolean matched;
        Object last;
        long endTimeMillis = System.currentTimeMillis() + timeUnit.toMillis(timeout);
        while (true) {
            long sampleTime = System.currentTimeMillis();
            last = actual.get();
            matched = matcher.matches(last);
            if (matched || sampleTime > endTimeMillis) break;
            Thread.sleep(100L);
        }
        if (!matched) {
            StringDescription description = new StringDescription();
            description.appendText(reason).appendText("\nExpected: ").appendDescriptionOf(matcher).appendText("\n     but: ");
            matcher.describeMismatch(last, (Description)description);
            throw new AssertionError((Object)("Timeout hit (" + timeout + " " + timeUnit.toString().toLowerCase() + ") while waiting for condition to match: " + description.toString()));
        }
    }

    private static AssertionError newAssertionError(String message, Object expected, Object actual) {
        return new AssertionError((Object)((message == null || message.isEmpty() ? "" : message + "\n") + "Expected: " + Strings.prettyPrint((Object)expected) + ", actual: " + Strings.prettyPrint((Object)actual)));
    }
}

