/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.mockito.answer;

import java.util.concurrent.CountDownLatch;
import org.mockito.internal.stubbing.answers.Returns;
import org.mockito.internal.stubbing.answers.ThrowsException;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class AwaitAnswer<T>
implements Answer<T> {
    private final CountDownLatch latch;
    private final Answer<T> result;

    public static AwaitAnswer<Void> afterAwaiting(CountDownLatch latch) {
        return new AwaitAnswer<Void>(latch, null);
    }

    public AwaitAnswer(CountDownLatch latch, Answer<T> result) {
        this.latch = latch;
        this.result = result;
    }

    public T answer(InvocationOnMock invocation) throws Throwable {
        this.latch.await();
        return (T)(this.result == null ? null : this.result.answer(invocation));
    }

    public <R> Answer<R> then(Answer<R> result) {
        return new AwaitAnswer<R>(this.latch, result);
    }

    public <R> Answer<R> thenReturn(R result) {
        return this.then((Answer<R>)new Returns(result));
    }

    public <R> Answer<R> thenThrow(Throwable exception) {
        return this.then((Answer<R>)new ThrowsException(exception));
    }
}

