/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.mockito.matcher;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;

public class Neo4jMatchers {
    public static <T> Matcher<? super T> inTx(GraphDatabaseService db, Matcher<T> inner) {
        return Neo4jMatchers.inTx(db, inner, false);
    }

    public static <T> Matcher<? super T> inTx(final GraphDatabaseService db, final Matcher<T> inner, final boolean successful) {
        return new DiagnosingMatcher<T>(){

            protected boolean matches(Object item, Description mismatchDescription) {
                try (Transaction ignored = db.beginTx();){
                    if (inner.matches(item)) {
                        if (successful) {
                            ignored.success();
                        }
                        boolean bl = true;
                        return bl;
                    }
                    inner.describeMismatch(item, mismatchDescription);
                    if (successful) {
                        ignored.success();
                    }
                    boolean bl = false;
                    return bl;
                }
            }

            public void describeTo(Description description) {
                inner.describeTo(description);
            }
        };
    }

    public static TypeSafeDiagnosingMatcher<Node> hasLabel(final Label myLabel) {
        return new TypeSafeDiagnosingMatcher<Node>(){

            public void describeTo(Description description) {
                description.appendValue((Object)myLabel);
            }

            protected boolean matchesSafely(Node item, Description mismatchDescription) {
                boolean result = item.hasLabel(myLabel);
                if (!result) {
                    Set<String> labels = Neo4jMatchers.asLabelNameSet(item.getLabels());
                    mismatchDescription.appendText(labels.toString());
                }
                return result;
            }
        };
    }

    public static TypeSafeDiagnosingMatcher<Node> hasLabels(String ... expectedLabels) {
        return Neo4jMatchers.hasLabels(Iterators.asSet((Object[])expectedLabels));
    }

    public static TypeSafeDiagnosingMatcher<Node> hasLabels(Label ... expectedLabels) {
        HashSet<String> labelNames = new HashSet<String>(expectedLabels.length);
        for (Label l : expectedLabels) {
            labelNames.add(l.name());
        }
        return Neo4jMatchers.hasLabels(labelNames);
    }

    public static TypeSafeDiagnosingMatcher<Node> hasNoLabels() {
        return Neo4jMatchers.hasLabels(Iterators.emptySetOf(String.class));
    }

    public static TypeSafeDiagnosingMatcher<Node> hasLabels(final Set<String> expectedLabels) {
        return new TypeSafeDiagnosingMatcher<Node>(){
            private Set<String> foundLabels;

            public void describeTo(Description description) {
                description.appendText(expectedLabels.toString());
            }

            protected boolean matchesSafely(Node item, Description mismatchDescription) {
                this.foundLabels = Neo4jMatchers.asLabelNameSet(item.getLabels());
                if (this.foundLabels.size() == expectedLabels.size() && this.foundLabels.containsAll(expectedLabels)) {
                    return true;
                }
                mismatchDescription.appendText("was " + this.foundLabels.toString());
                return false;
            }
        };
    }

    public static TypeSafeDiagnosingMatcher<GraphDatabaseService> hasNoNodes(final Label withLabel) {
        return new TypeSafeDiagnosingMatcher<GraphDatabaseService>(){

            protected boolean matchesSafely(GraphDatabaseService db, Description mismatchDescription) {
                Set found = Iterators.asSet((Iterator)db.findNodes(withLabel));
                if (!found.isEmpty()) {
                    mismatchDescription.appendText("found " + found.toString());
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("no nodes with label " + withLabel);
            }
        };
    }

    public static TypeSafeDiagnosingMatcher<GraphDatabaseService> hasNodes(final Label withLabel, final Node ... expectedNodes) {
        return new TypeSafeDiagnosingMatcher<GraphDatabaseService>(){

            protected boolean matchesSafely(GraphDatabaseService db, Description mismatchDescription) {
                Set found;
                Set expected = Iterators.asSet((Object[])expectedNodes);
                if (!expected.equals(found = Iterators.asSet((Iterator)db.findNodes(withLabel)))) {
                    mismatchDescription.appendText("found " + found.toString());
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText(Iterators.asSet((Object[])expectedNodes).toString() + " with label " + withLabel);
            }
        };
    }

    public static Set<String> asLabelNameSet(Iterable<Label> enums) {
        return Iterables.asSet((Iterable)Iterables.map(Label::name, enums));
    }

    public static Matcher<? super Iterator<Long>> hasSamePrimitiveItems(final PrimitiveLongIterator actual) {
        return new TypeSafeDiagnosingMatcher<Iterator<Long>>(){
            int len = 0;
            String actualText = null;
            String expectedText = null;

            protected boolean matchesSafely(Iterator<Long> expected, Description actualDescription) {
                if (this.actualText != null) {
                    actualDescription.appendText(this.actualText);
                }
                while (expected.hasNext() && actual.hasNext()) {
                    long actualNext;
                    ++this.len;
                    Long expectedNext = expected.next();
                    if (expectedNext.equals(actualNext = actual.next())) continue;
                    this.actualText = String.format("Element %d at position %d", actualNext, this.len);
                    this.expectedText = String.format("Element %d at position %d", expectedNext, this.len);
                    return false;
                }
                if (expected.hasNext()) {
                    this.actualText = String.format("Length %d", this.len);
                    this.expectedText = String.format("Length %d", this.len + 1);
                    return false;
                }
                if (actual.hasNext()) {
                    this.actualText = String.format("Length %d", this.len + 1);
                    this.expectedText = String.format("Length %d", this.len);
                    return false;
                }
                return true;
            }

            public void describeTo(Description expectedDescription) {
                if (this.expectedText != null) {
                    expectedDescription.appendText(this.expectedText);
                }
            }
        };
    }

    public static PropertyMatcher hasProperty(String propertyName) {
        return new PropertyMatcher(propertyName);
    }

    public static Deferred<Node> findNodesByLabelAndProperty(final Label label, final String propertyName, final Object propertyValue, final GraphDatabaseService db) {
        return new Deferred<Node>(db){

            @Override
            protected Iterable<Node> manifest() {
                return Iterators.loop((Iterator)db.findNodes(label, propertyName, propertyValue));
            }
        };
    }

    public static Deferred<IndexDefinition> getIndexes(final GraphDatabaseService db, final Label label) {
        return new Deferred<IndexDefinition>(db){

            @Override
            protected Iterable<IndexDefinition> manifest() {
                return db.schema().getIndexes(label);
            }
        };
    }

    public static Deferred<String> getPropertyKeys(GraphDatabaseService db, final PropertyContainer propertyContainer) {
        return new Deferred<String>(db){

            @Override
            protected Iterable<String> manifest() {
                return propertyContainer.getPropertyKeys();
            }
        };
    }

    public static Deferred<ConstraintDefinition> getConstraints(final GraphDatabaseService db, final Label label) {
        return new Deferred<ConstraintDefinition>(db){

            @Override
            protected Iterable<ConstraintDefinition> manifest() {
                return db.schema().getConstraints(label);
            }
        };
    }

    public static Deferred<ConstraintDefinition> getConstraints(final GraphDatabaseService db, final RelationshipType type) {
        return new Deferred<ConstraintDefinition>(db){

            @Override
            protected Iterable<ConstraintDefinition> manifest() {
                return db.schema().getConstraints(type);
            }
        };
    }

    public static Deferred<ConstraintDefinition> getConstraints(final GraphDatabaseService db) {
        return new Deferred<ConstraintDefinition>(db){

            @Override
            protected Iterable<ConstraintDefinition> manifest() {
                return db.schema().getConstraints();
            }
        };
    }

    @SafeVarargs
    public static <T> TypeSafeDiagnosingMatcher<Deferred<T>> containsOnly(final T ... expectedObjects) {
        return new TypeSafeDiagnosingMatcher<Deferred<T>>(){

            protected boolean matchesSafely(Deferred<T> nodes, Description description) {
                Set found;
                Set expected = Iterators.asSet((Object[])expectedObjects);
                if (!expected.equals(found = Iterables.asSet(nodes.collection()))) {
                    description.appendText("found " + found.toString());
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("exactly " + Iterators.asSet((Object[])expectedObjects));
            }
        };
    }

    public static TypeSafeDiagnosingMatcher<Deferred<?>> hasSize(final int expectedSize) {
        return new TypeSafeDiagnosingMatcher<Deferred<?>>(){

            protected boolean matchesSafely(Deferred<?> nodes, Description description) {
                int foundSize = nodes.collection().size();
                if (foundSize != expectedSize) {
                    description.appendText("found " + nodes.collection().toString());
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("collection of size " + expectedSize);
            }
        };
    }

    public static TypeSafeDiagnosingMatcher<Deferred<IndexDefinition>> haveState(final GraphDatabaseService db, final Schema.IndexState expectedState) {
        return new TypeSafeDiagnosingMatcher<Deferred<IndexDefinition>>(){

            protected boolean matchesSafely(Deferred<IndexDefinition> indexes, Description description) {
                for (IndexDefinition current : indexes.collection()) {
                    Schema.IndexState currentState = db.schema().getIndexState(current);
                    if (currentState.equals((Object)expectedState)) continue;
                    description.appendValue((Object)current).appendText(" has state ").appendValue((Object)currentState);
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("all indexes have state " + expectedState);
            }
        };
    }

    @SafeVarargs
    public static <T> TypeSafeDiagnosingMatcher<Deferred<T>> contains(final T ... expectedObjects) {
        return new TypeSafeDiagnosingMatcher<Deferred<T>>(){

            protected boolean matchesSafely(Deferred<T> nodes, Description description) {
                Set expected = Iterators.asSet((Object[])expectedObjects);
                Set found = Iterables.asSet(nodes.collection());
                if (!found.containsAll(expected)) {
                    description.appendText("found " + found.toString());
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("contains " + Iterators.asSet((Object[])expectedObjects));
            }
        };
    }

    public static TypeSafeDiagnosingMatcher<Deferred<?>> isEmpty() {
        return new TypeSafeDiagnosingMatcher<Deferred<?>>(){

            protected boolean matchesSafely(Deferred<?> deferred, Description description) {
                Collection<?> collection = deferred.collection();
                if (!collection.isEmpty()) {
                    description.appendText("was " + collection.toString());
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("empty collection");
            }
        };
    }

    public static IndexDefinition createIndex(GraphDatabaseService beansAPI, Label label, String property) {
        IndexDefinition indexDef = Neo4jMatchers.createIndexNoWait(beansAPI, label, property);
        Neo4jMatchers.waitForIndex(beansAPI, indexDef);
        return indexDef;
    }

    public static IndexDefinition createIndexNoWait(GraphDatabaseService beansAPI, Label label, String property) {
        IndexDefinition indexDef;
        try (Transaction tx = beansAPI.beginTx();){
            indexDef = beansAPI.schema().indexFor(label).on(property).create();
            tx.success();
        }
        return indexDef;
    }

    public static void waitForIndex(GraphDatabaseService beansAPI, IndexDefinition indexDef) {
        try (Transaction ignored = beansAPI.beginTx();){
            beansAPI.schema().awaitIndexOnline(indexDef, 10L, TimeUnit.SECONDS);
        }
    }

    public static void waitForIndexes(GraphDatabaseService beansAPI) {
        try (Transaction ignored = beansAPI.beginTx();){
            beansAPI.schema().awaitIndexesOnline(10L, TimeUnit.SECONDS);
        }
    }

    public static Object getIndexState(GraphDatabaseService beansAPI, IndexDefinition indexDef) {
        try (Transaction ignored = beansAPI.beginTx();){
            Schema.IndexState indexState = beansAPI.schema().getIndexState(indexDef);
            return indexState;
        }
    }

    public static ConstraintDefinition createConstraint(GraphDatabaseService db, Label label, String propertyKey) {
        try (Transaction tx = db.beginTx();){
            ConstraintDefinition constraint = db.schema().constraintFor(label).assertPropertyIsUnique(propertyKey).create();
            tx.success();
            ConstraintDefinition constraintDefinition = constraint;
            return constraintDefinition;
        }
    }

    public static Collection<Object> arrayAsCollection(Object arrayValue) {
        assert (arrayValue.getClass().isArray());
        ArrayList<Object> result = new ArrayList<Object>();
        int length = Array.getLength(arrayValue);
        for (int i = 0; i < length; ++i) {
            result.add(Array.get(arrayValue, i));
        }
        return result;
    }

    public static abstract class Deferred<T> {
        private final GraphDatabaseService db;

        public Deferred(GraphDatabaseService db) {
            this.db = db;
        }

        protected abstract Iterable<T> manifest();

        public Collection<T> collection() {
            try (Transaction ignore = this.db.beginTx();){
                Collection collection = Iterables.asCollection(this.manifest());
                return collection;
            }
        }
    }

    public static class PropertyMatcher
    extends TypeSafeDiagnosingMatcher<PropertyContainer> {
        public final String propertyName;

        private PropertyMatcher(String propertyName) {
            this.propertyName = propertyName;
        }

        protected boolean matchesSafely(PropertyContainer propertyContainer, Description mismatchDescription) {
            if (!propertyContainer.hasProperty(this.propertyName)) {
                mismatchDescription.appendText(String.format("found property container with property keys: %s", Iterables.asSet((Iterable)propertyContainer.getPropertyKeys())));
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendText(String.format("property container with property name '%s' ", this.propertyName));
        }

        public PropertyValueMatcher withValue(Object value) {
            return new PropertyValueMatcher(this, this.propertyName, value);
        }
    }

    public static class PropertyValueMatcher
    extends TypeSafeDiagnosingMatcher<PropertyContainer> {
        private final PropertyMatcher propertyMatcher;
        private final String propertyName;
        private final Object expectedValue;

        private PropertyValueMatcher(PropertyMatcher propertyMatcher, String propertyName, Object expectedValue) {
            this.propertyMatcher = propertyMatcher;
            this.propertyName = propertyName;
            this.expectedValue = expectedValue;
        }

        protected boolean matchesSafely(PropertyContainer propertyContainer, Description mismatchDescription) {
            if (!this.propertyMatcher.matchesSafely(propertyContainer, mismatchDescription)) {
                return false;
            }
            Object foundValue = propertyContainer.getProperty(this.propertyName);
            if (!this.propertyValuesEqual(this.expectedValue, foundValue)) {
                mismatchDescription.appendText("found value " + this.formatValue(foundValue));
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            this.propertyMatcher.describeTo(description);
            description.appendText(String.format("having value %s", this.formatValue(this.expectedValue)));
        }

        private boolean propertyValuesEqual(Object expected, Object readValue) {
            if (expected.getClass().isArray()) {
                return Neo4jMatchers.arrayAsCollection(expected).equals(Neo4jMatchers.arrayAsCollection(readValue));
            }
            return expected.equals(readValue);
        }

        private String formatValue(Object v) {
            if (v instanceof String) {
                return String.format("'%s'", v.toString());
            }
            return v.toString();
        }
    }
}

