/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule;

import java.io.File;
import java.io.IOException;
import org.junit.rules.TemporaryFolder;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.TestDirectory;

public class EmbeddedDatabaseRule
extends DatabaseRule {
    private final TempDirectory temp;
    private Config config = Config.empty();

    public EmbeddedDatabaseRule() {
        this.temp = new TempDirectory(){
            private final TemporaryFolder folder = new TemporaryFolder();

            @Override
            public File root() {
                return this.folder.getRoot();
            }

            @Override
            public void delete() {
                this.folder.delete();
            }

            @Override
            public void create() throws IOException {
                this.folder.create();
            }
        };
    }

    public EmbeddedDatabaseRule(final Class<?> testClass) {
        this.temp = new TempDirectory(){
            private final DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
            private final TestDirectory testDirectory = TestDirectory.testDirectory((Class)testClass, (FileSystemAbstraction)this.fs);
            private File dbDir;

            @Override
            public File root() {
                return this.dbDir;
            }

            @Override
            public void delete() throws IOException {
                this.testDirectory.cleanup();
                this.fs.close();
            }

            @Override
            public void create() throws IOException {
                this.dbDir = this.testDirectory.makeGraphDbDir();
            }
        };
    }

    public EmbeddedDatabaseRule(final File storeDir) {
        this.temp = new TempDirectory(){

            @Override
            public File root() {
                return storeDir;
            }

            @Override
            public void delete() throws IOException {
                FileUtils.deleteRecursively((File)storeDir);
            }

            @Override
            public void create() throws IOException {
                if (!storeDir.isDirectory() && !storeDir.mkdirs()) {
                    throw new IOException("Failed to create test directory: " + storeDir);
                }
            }
        };
    }

    @Override
    public EmbeddedDatabaseRule startLazily() {
        return (EmbeddedDatabaseRule)super.startLazily();
    }

    public EmbeddedDatabaseRule withConfig(Config config) {
        this.config = config;
        return this;
    }

    @Override
    public String getStoreDir() {
        return this.temp.root().getPath();
    }

    @Override
    public String getStoreDirAbsolutePath() {
        return this.temp.root().getAbsolutePath();
    }

    @Override
    protected GraphDatabaseFactory newFactory() {
        return new TestGraphDatabaseFactory();
    }

    @Override
    protected GraphDatabaseBuilder newBuilder(GraphDatabaseFactory factory) {
        return factory.newEmbeddedDatabaseBuilder(this.temp.root().getAbsoluteFile()).setConfig(this.config.getParams());
    }

    @Override
    protected void createResources() throws IOException {
        this.temp.create();
    }

    @Override
    protected void deleteResources() {
        try {
            this.temp.delete();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static interface TempDirectory {
        public File root();

        public void create() throws IOException;

        public void delete() throws IOException;
    }
}

