/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule;

import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TimeRule
implements TestRule {
    private long time;
    private String name;

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                TimeRule.this.time("start");
                try {
                    base.evaluate();
                }
                finally {
                    TimeRule.this.time("end");
                }
            }
        };
    }

    public void time(String name) {
        this.name = name;
        if (this.time == 0L) {
            this.time = System.currentTimeMillis();
        } else {
            long now = System.currentTimeMillis();
            long diff = now - this.time;
            System.out.println((name != null ? name + " " : "") + diff);
            this.time = now;
        }
    }

    public void time() {
        this.time(this.grabFromStackTrace());
    }

    private String grabFromStackTrace() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        return stack[3].getMethodName() + ":" + stack[3].getLineNumber();
    }
}

